/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.discoveryengine.auditlog.DiscoveryEngineAuditCode;
import org.odpi.openmetadata.accessservices.discoveryengine.connectors.outtopic.DiscoveryEngineOutTopicClientProvider;
import org.odpi.openmetadata.accessservices.discoveryengine.connectors.outtopic.DiscoveryEngineOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.discoveryengine.connectors.outtopic.DiscoveryEngineOutTopicServerProvider;
import org.odpi.openmetadata.accessservices.discoveryengine.ffdc.DiscoveryEngineErrorCode;
import org.odpi.openmetadata.accessservices.discoveryengine.outtopic.DiscoveryEngineOMRSTopicListener;
import org.odpi.openmetadata.accessservices.discoveryengine.outtopic.DiscoveryEnginePublisher;
import org.odpi.openmetadata.accessservices.discoveryengine.server.DiscoveryEngineServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DiscoveryEngineAdmin
extends AccessServiceAdmin {
    private OMRSAuditLog auditLog = null;
    private DiscoveryEngineServicesInstance instance = null;
    private String serverName = null;
    private DiscoveryEnginePublisher eventPublisher = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        DiscoveryEngineAuditCode auditCode = DiscoveryEngineAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        this.auditLog = auditLog;
        try {
            List supportedZones = super.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List defaultZones = super.extractDefaultZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new DiscoveryEngineServicesInstance(repositoryConnector, supportedZones, defaultZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize(), this.getOutTopicConnection(accessServiceConfig.getAccessServiceOutTopic(), AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceFullName(), DiscoveryEngineOutTopicClientProvider.class.getName(), auditLog));
            this.serverName = this.instance.getServerName();
            Connection outTopicEventBusConnection = accessServiceConfig.getAccessServiceOutTopic();
            if (outTopicEventBusConnection != null) {
                Endpoint endpoint = outTopicEventBusConnection.getEndpoint();
                OMRSAuditLog outTopicAuditLog = auditLog.createNewAuditLog(OMRSAuditingComponent.OMAS_OUT_TOPIC);
                Connection serverSideOutTopicConnection = this.getOutTopicConnection(accessServiceConfig.getAccessServiceOutTopic(), AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceFullName(), DiscoveryEngineOutTopicServerProvider.class.getName(), auditLog);
                DiscoveryEngineOutTopicServerConnector outTopicServerConnector = (DiscoveryEngineOutTopicServerConnector)super.getTopicConnector(serverSideOutTopicConnection, DiscoveryEngineOutTopicServerConnector.class, outTopicAuditLog, AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceFullName(), "initialize");
                this.eventPublisher = new DiscoveryEnginePublisher(outTopicServerConnector, endpoint.getAddress(), outTopicAuditLog);
                this.registerWithEnterpriseTopic(AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceFullName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)new DiscoveryEngineOMRSTopicListener(AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceFullName(), this.eventPublisher, repositoryConnector.getRepositoryHelper(), outTopicAuditLog), auditLog);
            }
            auditCode = DiscoveryEngineAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.serverName}), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
        catch (OMAGConfigurationErrorException error) {
            auditCode = DiscoveryEngineAuditCode.SERVICE_INSTANCE_FAILURE;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{error.getMessage()}), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
            throw error;
        }
        catch (Throwable error) {
            auditCode = DiscoveryEngineAuditCode.UNEXPECTED_INITIALIZATION_EXCEPTION;
            auditLog.logException("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{error.getClass().getName(), error.getMessage()}), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction(), error);
            DiscoveryEngineErrorCode errorCode = DiscoveryEngineErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getClass().getName(), AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceFullName(), this.serverName, error.getMessage()});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "initialize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.disconnect();
        }
        DiscoveryEngineAuditCode auditCode = DiscoveryEngineAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.serverName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

