/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.outtopic;

import java.util.List;
import org.odpi.openmetadata.accessservices.discoveryengine.auditlog.DiscoveryEngineAuditCode;
import org.odpi.openmetadata.accessservices.discoveryengine.connectors.outtopic.DiscoveryEngineOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.discoveryengine.events.DiscoveryEngineConfigurationEvent;
import org.odpi.openmetadata.accessservices.discoveryengine.events.DiscoveryEngineEvent;
import org.odpi.openmetadata.accessservices.discoveryengine.events.DiscoveryEngineEventType;
import org.odpi.openmetadata.accessservices.discoveryengine.events.DiscoveryServiceConfigurationEvent;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;

public class DiscoveryEnginePublisher {
    DiscoveryEngineOutTopicServerConnector outTopicServerConnector;
    OMRSAuditLog outTopicAuditLog;
    String outTopicName;
    final String actionDescription = "Out topic configuration refresh event publishing";

    public DiscoveryEnginePublisher(DiscoveryEngineOutTopicServerConnector outTopicServerConnector, String outTopicName, OMRSAuditLog outTopicAuditLog) {
        this.outTopicServerConnector = outTopicServerConnector;
        this.outTopicAuditLog = outTopicAuditLog;
        this.outTopicName = outTopicName;
        if (outTopicAuditLog != null) {
            DiscoveryEngineAuditCode auditCode = DiscoveryEngineAuditCode.SERVICE_PUBLISHING;
            outTopicAuditLog.logRecord("Out topic configuration refresh event publishing", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{outTopicName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public void publishRefreshDiscoveryEngineEvent(String discoveryEngineGUID, String discoveryEngineName) {
        String methodName = "publishRefreshDiscoveryEngineEvent";
        if (this.outTopicServerConnector != null) {
            try {
                DiscoveryEngineConfigurationEvent newEvent = new DiscoveryEngineConfigurationEvent();
                newEvent.setEventType(DiscoveryEngineEventType.REFRESH_DISCOVERY_ENGINE_EVENT);
                newEvent.setDiscoveryEngineGUID(discoveryEngineGUID);
                newEvent.setDiscoveryEngineName(discoveryEngineName);
                this.outTopicServerConnector.sendEvent((DiscoveryEngineEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    DiscoveryEngineAuditCode auditCode = DiscoveryEngineAuditCode.REFRESH_DISCOVERY_ENGINE;
                    this.outTopicAuditLog.logRecord("Out topic configuration refresh event publishing", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{discoveryEngineName, discoveryEngineGUID}), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(discoveryEngineGUID, discoveryEngineName, error, "publishRefreshDiscoveryEngineEvent");
            }
        }
    }

    public void publishRefreshDiscoveryServiceEvent(String discoveryEngineGUID, String discoveryEngineName, String registeredDiscoveryServiceGUID, List<String> discoveryRequestTypes) {
        String methodName = "publishRefreshDiscoveryServiceEvent";
        if (this.outTopicServerConnector != null) {
            try {
                DiscoveryServiceConfigurationEvent newEvent = new DiscoveryServiceConfigurationEvent();
                newEvent.setEventType(DiscoveryEngineEventType.REFRESH_DISCOVERY_SERVICE_EVENT);
                newEvent.setDiscoveryEngineGUID(discoveryEngineGUID);
                newEvent.setDiscoveryEngineName(discoveryEngineName);
                newEvent.setRegisteredDiscoveryServiceGUID(registeredDiscoveryServiceGUID);
                newEvent.setDiscoveryRequestTypes(discoveryRequestTypes);
                this.outTopicServerConnector.sendEvent((DiscoveryEngineEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    DiscoveryEngineAuditCode auditCode = DiscoveryEngineAuditCode.REFRESH_DISCOVERY_SERVICE;
                    this.outTopicAuditLog.logRecord("Out topic configuration refresh event publishing", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{discoveryEngineName, discoveryEngineGUID, discoveryRequestTypes.toString(), registeredDiscoveryServiceGUID}), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(discoveryEngineGUID, discoveryEngineName, error, "publishRefreshDiscoveryServiceEvent");
            }
        }
    }

    private void logUnexpectedPublishingException(String discoveryEngineGUID, String discoveryEngineName, Throwable error, String methodName) {
        if (this.outTopicAuditLog != null) {
            DiscoveryEngineAuditCode auditCode = DiscoveryEngineAuditCode.OUT_TOPIC_FAILURE;
            this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.outTopicName, error.getClass().getName(), error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction(), error);
        }
    }

    public void disconnect() {
        block3: {
            try {
                this.outTopicServerConnector.disconnect();
                if (this.outTopicAuditLog != null) {
                    DiscoveryEngineAuditCode auditCode = DiscoveryEngineAuditCode.PUBLISHING_SHUTDOWN;
                    this.outTopicAuditLog.logRecord("Out topic configuration refresh event publishing", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.outTopicName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
            }
            catch (Throwable error) {
                if (this.outTopicAuditLog == null) break block3;
                DiscoveryEngineAuditCode auditCode = DiscoveryEngineAuditCode.PUBLISHING_SHUTDOWN_ERROR;
                this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{error.getClass().getName(), this.outTopicName, error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction(), error);
            }
        }
    }
}

