/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.server;

import org.odpi.openmetadata.accessservices.discoveryengine.ffdc.DiscoveryEngineAuditCode;
import org.odpi.openmetadata.accessservices.discoveryengine.server.DiscoveryEngineServiceInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AssetHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.AnnotationHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.DiscoveryAnalysisReportHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.StatusRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.slf4j.LoggerFactory;

public class DiscoveryEngineRESTServices {
    private static DiscoveryEngineServiceInstanceHandler instanceHandler = new DiscoveryEngineServiceInstanceHandler();
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DiscoveryEngineRESTServices.class), instanceHandler.getServiceName());

    public GUIDListResponse getAssets(String serverName, String userId, int startFrom, int pageSize, NullRequestBody requestBody) {
        String methodName = "getAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssets");
        AuditLog auditLog = null;
        GUIDListResponse response = new GUIDListResponse();
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssets");
            response.setGUIDs(handler.assetGUIDsScan(userId, null, null, startFrom, pageSize, "getAssets"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByQualifiedName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getAssetsByQualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByQualifiedName");
        AuditLog auditLog = null;
        GUIDListResponse response = new GUIDListResponse();
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByQualifiedName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByQualifiedName");
            response.setGUIDs(handler.getAssetGUIDsByQualifiedName(userId, name, startFrom, pageSize, "getAssetsByQualifiedName"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAssetsByQualifiedName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getAssetsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByName");
        AuditLog auditLog = null;
        GUIDListResponse response = new GUIDListResponse();
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByName");
            response.setGUIDs(handler.getAssetGUIDsByName(userId, name, startFrom, pageSize, "getAssetsByName"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAssetsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse findAssets(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAssets");
        AuditLog auditLog = null;
        GUIDListResponse response = new GUIDListResponse();
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "findAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssets");
            response.setGUIDs(handler.findAssetGUIDs(userId, searchString, startFrom, pageSize, "findAssets"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "findAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByEndpoint(String serverName, String userId, String networkAddress, int startFrom, int pageSize) {
        String methodName = "findAssetsByEndpoint";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAssetsByEndpoint");
        AuditLog auditLog = null;
        GUIDListResponse response = new GUIDListResponse();
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "findAssetsByEndpoint");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssetsByEndpoint");
            response.setGUIDs(handler.getAssetGUIDsByEndpoint(userId, networkAddress, startFrom, pageSize, "findAssetsByEndpoint"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "findAssetsByEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse logAssetAuditMessage(String serverName, String userId, String assetGUID, String discoveryService, String message) {
        String methodName = "logAssetAuditMessage";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "logAssetAuditMessage");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "logAssetAuditMessage");
            auditLog.logMessage("logAssetAuditMessage", DiscoveryEngineAuditCode.ASSET_AUDIT_LOG.getMessageDefinition(new String[]{assetGUID, discoveryService, message}));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "logAssetAuditMessage", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDiscoveryAnalysisReport(String serverName, String userId, String assetGUID, DiscoveryAnalysisReportRequestBody requestBody) {
        String methodName = "createDiscoveryAnalysisReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDiscoveryAnalysisReport");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDiscoveryAnalysisReport", serverName);
            } else {
                DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "createDiscoveryAnalysisReport");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createDiscoveryAnalysisReport");
                response.setGUID(handler.createDiscoveryAnalysisReport(userId, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getCreationDate(), requestBody.getAnalysisParameters(), requestBody.getDiscoveryRequestStatus(), assetGUID, requestBody.getDiscoveryEngineGUID(), requestBody.getDiscoveryServiceGUID(), requestBody.getAdditionalProperties(), "createDiscoveryAnalysisReport"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "createDiscoveryAnalysisReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDiscoveryAnalysisReport(String serverName, String userId, String discoveryReportGUID, DiscoveryAnalysisReport requestBody) {
        String methodName = "updateDiscoveryAnalysisReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDiscoveryAnalysisReport");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDiscoveryAnalysisReport", serverName);
            }
            DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "updateDiscoveryAnalysisReport");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDiscoveryAnalysisReport");
            handler.updateDiscoveryAnalysisReport(userId, discoveryReportGUID, requestBody);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "updateDiscoveryAnalysisReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DiscoveryAnalysisReportResponse getDiscoveryAnalysisReport(String serverName, String userId, String discoveryReportGUID) {
        String methodName = "getDiscoveryAnalysisReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryAnalysisReport");
        AuditLog auditLog = null;
        DiscoveryAnalysisReportResponse response = new DiscoveryAnalysisReportResponse();
        try {
            DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "getDiscoveryAnalysisReport");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryAnalysisReport");
            response.setAnalysisReport(handler.getDiscoveryAnalysisReport(userId, discoveryReportGUID, "getDiscoveryAnalysisReport"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryAnalysisReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NameListResponse getTypesOfAnnotation(String serverName, String userId) {
        String methodName = "getTypesOfAnnotation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTypesOfAnnotation");
        NameListResponse response = new NameListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypesOfAnnotation");
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "getTypesOfAnnotation");
            response.setNames(handler.getTypesOfAnnotation());
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getTypesOfAnnotation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public StringMapResponse getTypesOfAnnotationWithDescriptions(String serverName, String userId) {
        String methodName = "getTypesOfAnnotationWithDescriptions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTypesOfAnnotationWithDescriptions");
        StringMapResponse response = new StringMapResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypesOfAnnotationWithDescriptions");
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "getTypesOfAnnotationWithDescriptions");
            response.setStringMap(handler.getTypesOfAnnotationDescriptions());
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getTypesOfAnnotationWithDescriptions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationListResponse getAnnotationsForAssetByStatus(String serverName, String userId, String assetGUID, int startingFrom, int maximumResults, StatusRequestBody requestBody) {
        String methodName = "getAnnotationsForAssetByStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAnnotationsForAssetByStatus");
        AuditLog auditLog = null;
        AnnotationListResponse response = new AnnotationListResponse();
        AnnotationStatus status = null;
        if (requestBody != null) {
            status = requestBody.getAnnotationStatus();
        }
        try {
            DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "getAnnotationsForAssetByStatus");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAnnotationsForAssetByStatus");
            response.setAnnotations(handler.getAnnotationsForAssetByStatus(userId, assetGUID, status, startingFrom, maximumResults, "getAnnotationsForAssetByStatus"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAnnotationsForAssetByStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationListResponse getDiscoveryReportAnnotations(String serverName, String userId, String discoveryReportGUID, int startingFrom, int maximumResults) {
        String methodName = "getDiscoveryReportAnnotations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryReportAnnotations");
        AuditLog auditLog = null;
        AnnotationListResponse response = new AnnotationListResponse();
        try {
            DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "getDiscoveryReportAnnotations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryReportAnnotations");
            response.setAnnotations(handler.getDiscoveryReportAnnotations(userId, discoveryReportGUID, null, startingFrom, maximumResults, "getDiscoveryReportAnnotations"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryReportAnnotations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationListResponse getExtendedAnnotations(String serverName, String userId, String annotationGUID, int startingFrom, int maximumResults) {
        String methodName = "getExtendedAnnotations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExtendedAnnotations");
        AuditLog auditLog = null;
        AnnotationListResponse response = new AnnotationListResponse();
        try {
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "getExtendedAnnotations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExtendedAnnotations");
            response.setAnnotations(handler.getExtendedAnnotations(userId, annotationGUID, null, startingFrom, maximumResults, "getExtendedAnnotations"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getExtendedAnnotations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationResponse getAnnotation(String serverName, String userId, String annotationGUID) {
        String methodName = "getAnnotation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAnnotation");
        AuditLog auditLog = null;
        AnnotationResponse response = new AnnotationResponse();
        try {
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "getAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAnnotation");
            response.setAnnotation(handler.getAnnotation(userId, annotationGUID, "getAnnotation"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAnnotation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addAnnotationToDiscoveryReport(String serverName, String userId, String discoveryReportGUID, Annotation requestBody) {
        String methodName = "addAnnotationToDiscoveryReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAnnotationToDiscoveryReport");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "addAnnotationToDiscoveryReport", serverName);
            }
            DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "addAnnotationToDiscoveryReport");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addAnnotationToDiscoveryReport");
            response.setGUID(handler.addAnnotationToDiscoveryReport(userId, discoveryReportGUID, requestBody, "addAnnotationToDiscoveryReport"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addAnnotationToDiscoveryReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addAnnotationToAnnotation(String serverName, String userId, String anchorAnnotationGUID, Annotation requestBody) {
        String methodName = "addAnnotationToAnnotation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAnnotationToAnnotation");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "addAnnotationToAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addAnnotationToAnnotation");
            response.setGUID(handler.addAnnotationToAnnotation(userId, anchorAnnotationGUID, requestBody, "addAnnotationToAnnotation"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addAnnotationToAnnotation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAnnotation(String serverName, String userId, String annotationGUID, Annotation requestBody) {
        String methodName = "updateAnnotation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAnnotation");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "updateAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAnnotation");
            handler.updateAnnotation(userId, annotationGUID, requestBody, "updateAnnotation");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "updateAnnotation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteAnnotation(String serverName, String userId, String annotationGUID, NullRequestBody requestBody) {
        String methodName = "deleteAnnotation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteAnnotation");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "deleteAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteAnnotation");
            handler.deleteAnnotation(userId, annotationGUID, "deleteAnnotation");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "deleteAnnotation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

