/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.discoveryengine.ffdc.DiscoveryEngineErrorCode;
import org.odpi.openmetadata.accessservices.discoveryengine.handlers.DiscoveryConfigurationHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.ODFOMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DiscoveryEngineServicesInstance
extends ODFOMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.DISCOVERY_ENGINE_OMAS;
    private DiscoveryConfigurationHandler discoveryConfigurationHandler;
    private Connection outTopicConnection;

    public DiscoveryEngineServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, AuditLog auditLog, String localServerUserId, int maxPageSize, Connection outTopicConnection) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, supportedZones, defaultZones, auditLog, localServerUserId, maxPageSize);
        String methodName = "new ServiceInstance";
        this.supportedZones = supportedZones;
        this.defaultZones = defaultZones;
        this.outTopicConnection = outTopicConnection;
        if (this.repositoryHandler == null) {
            throw new NewInstanceException(DiscoveryEngineErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.discoveryConfigurationHandler = new DiscoveryConfigurationHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler, this.errorHandler, this.connectionHandler);
    }

    Connection getOutTopicConnection() {
        return this.outTopicConnection;
    }

    DiscoveryConfigurationHandler getDiscoveryConfigurationHandler() {
        return this.discoveryConfigurationHandler;
    }
}

