/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.outtopic;

import java.util.List;
import org.odpi.openmetadata.accessservices.discoveryengine.outtopic.DiscoveryEnginePublisher;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DiscoveryEngineOMRSTopicListener
extends OMRSTopicListenerBase {
    private DiscoveryEnginePublisher eventPublisher;
    private OMRSRepositoryHelper repositoryHelper;

    public DiscoveryEngineOMRSTopicListener(String serviceName, DiscoveryEnginePublisher eventPublisher, OMRSRepositoryHelper repositoryHelper, AuditLog auditLog) {
        super(serviceName, auditLog);
        this.eventPublisher = eventPublisher;
        this.repositoryHelper = repositoryHelper;
    }

    private void processEntityDetail(String sourceName, EntityDetail entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "OpenDiscoveryEngine")) {
            this.eventPublisher.publishRefreshDiscoveryEngineEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, "qualifiedName", entity.getProperties(), methodName));
        }
    }

    private void processRelationship(String sourceName, Relationship relationship, String methodName) {
        EntityProxy end2;
        InstanceType type;
        if (relationship != null && (type = relationship.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "SupportedDiscoveryService") && (end2 = relationship.getEntityTwoProxy()) != null) {
            this.eventPublisher.publishRefreshDiscoveryServiceEvent(end2.getGUID(), this.repositoryHelper.getStringProperty(sourceName, "qualifiedName", end2.getUniqueProperties(), methodName), relationship.getGUID(), this.repositoryHelper.getStringArrayProperty(sourceName, "discoveryRequestTypes", relationship.getProperties(), methodName));
        }
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processNewEntityEvent";
        this.processEntityDetail(sourceName, entity, "processNewEntityEvent");
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        String methodName = "processUpdatedEntityEvent";
        this.processEntityDetail(sourceName, newEntity, "processUpdatedEntityEvent");
    }

    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processUndoneEntityEvent";
        this.processEntityDetail(sourceName, entity, "processUndoneEntityEvent");
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processClassifiedEntityEvent";
        this.processEntityDetail(sourceName, entity, "processClassifiedEntityEvent");
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeclassifiedEntityEvent";
        this.processEntityDetail(sourceName, entity, "processDeclassifiedEntityEvent");
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processReclassifiedEntityEvent";
        this.processEntityDetail(sourceName, entity, "processReclassifiedEntityEvent");
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletedEntityEvent";
        this.processEntityDetail(sourceName, entity, "processDeletedEntityEvent");
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletePurgedEntityEvent";
        this.processEntityDetail(sourceName, entity, "processDeletePurgedEntityEvent");
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRestoredEntityEvent";
        this.processEntityDetail(sourceName, entity, "processRestoredEntityEvent");
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processNewRelationshipEvent";
        this.processRelationship(sourceName, relationship, "processNewRelationshipEvent");
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        String methodName = "processUpdatedRelationshipEvent";
        this.processRelationship(sourceName, newRelationship, "processUpdatedRelationshipEvent");
    }

    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processUndoneRelationshipEvent";
        this.processRelationship(sourceName, relationship, "processUndoneRelationshipEvent");
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletedRelationshipEvent";
        this.processRelationship(sourceName, relationship, "processDeletedRelationshipEvent");
    }

    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletePurgedRelationshipEvent";
        this.processRelationship(sourceName, relationship, "processDeletePurgedRelationshipEvent");
    }

    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRestoredRelationshipEvent";
        this.processRelationship(sourceName, relationship, "processRestoredRelationshipEvent");
    }

    public void processInstanceBatchEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, InstanceGraph instances) {
        String methodName = "processInstanceBatchEvent";
        if (instances != null) {
            List relationships;
            List entities = instances.getEntities();
            if (entities != null) {
                for (EntityDetail entity : entities) {
                    this.processEntityDetail(sourceName, entity, "processInstanceBatchEvent");
                }
            }
            if ((relationships = instances.getRelationships()) != null) {
                for (Relationship relationship : relationships) {
                    this.processRelationship(sourceName, relationship, "processInstanceBatchEvent");
                }
            }
        }
    }
}

