/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.converters;

import java.util.List;
import org.odpi.openmetadata.accessservices.discoveryengine.converters.DiscoveryEngineOMASConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryServiceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DiscoveryServicePropertiesConverter<B>
extends DiscoveryEngineOMASConverter<B> {
    public DiscoveryServicePropertiesConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof DiscoveryServiceProperties) {
                DiscoveryServiceProperties bean = (DiscoveryServiceProperties)returnBean;
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    bean.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    bean.setDisplayName(this.removeName(instanceProperties));
                    bean.setDescription(this.removeDescription(instanceProperties));
                    bean.setTypeName(primaryEntity.getType().getTypeDefName());
                    bean.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    if (supplementaryEntities != null) {
                        for (EntityDetail entity : supplementaryEntities) {
                            if (entity == null || entity.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, entity.getType().getTypeDefName(), "Connection")) continue;
                            bean.setConnection(super.getEmbeddedConnection(beanClass, entity, supplementaryEntities, relationships, methodName));
                        }
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            } else {
                this.handleUnexpectedBeanClass(beanClass.getName(), DiscoveryServiceProperties.class.getName(), methodName);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

