/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.discoveryengine.converters.ConnectionConverter;
import org.odpi.openmetadata.accessservices.discoveryengine.converters.DiscoveryEnginePropertiesConverter;
import org.odpi.openmetadata.accessservices.discoveryengine.converters.DiscoveryServicePropertiesConverter;
import org.odpi.openmetadata.accessservices.discoveryengine.converters.RegisteredDiscoveryServiceConverter;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBeanConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareServerCapabilityBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryConfigurationServer;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryEngineProperties;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryServiceProperties;
import org.odpi.openmetadata.frameworks.discovery.properties.RegisteredDiscoveryService;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DiscoveryConfigurationHandler
extends DiscoveryConfigurationServer {
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private SoftwareServerCapabilityHandler<DiscoveryEngineProperties> discoveryEngineHandler;
    private AssetHandler<DiscoveryServiceProperties> discoveryServiceHandler;
    private ConnectionHandler<Connection> connectionHandler;
    private ConnectorTypeHandler<ConnectorType> connectorTypeHandler;
    private InvalidParameterHandler invalidParameterHandler;

    public DiscoveryConfigurationHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.discoveryEngineHandler = new SoftwareServerCapabilityHandler(new DiscoveryEnginePropertiesConverter(repositoryHelper, serviceName, serverName), DiscoveryEngineProperties.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.discoveryServiceHandler = new AssetHandler(new DiscoveryServicePropertiesConverter(repositoryHelper, serviceName, serverName), DiscoveryServiceProperties.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.connectionHandler = new ConnectionHandler(new ConnectionConverter(repositoryHelper, serviceName, serverName), Connection.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.connectorTypeHandler = new ConnectorTypeHandler((OpenMetadataAPIGenericConverter)new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName), ConnectorType.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createDiscoveryEngine(String userId, String qualifiedName, String displayName, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDiscoveryEngine";
        return this.discoveryEngineHandler.createSoftwareServerCapability(userId, null, null, "be650674-790b-487a-a619-0a9002488055", "OpenDiscoveryEngine", null, qualifiedName, displayName, description, null, null, null, null, null, null, "createDiscoveryEngine");
    }

    public DiscoveryEngineProperties getDiscoveryEngineByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryEngineByGUID";
        String guidParameter = "guid";
        return (DiscoveryEngineProperties)this.discoveryEngineHandler.getBeanFromRepository(userId, guid, "guid", "OpenDiscoveryEngine", "getDiscoveryEngineByGUID");
    }

    public DiscoveryEngineProperties getDiscoveryEngineByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryEngineByName";
        String nameParameter = "name";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        return (DiscoveryEngineProperties)this.discoveryEngineHandler.getBeanByValue(userId, name, "name", "be650674-790b-487a-a619-0a9002488055", "OpenDiscoveryEngine", specificMatchPropertyNames, "getDiscoveryEngineByName");
    }

    public List<DiscoveryEngineProperties> getAllDiscoveryEngines(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllDiscoveryEngines";
        return this.discoveryEngineHandler.getBeansByType(userId, "be650674-790b-487a-a619-0a9002488055", "OpenDiscoveryEngine", "qualifiedName", startingFrom, maximumResults, "getAllDiscoveryEngines");
    }

    public void updateDiscoveryEngine(String userId, String guid, String qualifiedName, String displayName, String description, String typeDescription, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDiscoveryEngine";
        String guidParameter = "guid";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateDiscoveryEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateDiscoveryEngine");
        SoftwareServerCapabilityBuilder builder = new SoftwareServerCapabilityBuilder(qualifiedName, displayName, description, typeDescription, version, patchLevel, source, additionalProperties, "be650674-790b-487a-a619-0a9002488055", "OpenDiscoveryEngine", extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getInstanceProperties("updateDiscoveryEngine");
        this.discoveryEngineHandler.updateBeanInRepository(userId, null, null, guid, "guid", "be650674-790b-487a-a619-0a9002488055", "OpenDiscoveryEngine", properties, false, "updateDiscoveryEngine");
    }

    public void deleteDiscoveryEngine(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteDiscoveryEngine";
        String guidParameter = "discoveryEngineGUID";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "deleteDiscoveryEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteDiscoveryEngine");
        this.discoveryEngineHandler.deleteBeanInRepository(userId, null, null, guid, "discoveryEngineGUID", "be650674-790b-487a-a619-0a9002488055", "OpenDiscoveryEngine", "qualifiedName", qualifiedName, "deleteDiscoveryEngine");
    }

    public String createDiscoveryService(String userId, String qualifiedName, String displayName, String description, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ConnectorType connectorType;
        String connectorTypeGUID;
        String methodName = "createDiscoveryService";
        String connectionParameterName = "createDiscoveryService";
        String assetGUIDParameterName = "assetGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID ";
        this.invalidParameterHandler.validateConnection(connection, "createDiscoveryService", "createDiscoveryService");
        String assetGUID = this.discoveryServiceHandler.createAssetInRepository(userId, null, null, qualifiedName, displayName, description, null, null, 0, null, null, null, null, "2f278dfc-4640-4714-b34b-303e84e4fc40", "OpenDiscoveryService", null, "createDiscoveryService");
        if (assetGUID != null && (connectorTypeGUID = this.connectorTypeHandler.getConnectorTypeForConnection(userId, null, null, assetGUID, (connectorType = connection.getConnectorType()).getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getConnectorProviderClassName(), connectorType.getRecognizedAdditionalProperties(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getAdditionalProperties(), "createDiscoveryService")) != null) {
            if (connection instanceof VirtualConnection) {
                String connectionGUIDParameterName = "connection.getGUID";
                String connectionGUID = this.connectionHandler.createVirtualConnection(userId, null, null, assetGUID, "assetGUID", connection.getAssetSummary(), connection.getQualifiedName(), connection.getDisplayName(), connection.getDescription(), connection.getAdditionalProperties(), connection.getSecuredProperties(), connection.getConfigurationProperties(), connection.getUserId(), connection.getClearPassword(), connection.getEncryptedPassword(), connectorTypeGUID, "connectorTypeGUID", "createDiscoveryService");
                List embeddedConnections = ((VirtualConnection)connection).getEmbeddedConnections();
                if (embeddedConnections != null) {
                    for (EmbeddedConnection embeddedConnection : embeddedConnections) {
                        if (embeddedConnection == null) continue;
                        String embeddedConnectionGUID = this.connectionHandler.saveConnection(userId, null, null, assetGUID, null, "assetGUID", "OpenDiscoveryService", embeddedConnection.getEmbeddedConnection(), null, "createDiscoveryService");
                        this.connectionHandler.addEmbeddedConnection(userId, null, null, connectionGUID, "connection.getGUID", embeddedConnection.getPosition(), embeddedConnection.getDisplayName(), embeddedConnection.getArguments(), embeddedConnectionGUID, "embeddedConnectionGUID ", "createDiscoveryService");
                    }
                }
            } else {
                this.connectionHandler.createConnection(userId, null, null, assetGUID, "assetGUID", connection.getAssetSummary(), connection.getQualifiedName(), connection.getDisplayName(), connection.getDescription(), connection.getAdditionalProperties(), connection.getSecuredProperties(), connection.getConfigurationProperties(), connection.getUserId(), connection.getClearPassword(), connection.getEncryptedPassword(), connectorTypeGUID, "connectorTypeGUID", null, null, "createDiscoveryService");
            }
        }
        return assetGUID;
    }

    public DiscoveryServiceProperties getDiscoveryServiceByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryServiceByGUID";
        String guidParameter = "guid";
        return (DiscoveryServiceProperties)this.discoveryServiceHandler.getAssetWithConnection(userId, guid, "guid", "OpenDiscoveryService", "getDiscoveryServiceByGUID");
    }

    public DiscoveryServiceProperties getDiscoveryServiceByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryServiceByName";
        String nameParameter = "name";
        return (DiscoveryServiceProperties)this.discoveryServiceHandler.getAssetByNameWithConnection(userId, name, "name", "2f278dfc-4640-4714-b34b-303e84e4fc40", "OpenDiscoveryService", "getDiscoveryServiceByName");
    }

    public List<DiscoveryServiceProperties> getAllDiscoveryServices(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllDiscoveryServices";
        return this.discoveryServiceHandler.getAllAssetsWithConnection(userId, "2f278dfc-4640-4714-b34b-303e84e4fc40", "OpenDiscoveryService", startingFrom, maximumResults, "getAllDiscoveryServices");
    }

    public List<String> getDiscoveryServiceRegistrations(String userId, String discoveryServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllDiscoveryServices";
        String guidParameter = "discoveryServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAllDiscoveryServices");
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", "getAllDiscoveryServices");
        this.connectionHandler.getBeanFromRepository(userId, discoveryServiceGUID, "discoveryServiceGUID", "OpenDiscoveryService", "getAllDiscoveryServices");
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, discoveryServiceGUID, "OpenDiscoveryService", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "getAllDiscoveryServices");
        ArrayList<String> results = new ArrayList<String>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || relationship.getGUID() == null) continue;
                results.add(relationship.getGUID());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public void updateDiscoveryService(String userId, String guid, String qualifiedName, String displayName, String description, Connection connection, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDiscoveryService";
        String guidParameter = "guid";
        this.discoveryServiceHandler.updateAssetWithConnection(userId, null, null, guid, "guid", qualifiedName, displayName, description, additionalProperties, "2f278dfc-4640-4714-b34b-303e84e4fc40", "OpenDiscoveryService", extendedProperties, null, connection, "updateDiscoveryService");
    }

    public void deleteDiscoveryService(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteDiscoveryService";
        String qualifiedNameParameter = "qualifiedName";
        String guidParameter = "discoveryServiceGUID";
        this.connectionHandler.deleteBeanInRepository(userId, null, null, guid, "discoveryServiceGUID", "2f278dfc-4640-4714-b34b-303e84e4fc40", "OpenDiscoveryService", "qualifiedName", qualifiedName, "deleteDiscoveryService");
    }

    public void registerDiscoveryServiceWithEngine(String userId, String discoveryEngineGUID, String discoveryServiceGUID, String discoveryRequestType, Map<String, String> defaultAnalysisParameters) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerDiscoveryServiceWithEngine";
        String discoveryEngineGUIDParameter = "discoveryEngineGUID";
        String discoveryServiceGUIDParameter = "discoveryServiceGUID";
        String discoveryRequestTypeParameter = "discoveryRequestType";
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", "registerDiscoveryServiceWithEngine");
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", "registerDiscoveryServiceWithEngine");
        this.invalidParameterHandler.validateName(discoveryRequestType, "discoveryRequestType", "registerDiscoveryServiceWithEngine");
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, discoveryEngineGUID, "OpenDiscoveryEngine", "2726df0e-4f3a-44e1-8433-4ca5301457fd", "SupportedGovernanceService", 0, this.invalidParameterHandler.getMaxPagingSize(), "registerDiscoveryServiceWithEngine");
        while (iterator.moreToReceive()) {
            String existingRequestType;
            Relationship supportedDiscoveryService = iterator.getNext();
            if (supportedDiscoveryService == null || !discoveryRequestType.equals(existingRequestType = this.repositoryHelper.getStringProperty(this.serviceName, "requestType", supportedDiscoveryService.getProperties(), "registerDiscoveryServiceWithEngine"))) continue;
            EntityProxy existingDiscoveryServiceProxy = supportedDiscoveryService.getEntityTwoProxy();
            if (existingDiscoveryServiceProxy != null && discoveryServiceGUID.equals(existingDiscoveryServiceProxy.getGUID())) {
                InstanceProperties properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, supportedDiscoveryService.getProperties(), "requestParameters", defaultAnalysisParameters, "registerDiscoveryServiceWithEngine");
                this.repositoryHandler.updateRelationshipProperties(userId, null, null, supportedDiscoveryService, properties, "registerDiscoveryServiceWithEngine");
                return;
            }
            this.repositoryHandler.removeRelationship(userId, null, null, supportedDiscoveryService, "registerDiscoveryServiceWithEngine");
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, "requestType", discoveryRequestType, "registerDiscoveryServiceWithEngine");
        this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, instanceProperties, "requestParameters", defaultAnalysisParameters, "registerDiscoveryServiceWithEngine");
        this.discoveryEngineHandler.linkElementToElement(userId, null, null, discoveryEngineGUID, "discoveryEngineGUID", "OpenDiscoveryEngine", discoveryServiceGUID, "discoveryServiceGUID", "OpenDiscoveryService", "2726df0e-4f3a-44e1-8433-4ca5301457fd", "SupportedGovernanceService", instanceProperties, "registerDiscoveryServiceWithEngine");
    }

    public RegisteredDiscoveryService getRegisteredDiscoveryService(String userId, String discoveryEngineGUID, String discoveryServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredGovernanceService";
        String discoveryEngineGUIDParameter = "discoveryEngineGUID";
        String discoveryServiceGUIDParameter = "discoveryServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredGovernanceService");
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", "getRegisteredGovernanceService");
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", "getRegisteredGovernanceService");
        List relationships = this.repositoryHandler.getRelationshipsBetweenEntities(userId, discoveryServiceGUID, "OpenDiscoveryService", discoveryEngineGUID, "2726df0e-4f3a-44e1-8433-4ca5301457fd", "SupportedGovernanceService", "getRegisteredGovernanceService");
        if (relationships != null) {
            RegisteredDiscoveryServiceConverter converter = new RegisteredDiscoveryServiceConverter(this.repositoryHelper, this.serviceName);
            return converter.getBean(this.getDiscoveryServiceByGUID(userId, discoveryServiceGUID), relationships);
        }
        return null;
    }

    public List<String> getRegisteredDiscoveryServices(String userId, String discoveryEngineGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredDiscoveryServices";
        String discoveryEngineGUIDParameter = "discoveryEngineGUID";
        return this.discoveryEngineHandler.getAttachedElementGUIDs(userId, discoveryEngineGUID, "discoveryEngineGUID", "OpenDiscoveryEngine", "2726df0e-4f3a-44e1-8433-4ca5301457fd", "SupportedGovernanceService", "OpenDiscoveryService", startingFrom, maximumResults, "getRegisteredDiscoveryServices");
    }

    public void unregisterDiscoveryServiceFromEngine(String userId, String discoveryEngineGUID, String discoveryServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterDiscoveryServiceFromEngine";
        String discoveryEngineGUIDParameter = "discoveryEngineGUID";
        String discoveryServiceGUIDParameter = "discoveryServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "unregisterDiscoveryServiceFromEngine");
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", "unregisterDiscoveryServiceFromEngine");
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", "unregisterDiscoveryServiceFromEngine");
        this.discoveryEngineHandler.unlinkElementFromElement(userId, false, null, null, discoveryEngineGUID, "discoveryEngineGUID", "OpenDiscoveryEngine", discoveryServiceGUID, "discoveryServiceGUID", "2f278dfc-4640-4714-b34b-303e84e4fc40", "OpenDiscoveryService", "2726df0e-4f3a-44e1-8433-4ca5301457fd", "SupportedGovernanceService", "unregisterDiscoveryServiceFromEngine");
    }
}

