/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.server;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.discoveryengine.handlers.DiscoveryConfigurationHandler;
import org.odpi.openmetadata.accessservices.discoveryengine.server.DiscoveryEngineServiceInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DeleteRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryEngineListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryEnginePropertiesResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryServiceListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryServicePropertiesResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryServiceRegistrationRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.NewDiscoveryEngineRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.NewDiscoveryServiceRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.RegisteredDiscoveryServiceResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.UpdateDiscoveryEngineRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.UpdateDiscoveryServiceRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.slf4j.LoggerFactory;

public class DiscoveryConfigurationServices {
    private static DiscoveryEngineServiceInstanceHandler instanceHandler = new DiscoveryEngineServiceInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DiscoveryConfigurationServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public ConnectionResponse getOutTopicConnection(String serverName, String userId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDiscoveryEngine(String serverName, String userId, NewDiscoveryEngineRequestBody requestBody) {
        String methodName = "createDiscoveryEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDiscoveryEngine");
        String qualifiedName = null;
        String displayName = null;
        String description = null;
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        if (requestBody != null) {
            qualifiedName = requestBody.getQualifiedName();
            displayName = requestBody.getDisplayName();
            description = requestBody.getDescription();
        }
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "createDiscoveryEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDiscoveryEngine");
            response.setGUID(handler.createDiscoveryEngine(userId, qualifiedName, displayName, description));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDiscoveryEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DiscoveryEnginePropertiesResponse getDiscoveryEngineByGUID(String serverName, String userId, String guid) {
        String methodName = "getDiscoveryEngineByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryEngineByGUID");
        DiscoveryEnginePropertiesResponse response = new DiscoveryEnginePropertiesResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getDiscoveryEngineByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryEngineByGUID");
            response.setDiscoveryEngineProperties(handler.getDiscoveryEngineByGUID(userId, guid));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDiscoveryEngineByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DiscoveryEnginePropertiesResponse getDiscoveryEngineByName(String serverName, String userId, String name) {
        String methodName = "getDiscoveryEngineByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryEngineByName");
        DiscoveryEnginePropertiesResponse response = new DiscoveryEnginePropertiesResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getDiscoveryEngineByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryEngineByName");
            response.setDiscoveryEngineProperties(handler.getDiscoveryEngineByName(userId, name));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDiscoveryEngineByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DiscoveryEngineListResponse getAllDiscoveryEngines(String serverName, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllDiscoveryEngines";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllDiscoveryEngines");
        DiscoveryEngineListResponse response = new DiscoveryEngineListResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getAllDiscoveryEngines");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllDiscoveryEngines");
            response.setDiscoveryEngines(handler.getAllDiscoveryEngines(userId, startingFrom, maximumResults));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getAllDiscoveryEngines", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDiscoveryEngine(String serverName, String userId, String guid, UpdateDiscoveryEngineRequestBody requestBody) {
        String methodName = "updateDiscoveryEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDiscoveryEngine");
        String qualifiedName = null;
        String displayName = null;
        String description = null;
        String typeDescription = null;
        String version = null;
        String patchLevel = null;
        String source = null;
        Map additionalProperties = null;
        Map extendedProperties = null;
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        if (requestBody != null) {
            qualifiedName = requestBody.getQualifiedName();
            displayName = requestBody.getDisplayName();
            description = requestBody.getDescription();
            typeDescription = requestBody.getTypeDescription();
            version = requestBody.getVersion();
            patchLevel = requestBody.getPatchLevel();
            source = requestBody.getSource();
            additionalProperties = requestBody.getAdditionalProperties();
            extendedProperties = requestBody.getExtendedProperties();
        }
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "updateDiscoveryEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDiscoveryEngine");
            handler.updateDiscoveryEngine(userId, guid, qualifiedName, displayName, description, typeDescription, version, patchLevel, source, additionalProperties, extendedProperties);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updateDiscoveryEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteDiscoveryEngine(String serverName, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteDiscoveryEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteDiscoveryEngine");
        String qualifiedName = null;
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        if (requestBody != null) {
            qualifiedName = requestBody.getQualifiedName();
        }
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "deleteDiscoveryEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteDiscoveryEngine");
            handler.deleteDiscoveryEngine(userId, guid, qualifiedName);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "deleteDiscoveryEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDiscoveryService(String serverName, String userId, NewDiscoveryServiceRequestBody requestBody) {
        String methodName = "createDiscoveryService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDiscoveryService");
        String qualifiedName = null;
        String displayName = null;
        String description = null;
        Connection connection = null;
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        if (requestBody != null) {
            qualifiedName = requestBody.getQualifiedName();
            displayName = requestBody.getDisplayName();
            description = requestBody.getDescription();
            connection = requestBody.getConnection();
        }
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "createDiscoveryService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDiscoveryService");
            response.setGUID(handler.createDiscoveryService(userId, qualifiedName, displayName, description, connection));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDiscoveryService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DiscoveryServicePropertiesResponse getDiscoveryServiceByGUID(String serverName, String userId, String guid) {
        String methodName = "getDiscoveryServiceByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryServiceByGUID");
        DiscoveryServicePropertiesResponse response = new DiscoveryServicePropertiesResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getDiscoveryServiceByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryServiceByGUID");
            response.setDiscoveryServiceProperties(handler.getDiscoveryServiceByGUID(userId, guid));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDiscoveryServiceByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DiscoveryServicePropertiesResponse getDiscoveryServiceByName(String serverName, String userId, String name) {
        String methodName = "getDiscoveryServiceByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryServiceByName");
        DiscoveryServicePropertiesResponse response = new DiscoveryServicePropertiesResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getDiscoveryServiceByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryServiceByName");
            response.setDiscoveryServiceProperties(handler.getDiscoveryServiceByName(userId, name));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDiscoveryServiceByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DiscoveryServiceListResponse getAllDiscoveryServices(String serverName, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllDiscoveryServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllDiscoveryServices");
        DiscoveryServiceListResponse response = new DiscoveryServiceListResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getAllDiscoveryServices");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllDiscoveryServices");
            response.setDiscoveryServices(handler.getAllDiscoveryServices(userId, startingFrom, maximumResults));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getAllDiscoveryServices", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getDiscoveryServiceRegistrations(String serverName, String userId, String discoveryServiceGUID) {
        String methodName = "getDiscoveryServiceRegistrations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryServiceRegistrations");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getDiscoveryServiceRegistrations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryServiceRegistrations");
            response.setGUIDs(handler.getDiscoveryServiceRegistrations(userId, discoveryServiceGUID));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getDiscoveryServiceRegistrations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDiscoveryService(String serverName, String userId, String guid, UpdateDiscoveryServiceRequestBody requestBody) {
        String methodName = "updateDiscoveryService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDiscoveryService");
        String qualifiedName = null;
        String displayName = null;
        String shortDescription = null;
        String description = null;
        String owner = null;
        OwnerType ownerType = null;
        List zoneMembership = null;
        Map origin = null;
        String latestChange = null;
        Connection connection = null;
        Map additionalProperties = null;
        Map extendedProperties = null;
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        if (requestBody != null) {
            qualifiedName = requestBody.getQualifiedName();
            displayName = requestBody.getDisplayName();
            shortDescription = requestBody.getShortDescription();
            description = requestBody.getDescription();
            owner = requestBody.getOwner();
            ownerType = requestBody.getOwnerType();
            zoneMembership = requestBody.getZoneMembership();
            origin = requestBody.getOrigin();
            latestChange = requestBody.getLatestChange();
            connection = requestBody.getConnection();
            additionalProperties = requestBody.getAdditionalProperties();
            extendedProperties = requestBody.getExtendedProperties();
        }
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "updateDiscoveryService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDiscoveryService");
            handler.updateDiscoveryService(userId, guid, qualifiedName, displayName, shortDescription, description, owner, ownerType, zoneMembership, origin, latestChange, connection, additionalProperties, extendedProperties);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updateDiscoveryService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteDiscoveryService(String serverName, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteDiscoveryService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteDiscoveryService");
        String qualifiedName = null;
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        if (requestBody != null) {
            qualifiedName = requestBody.getQualifiedName();
        }
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "deleteDiscoveryService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteDiscoveryService");
            handler.deleteDiscoveryService(userId, guid, qualifiedName);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "deleteDiscoveryService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse registerDiscoveryServiceWithEngine(String serverName, String userId, String discoveryEngineGUID, DiscoveryServiceRegistrationRequestBody requestBody) {
        String methodName = "registerDiscoveryServiceWithEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "registerDiscoveryServiceWithEngine");
        String discoveryServiceGUID = null;
        List discoveryRequestType = null;
        Map defaultAnalysisParameters = null;
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        if (requestBody != null) {
            discoveryServiceGUID = requestBody.getDiscoveryServiceGUID();
            discoveryRequestType = requestBody.getDiscoveryRequestTypes();
            defaultAnalysisParameters = requestBody.getDefaultAnalysisParameters();
        }
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "registerDiscoveryServiceWithEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "registerDiscoveryServiceWithEngine");
            handler.registerDiscoveryServiceWithEngine(userId, discoveryEngineGUID, discoveryServiceGUID, discoveryRequestType, defaultAnalysisParameters);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "registerDiscoveryServiceWithEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredDiscoveryServiceResponse getRegisteredDiscoveryService(String serverName, String userId, String discoveryEngineGUID, String discoveryServiceGUID) {
        String methodName = "getRegisteredDiscoveryService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredDiscoveryService");
        RegisteredDiscoveryServiceResponse response = new RegisteredDiscoveryServiceResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getRegisteredDiscoveryService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredDiscoveryService");
            response.setRegisteredDiscoveryService(handler.getRegisteredDiscoveryService(userId, discoveryEngineGUID, discoveryServiceGUID));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getRegisteredDiscoveryService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getRegisteredDiscoveryServices(String serverName, String userId, String discoveryEngineGUID, int startingFrom, int maximumResults) {
        String methodName = "getRegisteredDiscoveryServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredDiscoveryServices");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getRegisteredDiscoveryServices");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredDiscoveryServices");
            response.setGUIDs(handler.getRegisteredDiscoveryServices(userId, discoveryEngineGUID, startingFrom, maximumResults));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getRegisteredDiscoveryServices", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unregisterDiscoveryServiceFromEngine(String serverName, String userId, String discoveryEngineGUID, String discoveryServiceGUID, NullRequestBody requestBody) {
        String methodName = "unregisterDiscoveryServiceFromEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unregisterDiscoveryServiceFromEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "unregisterDiscoveryServiceFromEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unregisterDiscoveryServiceFromEngine");
            handler.unregisterDiscoveryServiceFromEngine(userId, discoveryEngineGUID, discoveryServiceGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "unregisterDiscoveryServiceFromEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

