/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.discoveryengine.connectors.outtopic.DiscoveryEngineOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.discoveryengine.connectors.outtopic.DiscoveryEngineOutTopicServerProvider;
import org.odpi.openmetadata.accessservices.discoveryengine.ffdc.DiscoveryEngineAuditCode;
import org.odpi.openmetadata.accessservices.discoveryengine.ffdc.DiscoveryEngineErrorCode;
import org.odpi.openmetadata.accessservices.discoveryengine.outtopic.DiscoveryEngineOMRSTopicListener;
import org.odpi.openmetadata.accessservices.discoveryengine.outtopic.DiscoveryEnginePublisher;
import org.odpi.openmetadata.accessservices.discoveryengine.server.DiscoveryEngineServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DiscoveryEngineAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog = null;
    private DiscoveryEngineServicesInstance instance = null;
    private String serverName = null;
    private DiscoveryEnginePublisher eventPublisher = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", DiscoveryEngineAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            List supportedZones = super.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List defaultZones = super.extractDefaultZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List publishZones = super.extractPublishZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new DiscoveryEngineServicesInstance(repositoryConnector, supportedZones, defaultZones, publishZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize(), accessServiceConfig.getAccessServiceOutTopic());
            this.serverName = this.instance.getServerName();
            Connection outTopicEventBusConnection = accessServiceConfig.getAccessServiceOutTopic();
            if (outTopicEventBusConnection != null) {
                Endpoint endpoint = outTopicEventBusConnection.getEndpoint();
                AuditLog outTopicAuditLog = auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OMAS_OUT_TOPIC);
                Connection serverSideOutTopicConnection = this.getOutTopicConnection(accessServiceConfig.getAccessServiceOutTopic(), AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceFullName(), DiscoveryEngineOutTopicServerProvider.class.getName(), auditLog);
                DiscoveryEngineOutTopicServerConnector outTopicServerConnector = (DiscoveryEngineOutTopicServerConnector)super.getTopicConnector(serverSideOutTopicConnection, DiscoveryEngineOutTopicServerConnector.class, outTopicAuditLog, AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceFullName(), "initialize");
                this.eventPublisher = new DiscoveryEnginePublisher(outTopicServerConnector, endpoint.getAddress(), outTopicAuditLog);
                this.registerWithEnterpriseTopic(AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceFullName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)new DiscoveryEngineOMRSTopicListener(AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceFullName(), this.eventPublisher, repositoryConnector.getRepositoryHelper(), outTopicAuditLog), auditLog);
            }
            auditLog.logMessage("initialize", DiscoveryEngineAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}));
        }
        catch (OMAGConfigurationErrorException error) {
            auditLog.logException("initialize", DiscoveryEngineAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
            throw error;
        }
        catch (Throwable error) {
            auditLog.logException("initialize", DiscoveryEngineAuditCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage()}), error);
            throw new OMAGConfigurationErrorException(DiscoveryEngineErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceFullName(), this.serverName, error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "initialize", error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.disconnect();
        }
        this.auditLog.logMessage("shutdown", DiscoveryEngineAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

