/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.outtopic;

import org.odpi.openmetadata.accessservices.discoveryengine.connectors.outtopic.DiscoveryEngineOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.discoveryengine.events.DiscoveryEngineConfigurationEvent;
import org.odpi.openmetadata.accessservices.discoveryengine.events.DiscoveryEngineEvent;
import org.odpi.openmetadata.accessservices.discoveryengine.events.DiscoveryEngineEventType;
import org.odpi.openmetadata.accessservices.discoveryengine.events.DiscoveryServiceConfigurationEvent;
import org.odpi.openmetadata.accessservices.discoveryengine.ffdc.DiscoveryEngineAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;

public class DiscoveryEnginePublisher {
    private DiscoveryEngineOutTopicServerConnector outTopicServerConnector;
    private AuditLog outTopicAuditLog;
    private String outTopicName;
    private final String actionDescription = "Out topic configuration refresh event publishing";

    public DiscoveryEnginePublisher(DiscoveryEngineOutTopicServerConnector outTopicServerConnector, String outTopicName, AuditLog outTopicAuditLog) {
        this.outTopicServerConnector = outTopicServerConnector;
        this.outTopicAuditLog = outTopicAuditLog;
        this.outTopicName = outTopicName;
        if (outTopicAuditLog != null) {
            outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", DiscoveryEngineAuditCode.SERVICE_PUBLISHING.getMessageDefinition(new String[]{outTopicName}));
        }
    }

    void publishRefreshDiscoveryEngineEvent(String discoveryEngineGUID, String discoveryEngineName) {
        String methodName = "publishRefreshDiscoveryEngineEvent";
        if (this.outTopicServerConnector != null) {
            try {
                DiscoveryEngineConfigurationEvent newEvent = new DiscoveryEngineConfigurationEvent();
                newEvent.setEventType(DiscoveryEngineEventType.REFRESH_DISCOVERY_ENGINE_EVENT);
                newEvent.setDiscoveryEngineGUID(discoveryEngineGUID);
                newEvent.setDiscoveryEngineName(discoveryEngineName);
                this.outTopicServerConnector.sendEvent((DiscoveryEngineEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", DiscoveryEngineAuditCode.REFRESH_DISCOVERY_ENGINE.getMessageDefinition(new String[]{discoveryEngineName, discoveryEngineGUID}));
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(discoveryEngineGUID, discoveryEngineName, error, "publishRefreshDiscoveryEngineEvent");
            }
        }
    }

    void publishRefreshDiscoveryServiceEvent(String discoveryEngineGUID, String discoveryEngineName, String registeredDiscoveryServiceGUID, String discoveryRequestType) {
        String methodName = "publishRefreshDiscoveryServiceEvent";
        if (this.outTopicServerConnector != null) {
            try {
                DiscoveryServiceConfigurationEvent newEvent = new DiscoveryServiceConfigurationEvent();
                newEvent.setEventType(DiscoveryEngineEventType.REFRESH_DISCOVERY_SERVICE_EVENT);
                newEvent.setDiscoveryEngineGUID(discoveryEngineGUID);
                newEvent.setDiscoveryEngineName(discoveryEngineName);
                newEvent.setRegisteredDiscoveryServiceGUID(registeredDiscoveryServiceGUID);
                newEvent.setDiscoveryRequestType(discoveryRequestType);
                this.outTopicServerConnector.sendEvent((DiscoveryEngineEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", DiscoveryEngineAuditCode.REFRESH_DISCOVERY_SERVICE.getMessageDefinition(new String[]{discoveryEngineName, discoveryEngineGUID, discoveryRequestType, registeredDiscoveryServiceGUID}));
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(discoveryEngineGUID, discoveryEngineName, error, "publishRefreshDiscoveryServiceEvent");
            }
        }
    }

    private void logUnexpectedPublishingException(String discoveryEngineGUID, String discoveryEngineName, Throwable error, String methodName) {
        if (this.outTopicAuditLog != null) {
            this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", DiscoveryEngineAuditCode.OUT_TOPIC_FAILURE.getMessageDefinition(new String[]{this.outTopicName, error.getClass().getName(), error.getMessage()}), error);
        }
    }

    public void disconnect() {
        block3: {
            try {
                this.outTopicServerConnector.disconnect();
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", DiscoveryEngineAuditCode.PUBLISHING_SHUTDOWN.getMessageDefinition(new String[]{this.outTopicName}));
                }
            }
            catch (Throwable error) {
                if (this.outTopicAuditLog == null) break block3;
                this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", DiscoveryEngineAuditCode.PUBLISHING_SHUTDOWN_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), this.outTopicName, error.getMessage()}), error);
            }
        }
    }
}

