/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.server;

import org.odpi.openmetadata.accessservices.discoveryengine.ffdc.DiscoveryEngineAuditCode;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.AnnotationListResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.AnnotationResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.DataFieldListResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.DataFieldResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.DiscoveryAnalysisReportRequestBody;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.DiscoveryAnalysisReportResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.StatusRequestBody;
import org.odpi.openmetadata.accessservices.discoveryengine.server.DiscoveryEngineServiceInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AnnotationHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.DataFieldHandler;
import org.odpi.openmetadata.commonservices.generichandlers.DiscoveryAnalysisReportHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBean;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DataField;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;
import org.slf4j.LoggerFactory;

public class DiscoveryEngineRESTServices {
    private static DiscoveryEngineServiceInstanceHandler instanceHandler = new DiscoveryEngineServiceInstanceHandler();
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DiscoveryEngineRESTServices.class), instanceHandler.getServiceName());

    public GUIDListResponse getAssets(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssets");
        AuditLog auditLog = null;
        GUIDListResponse response = new GUIDListResponse();
        try {
            AssetHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssets");
            response.setGUIDs(handler.getBeanGUIDsByType(userId, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", startFrom, pageSize, "getAssets"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByQualifiedName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getAssetsByQualifiedName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByQualifiedName");
        AuditLog auditLog = null;
        GUIDListResponse response = new GUIDListResponse();
        try {
            AssetHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByQualifiedName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByQualifiedName");
            response.setGUIDs(handler.getBeanGUIDsByQualifiedName(userId, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", name, "name", startFrom, pageSize, "getAssetsByQualifiedName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getAssetsByQualifiedName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getAssetsByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getAssetsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetsByName");
        AuditLog auditLog = null;
        GUIDListResponse response = new GUIDListResponse();
        try {
            AssetHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetsByName");
            response.setGUIDs(handler.getAssetGUIDsByName(userId, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", name, "name", startFrom, pageSize, "getAssetsByName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getAssetsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse findAssets(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findAssets";
        String searchStringParameterName = "findAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAssets");
        AuditLog auditLog = null;
        GUIDListResponse response = new GUIDListResponse();
        try {
            AssetHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getAssetHandler(userId, serverName, "findAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssets");
            response.setGUIDs(handler.findBeanGUIDs(userId, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", searchString, "findAssets", startFrom, pageSize, "findAssets"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse findAssetsByEndpoint(String serverName, String userId, String networkAddress, int startFrom, int pageSize) {
        String methodName = "findAssetsByEndpoint";
        String networkAddressParameterName = "networkAddress";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findAssetsByEndpoint");
        AuditLog auditLog = null;
        GUIDListResponse response = new GUIDListResponse();
        try {
            AssetHandler<OpenMetadataAPIDummyBean> handler = instanceHandler.getAssetHandler(userId, serverName, "findAssetsByEndpoint");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findAssetsByEndpoint");
            response.setGUIDs(handler.getAssetGUIDsByEndpoint(userId, networkAddress, "networkAddress", startFrom, pageSize, "findAssetsByEndpoint"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findAssetsByEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse logAssetAuditMessage(String serverName, String userId, String assetGUID, String discoveryService, String message) {
        String methodName = "logAssetAuditMessage";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "logAssetAuditMessage");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "logAssetAuditMessage");
            auditLog.logMessage("logAssetAuditMessage", DiscoveryEngineAuditCode.ASSET_AUDIT_LOG.getMessageDefinition(new String[]{assetGUID, discoveryService, message}));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "logAssetAuditMessage", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDiscoveryAnalysisReport(String serverName, String userId, String assetGUID, DiscoveryAnalysisReportRequestBody requestBody) {
        String methodName = "createDiscoveryAnalysisReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDiscoveryAnalysisReport");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDiscoveryAnalysisReport", serverName);
            } else {
                DiscoveryAnalysisReportHandler<DiscoveryAnalysisReport> handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "createDiscoveryAnalysisReport");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createDiscoveryAnalysisReport");
                int discoveryRequestStatus = DiscoveryRequestStatus.UNKNOWN_STATUS.getOpenTypeOrdinal();
                if (requestBody.getDiscoveryRequestStatus() != null) {
                    discoveryRequestStatus = requestBody.getDiscoveryRequestStatus().getOpenTypeOrdinal();
                }
                response.setGUID(handler.createDiscoveryAnalysisReport(userId, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getCreationDate(), requestBody.getAnalysisParameters(), discoveryRequestStatus, assetGUID, requestBody.getDiscoveryEngineGUID(), requestBody.getDiscoveryServiceGUID(), requestBody.getAdditionalProperties(), "createDiscoveryAnalysisReport"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createDiscoveryAnalysisReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDiscoveryAnalysisReport(String serverName, String userId, String discoveryReportGUID, DiscoveryAnalysisReport requestBody) {
        String methodName = "updateDiscoveryAnalysisReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDiscoveryAnalysisReport");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDiscoveryAnalysisReport", serverName);
            } else {
                DiscoveryAnalysisReportHandler<DiscoveryAnalysisReport> handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "updateDiscoveryAnalysisReport");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDiscoveryAnalysisReport");
                int discoveryRequestStatus = DiscoveryRequestStatus.UNKNOWN_STATUS.getOpenTypeOrdinal();
                if (requestBody.getDiscoveryRequestStatus() != null) {
                    discoveryRequestStatus = requestBody.getDiscoveryRequestStatus().getOpenTypeOrdinal();
                }
                handler.updateDiscoveryAnalysisReport(userId, discoveryReportGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getCreationDate(), requestBody.getAnalysisParameters(), discoveryRequestStatus, requestBody.getAdditionalProperties(), "updateDiscoveryAnalysisReport");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateDiscoveryAnalysisReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DiscoveryAnalysisReportResponse getDiscoveryAnalysisReport(String serverName, String userId, String discoveryReportGUID) {
        String methodName = "getDiscoveryAnalysisReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryAnalysisReport");
        AuditLog auditLog = null;
        DiscoveryAnalysisReportResponse response = new DiscoveryAnalysisReportResponse();
        try {
            DiscoveryAnalysisReportHandler<DiscoveryAnalysisReport> handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "getDiscoveryAnalysisReport");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryAnalysisReport");
            response.setAnalysisReport((DiscoveryAnalysisReport)handler.getDiscoveryAnalysisReport(userId, discoveryReportGUID, "getDiscoveryAnalysisReport"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getDiscoveryAnalysisReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NameListResponse getTypesOfAnnotation(String serverName, String userId) {
        String methodName = "getTypesOfAnnotation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTypesOfAnnotation");
        NameListResponse response = new NameListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypesOfAnnotation");
            AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "getTypesOfAnnotation");
            response.setNames(handler.getTypesOfAnnotation());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getTypesOfAnnotation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public StringMapResponse getTypesOfAnnotationWithDescriptions(String serverName, String userId) {
        String methodName = "getTypesOfAnnotationWithDescriptions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTypesOfAnnotationWithDescriptions");
        StringMapResponse response = new StringMapResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypesOfAnnotationWithDescriptions");
            AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "getTypesOfAnnotationWithDescriptions");
            response.setStringMap(handler.getTypesOfAnnotationDescriptions());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getTypesOfAnnotationWithDescriptions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationListResponse getAnnotationsForAssetByStatus(String serverName, String userId, String assetGUID, int startingFrom, int maximumResults, StatusRequestBody requestBody) {
        String methodName = "getAnnotationsForAssetByStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAnnotationsForAssetByStatus");
        AuditLog auditLog = null;
        AnnotationListResponse response = new AnnotationListResponse();
        AnnotationStatus status = null;
        if (requestBody != null) {
            status = requestBody.getAnnotationStatus();
        }
        try {
            AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "getAnnotationsForAssetByStatus");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAnnotationsForAssetByStatus");
            if (status == null) {
                response.setAnnotations(handler.getAnnotationsForAsset(userId, assetGUID, startingFrom, maximumResults, "getAnnotationsForAssetByStatus"));
            } else {
                response.setAnnotations(handler.getAnnotationsForAssetByStatus(userId, assetGUID, status.getOpenTypeOrdinal(), startingFrom, maximumResults, "getAnnotationsForAssetByStatus"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getAnnotationsForAssetByStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationListResponse getDiscoveryReportAnnotations(String serverName, String userId, String discoveryReportGUID, int startingFrom, int maximumResults) {
        String methodName = "getDiscoveryReportAnnotations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryReportAnnotations");
        AuditLog auditLog = null;
        AnnotationListResponse response = new AnnotationListResponse();
        try {
            AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "getDiscoveryReportAnnotations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryReportAnnotations");
            response.setAnnotations(handler.getDiscoveryReportAnnotations(userId, discoveryReportGUID, startingFrom, maximumResults, "getDiscoveryReportAnnotations"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getDiscoveryReportAnnotations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationListResponse getExtendedAnnotations(String serverName, String userId, String annotationGUID, int startingFrom, int maximumResults) {
        String methodName = "getExtendedAnnotations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExtendedAnnotations");
        AuditLog auditLog = null;
        AnnotationListResponse response = new AnnotationListResponse();
        try {
            AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "getExtendedAnnotations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExtendedAnnotations");
            response.setAnnotations(handler.getExtendedAnnotations(userId, annotationGUID, startingFrom, maximumResults, "getExtendedAnnotations"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getExtendedAnnotations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationResponse getAnnotation(String serverName, String userId, String annotationGUID) {
        String methodName = "getAnnotation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAnnotation");
        AuditLog auditLog = null;
        AnnotationResponse response = new AnnotationResponse();
        try {
            AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "getAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAnnotation");
            response.setAnnotation((Annotation)handler.getAnnotation(userId, annotationGUID, "getAnnotation"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getAnnotation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addAnnotationToDiscoveryReport(String serverName, String userId, String discoveryReportGUID, Annotation requestBody) {
        String methodName = "addAnnotationToDiscoveryReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAnnotationToDiscoveryReport");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "addAnnotationToDiscoveryReport", serverName);
            }
            AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "addAnnotationToDiscoveryReport");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addAnnotationToDiscoveryReport");
            response.setGUID(handler.addAnnotationToDiscoveryReport(userId, discoveryReportGUID, requestBody, "addAnnotationToDiscoveryReport"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addAnnotationToDiscoveryReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addAnnotationToAnnotation(String serverName, String userId, String parentAnnotationGUID, Annotation requestBody) {
        String methodName = "addAnnotationToAnnotation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAnnotationToAnnotation");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "addAnnotationToAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addAnnotationToAnnotation");
            response.setGUID(handler.addAnnotationToAnnotation(userId, parentAnnotationGUID, requestBody, "addAnnotationToAnnotation"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addAnnotationToAnnotation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateAnnotation(String serverName, String userId, String annotationGUID, Annotation requestBody) {
        String methodName = "updateAnnotation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateAnnotation");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "updateAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAnnotation");
            handler.updateAnnotation(userId, annotationGUID, requestBody, "updateAnnotation");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateAnnotation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteAnnotation(String serverName, String userId, String annotationGUID, NullRequestBody requestBody) {
        String methodName = "deleteAnnotation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteAnnotation");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "deleteAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteAnnotation");
            handler.deleteAnnotation(userId, annotationGUID, "deleteAnnotation");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "deleteAnnotation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFieldListResponse getPreviousDataFieldsForAsset(String serverName, String userId, String discoveryReportGUID, int startingFrom, int maximumResults) {
        String methodName = "getPreviousDataFieldsForAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPreviousDataFieldsForAsset");
        AuditLog auditLog = null;
        DataFieldListResponse response = new DataFieldListResponse();
        try {
            DataFieldHandler<DataField> handler = instanceHandler.getDataFieldHandler(userId, serverName, "getPreviousDataFieldsForAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPreviousDataFieldsForAsset");
            handler.getPreviousDataFieldsForAsset(userId, discoveryReportGUID, startingFrom, maximumResults, "getPreviousDataFieldsForAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getPreviousDataFieldsForAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFieldListResponse getNewDataFieldsForAsset(String serverName, String userId, String discoveryReportGUID, int startingFrom, int maximumResults) {
        String methodName = "getNewDataFieldsForAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNewDataFieldsForAsset");
        AuditLog auditLog = null;
        DataFieldListResponse response = new DataFieldListResponse();
        try {
            DataFieldHandler<DataField> handler = instanceHandler.getDataFieldHandler(userId, serverName, "getNewDataFieldsForAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNewDataFieldsForAsset");
            handler.getNewDataFieldsForAsset(userId, discoveryReportGUID, startingFrom, maximumResults, "getNewDataFieldsForAsset");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getNewDataFieldsForAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFieldListResponse getNestedDataFields(String serverName, String userId, String parentDataFieldGUID, int startingFrom, int maximumResults) {
        String methodName = "getNestedDataFields";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNestedDataFields");
        AuditLog auditLog = null;
        DataFieldListResponse response = new DataFieldListResponse();
        try {
            DataFieldHandler<DataField> handler = instanceHandler.getDataFieldHandler(userId, serverName, "getNestedDataFields");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNestedDataFields");
            handler.getNestedDataFields(userId, parentDataFieldGUID, startingFrom, maximumResults, "getNestedDataFields");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getNestedDataFields", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFieldResponse getDataField(String serverName, String userId, String dataFieldGUID) {
        String methodName = "getDataField";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataField");
        AuditLog auditLog = null;
        DataFieldResponse response = new DataFieldResponse();
        try {
            DataFieldHandler<DataField> handler = instanceHandler.getDataFieldHandler(userId, serverName, "getDataField");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataField");
            handler.getDataField(userId, dataFieldGUID, "getDataField");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getDataField", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addDataFieldToDiscoveryReport(String serverName, String userId, String annotationGUID, DataField dataField) {
        String methodName = "addDataFieldToDiscoveryReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addDataFieldToDiscoveryReport");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            if (dataField != null) {
                DataFieldHandler<DataField> handler = instanceHandler.getDataFieldHandler(userId, serverName, "addDataFieldToDiscoveryReport");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addDataFieldToDiscoveryReport");
                int dataFieldSortOrder = 0;
                if (dataField.getDataFieldSortOrder() != null) {
                    dataFieldSortOrder = dataField.getDataFieldSortOrder().getOpenTypeOrdinal();
                }
                handler.addDataFieldToDiscoveryReport(userId, null, null, annotationGUID, dataField.getDataFieldPosition(), dataField.getDataFieldName(), dataField.getDataFieldType(), dataField.getDataFieldDescription(), dataField.getDataFieldAliases(), dataFieldSortOrder, dataField.getDefaultValue(), dataField.getAdditionalProperties(), "addDataFieldToDiscoveryReport");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addDataFieldToDiscoveryReport", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addDataFieldToDiscoveryReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addDataFieldToDataField(String serverName, String userId, String parentDataFieldGUID, DataField dataField) {
        String methodName = "addDataFieldToDataField";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addDataFieldToDataField");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            if (dataField != null) {
                DataFieldHandler<DataField> handler = instanceHandler.getDataFieldHandler(userId, serverName, "addDataFieldToDataField");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addDataFieldToDataField");
                int dataFieldSortOrder = 0;
                if (dataField.getDataFieldSortOrder() != null) {
                    dataFieldSortOrder = dataField.getDataFieldSortOrder().getOpenTypeOrdinal();
                }
                handler.addDataFieldToDataField(userId, null, null, parentDataFieldGUID, dataField.getDataFieldPosition(), dataField.getDataFieldName(), dataField.getDataFieldType(), dataField.getDataFieldDescription(), dataField.getDataFieldAliases(), dataFieldSortOrder, dataField.getDefaultValue(), dataField.getAdditionalProperties(), "addDataFieldToDataField");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addDataFieldToDataField", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addDataFieldToDataField", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addAnnotationToDataField(String serverName, String userId, String parentDataFieldGUID, Annotation annotation) {
        String methodName = "addAnnotationToDataField";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addAnnotationToDataField");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            AnnotationHandler<Annotation> handler = instanceHandler.getAnnotationHandler(userId, serverName, "addAnnotationToDataField");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addAnnotationToDataField");
            if (annotation != null) {
                response.setGUID(handler.addAnnotationToDataField(userId, parentDataFieldGUID, annotation, "addAnnotationToDataField"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addAnnotationToDataField", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addAnnotationToDataField", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDataField(String serverName, String userId, String dataFieldGUID, DataField dataField) {
        String methodName = "updateDataField";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateDataField");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            DataFieldHandler<DataField> handler = instanceHandler.getDataFieldHandler(userId, serverName, "updateDataField");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDataField");
            int dataFieldSortOrder = 0;
            if (dataField.getDataFieldSortOrder() != null) {
                dataFieldSortOrder = dataField.getDataFieldSortOrder().getOpenTypeOrdinal();
            }
            handler.updateDataField(userId, null, null, dataFieldGUID, false, dataField.getDataFieldName(), dataField.getDataFieldType(), dataField.getDataFieldDescription(), dataField.getDataFieldAliases(), dataFieldSortOrder, dataField.getDefaultValue(), dataField.getAdditionalProperties(), "updateDataField");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateDataField", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteDataField(String serverName, String userId, String dataFieldGUID, NullRequestBody requestBody) {
        String methodName = "deleteDataField";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteDataField");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            DataFieldHandler<DataField> handler = instanceHandler.getDataFieldHandler(userId, serverName, "deleteDataField");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteDataField");
            handler.deleteDataField(userId, null, null, dataFieldGUID, "deleteDataField");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "deleteDataField", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

