/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.converters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryServiceProperties;
import org.odpi.openmetadata.frameworks.discovery.properties.RegisteredDiscoveryService;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RegisteredDiscoveryServiceConverter {
    private final OMRSRepositoryHelper repositoryHelper;
    private final String serviceName;

    public RegisteredDiscoveryServiceConverter(OMRSRepositoryHelper repositoryHelper, String serviceName) {
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
    }

    public RegisteredDiscoveryService getBean(DiscoveryServiceProperties discoveryServiceProperties, List<Relationship> relationships) {
        String methodName = "getBean";
        RegisteredDiscoveryService bean = new RegisteredDiscoveryService(discoveryServiceProperties);
        if (relationships != null) {
            HashMap<String, Map> requestTypeMappings = new HashMap<String, Map>();
            for (Relationship relationship : relationships) {
                InstanceProperties instanceProperties;
                if (relationship == null || (instanceProperties = relationship.getProperties()) == null) continue;
                String requestType = this.repositoryHelper.getStringProperty(this.serviceName, "requestType", instanceProperties, "getBean");
                Map analysisParameters = this.repositoryHelper.getStringMapFromProperty(this.serviceName, "requestParameters", instanceProperties, "getBean");
                if (requestType == null) continue;
                requestTypeMappings.put(requestType, analysisParameters);
            }
            if (!requestTypeMappings.isEmpty()) {
                bean.setDiscoveryRequestTypes(requestTypeMappings);
            }
        }
        return bean;
    }
}

