/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.discoveryengine.converters.DiscoveryEngineOMASConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryEngineProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DiscoveryEnginePropertiesConverter<B>
extends DiscoveryEngineOMASConverter<B> {
    public DiscoveryEnginePropertiesConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DiscoveryEngineProperties) {
                DiscoveryEngineProperties bean = (DiscoveryEngineProperties)returnBean;
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                InstanceProperties instanceProperties = null;
                if (entity != null) {
                    instanceProperties = new InstanceProperties(entity.getProperties());
                }
                bean.setQualifiedName(this.removeQualifiedName(instanceProperties));
                bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                bean.setDisplayName(this.removeName(instanceProperties));
                bean.setDescription(this.removeDescription(instanceProperties));
                bean.setTypeDescription(this.removeCapabilityType(instanceProperties));
                bean.setVersion(this.removeCapabilityVersion(instanceProperties));
                bean.setPatchLevel(this.removePatchLevel(instanceProperties));
                bean.setSource(this.removeSource(instanceProperties));
                bean.setTypeName(bean.getElementHeader().getType().getTypeName());
                bean.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

