/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.discoveryengine.converters.AnnotationConverter;
import org.odpi.openmetadata.accessservices.discoveryengine.converters.DataFieldConverter;
import org.odpi.openmetadata.accessservices.discoveryengine.converters.DiscoveryAnalysisReportConverter;
import org.odpi.openmetadata.accessservices.discoveryengine.ffdc.DiscoveryEngineErrorCode;
import org.odpi.openmetadata.accessservices.discoveryengine.handlers.DiscoveryConfigurationHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.generichandlers.AnnotationHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.DataFieldHandler;
import org.odpi.openmetadata.commonservices.generichandlers.DiscoveryAnalysisReportHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBean;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBeanConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DataField;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DiscoveryEngineServicesInstance
extends OMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.DISCOVERY_ENGINE_OMAS;
    private AssetHandler<OpenMetadataAPIDummyBean> assetHandler;
    private AnnotationHandler<Annotation> annotationHandler;
    private DataFieldHandler dataFieldHandler;
    private DiscoveryAnalysisReportHandler<DiscoveryAnalysisReport> discoveryAnalysisReportHandler;
    private DiscoveryConfigurationHandler discoveryConfigurationHandler;
    private Connection outTopicConnection;

    public DiscoveryEngineServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, supportedZones, defaultZones, publishZones, auditLog, localServerUserId, maxPageSize);
        String methodName = "new ServiceInstance";
        if (this.repositoryHandler == null) {
            throw new NewInstanceException(DiscoveryEngineErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.assetHandler = new AssetHandler((OpenMetadataAPIGenericConverter)new OpenMetadataAPIDummyBeanConverter(this.repositoryHelper, this.serviceName, this.serverName), OpenMetadataAPIDummyBean.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.annotationHandler = new AnnotationHandler(new AnnotationConverter(this.repositoryHelper, this.serviceName, this.serverName), Annotation.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.dataFieldHandler = new DataFieldHandler(new DataFieldConverter(this.repositoryHelper, this.serviceName, this.serverName), DataField.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.discoveryAnalysisReportHandler = new DiscoveryAnalysisReportHandler(new DiscoveryAnalysisReportConverter(this.repositoryHelper, this.serviceName, this.serverName), DiscoveryAnalysisReport.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.discoveryConfigurationHandler = new DiscoveryConfigurationHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    DiscoveryConfigurationHandler getDiscoveryConfigurationHandler() {
        return this.discoveryConfigurationHandler;
    }

    AssetHandler<OpenMetadataAPIDummyBean> getAssetHandler() throws PropertyServerException {
        String methodName = "getAssetHandler";
        this.validateActiveRepository("getAssetHandler");
        return this.assetHandler;
    }

    DiscoveryAnalysisReportHandler<DiscoveryAnalysisReport> getDiscoveryAnalysisReportHandler() throws PropertyServerException {
        String methodName = "getDiscoveryAnalysisReportHandler";
        this.validateActiveRepository("getDiscoveryAnalysisReportHandler");
        return this.discoveryAnalysisReportHandler;
    }

    AnnotationHandler<Annotation> getAnnotationHandler() throws PropertyServerException {
        String methodName = "getAnnotationHandler";
        this.validateActiveRepository("getAnnotationHandler");
        return this.annotationHandler;
    }

    DataFieldHandler<DataField> getDataFieldHandler() throws PropertyServerException {
        String methodName = "getDataFieldHandler";
        this.validateActiveRepository("getDataFieldHandler");
        return this.dataFieldHandler;
    }
}

