/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.discoveryserver.ffdc;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.text.MessageFormat;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum DiscoveryServerErrorCode {
    NO_CONFIG_DOC(400, "OMAS-DISCOVERY-SERVER-400-001", "Discovery server {0} does not have a configuration document", "The server is not able to retrieve its configuration.  It fails to start.", "Add the discovery configuration to the discovery server's configuration document."),
    NO_OMAS_SERVER_URL(400, "OMAS-DISCOVERY-SERVER-400-002", "Discovery server {0} is not configured with the platform URL root for the Discovery Engine OMAS", "The server is not able to retrieve its configuration.  It fails to start.", "Add the configuration for the platform URL root to this discovery server's configuration document."),
    NO_OMAS_SERVER_NAME(400, "OMAS-DISCOVERY-SERVER-400-003", "Discovery server {0} is not configured with the name for the server running the Discovery Engine OMAS", "The server is not able to retrieve its configuration.  It fails to start.", "Add the configuration for the server name to this discovery server's configuration document."),
    NO_DISCOVERY_ENGINES(400, "OMAS-DISCOVERY-SERVER-400-004", "Discovery server {0} is configured with no discovery engines", "The server is not able to run any discovery requests.  It fails to start.", "Add the configuration for at least one discovery engine to this discovery server."),
    UNKNOWN_DISCOVERY_ENGINE(400, "DISCOVERY-SERVER-400-005 ", "Discovery engine {0} is not running in the discovery server {1}", "The discovery engine requested on a request is not known to the discovery server.", "This may be a configuration or a code error.  Look for other error messages and review the code of the discovery server.  Once the cause is resolved, retry the discovery request."),
    SERVICE_INSTANCE_FAILURE(400, "DISCOVERY-SERVER-400-006", "The discovery engine services are unable to initialize a new instance of discovery server {0}; error message is {1}", "The discovery engine services detected an error during the start up of a specific discovery server instance.  Its discovery services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    NO_DISCOVERY_ENGINES_STARTED(400, "OMAS-DISCOVERY-SERVER-400-007", "Discovery server {0} is unable to start any discovery engines", "The server is not able to run any discovery requests.  It fails to start.", "Add the configuration for at least one discovery engine to this discovery server.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private DiscoveryServerErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public int getHTTPErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getFormattedErrorMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.errorMessage);
        String result = mf.format(params);
        log.debug(String.format("ODFErrorCode.getMessage(%s): %s", Arrays.toString(params), result));
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    static {
        log = LoggerFactory.getLogger(DiscoveryServerErrorCode.class);
    }
}

