/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.discoveryserver.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.client.ODFRESTClient;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryRequestRequestBody;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryEngine;
import org.odpi.openmetadata.frameworks.discovery.ffdc.DiscoveryEngineException;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;

public class DiscoveryServerClient
extends DiscoveryEngine {
    private String serverName;
    private String serverPlatformRootURL;
    private String discoveryEngineGUID;
    private ODFRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public DiscoveryServerClient(String serverPlatformRootURL, String serverName, String discoveryEngineGUID) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.discoveryEngineGUID = discoveryEngineGUID;
        this.restClient = new ODFRESTClient(serverName, serverPlatformRootURL);
    }

    public DiscoveryServerClient(String serverPlatformRootURL, String serverName, String discoveryEngineGUID, String userId, String password) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.discoveryEngineGUID = discoveryEngineGUID;
        this.restClient = new ODFRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public String discoverAsset(String userId, String assetGUID, String assetDiscoveryType) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        return this.discoverAsset(userId, assetGUID, assetDiscoveryType, null, null);
    }

    public String discoverAsset(String userId, String assetGUID, String assetDiscoveryType, Map<String, String> analysisParameters) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        return this.discoverAsset(userId, assetGUID, assetDiscoveryType, analysisParameters, null);
    }

    public String discoverAsset(String userId, String assetGUID, String assetDiscoveryType, Map<String, String> analysisParameters, List<String> annotationTypes) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        String methodName = "discoverAsset";
        String assetGUIDParameterName = "assetGUID";
        String assetTypeParameterName = "assetDiscoveryType";
        String urlTemplate = "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engine/{2}/asset-discovery-types/{3}/assets/{4}";
        this.invalidParameterHandler.validateUserId(userId, "discoverAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "discoverAsset");
        this.invalidParameterHandler.validateName(assetDiscoveryType, "assetDiscoveryType", "discoverAsset");
        DiscoveryRequestRequestBody requestBody = new DiscoveryRequestRequestBody();
        requestBody.setAnalysisParameters(analysisParameters);
        requestBody.setAnnotationTypes(annotationTypes);
        try {
            GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("discoverAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engine/{2}/asset-discovery-types/{3}/assets/{4}", (Object)requestBody, new Object[]{this.serverName, userId, this.discoveryEngineGUID, assetDiscoveryType, assetGUID});
            this.exceptionHandler.detectAndThrowInvalidParameterException("discoverAsset", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException("discoverAsset", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException("discoverAsset", (FFDCResponseBase)restResult);
            return restResult.getGUID();
        }
        catch (PropertyServerException exception) {
            throw new DiscoveryEngineException((OCFCheckedExceptionBase)exception);
        }
    }

    public void scanAllAssets(String userId, String assetDiscoveryType, Map<String, String> analysisParameters, List<String> annotationTypes) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        String methodName = "discoverAsset";
        String assetTypeParameterName = "assetDiscoveryType";
        String urlTemplate = "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engine/{2}/asset-discovery-types/{3}/assets";
        this.invalidParameterHandler.validateUserId(userId, "discoverAsset");
        this.invalidParameterHandler.validateName(assetDiscoveryType, "assetDiscoveryType", "discoverAsset");
        DiscoveryRequestRequestBody requestBody = new DiscoveryRequestRequestBody();
        requestBody.setAnalysisParameters(analysisParameters);
        requestBody.setAnnotationTypes(annotationTypes);
        try {
            VoidResponse restResult = this.restClient.callVoidPostRESTCall("discoverAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engine/{2}/asset-discovery-types/{3}/assets", (Object)requestBody, new Object[]{this.serverName, userId, this.discoveryEngineGUID, assetDiscoveryType});
            this.exceptionHandler.detectAndThrowInvalidParameterException("discoverAsset", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException("discoverAsset", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException("discoverAsset", (FFDCResponseBase)restResult);
        }
        catch (PropertyServerException exception) {
            throw new DiscoveryEngineException((OCFCheckedExceptionBase)exception);
        }
    }

    public DiscoveryRequestStatus getDiscoveryStatus(String userId, String discoveryRequestGUID) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        DiscoveryAnalysisReport report = this.getDiscoveryReport(userId, discoveryRequestGUID);
        if (report != null) {
            return report.getDiscoveryRequestStatus();
        }
        return null;
    }

    public DiscoveryAnalysisReport getDiscoveryReport(String userId, String discoveryRequestGUID) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        String methodName = "getDiscoveryAnalysisReport";
        String reportGUIDParameterName = "discoveryRequestGUID";
        String urlTemplate = "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engine/{2}/discovery-analysis-reports/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateGUID(discoveryRequestGUID, "discoveryRequestGUID", "getDiscoveryAnalysisReport");
        try {
            DiscoveryAnalysisReportResponse restResult = this.restClient.callDiscoveryAnalysisReportGetRESTCall("getDiscoveryAnalysisReport", this.serverPlatformRootURL + "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engine/{2}/discovery-analysis-reports/{3}", new Object[]{this.serverName, userId, this.discoveryEngineGUID, discoveryRequestGUID});
            this.exceptionHandler.detectAndThrowInvalidParameterException("getDiscoveryAnalysisReport", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getDiscoveryAnalysisReport", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException("getDiscoveryAnalysisReport", (FFDCResponseBase)restResult);
            return restResult.getAnalysisReport();
        }
        catch (PropertyServerException exception) {
            throw new DiscoveryEngineException((OCFCheckedExceptionBase)exception);
        }
    }

    public List<Annotation> getDiscoveryReportAnnotations(String userId, String discoveryRequestGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        String methodName = "getDiscoveryReportAnnotations";
        String reportGUIDParameterName = "discoveryReportGUID";
        String urlTemplate = "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engine/{2}/discovery-analysis-reports/{3}/annotations?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryReportAnnotations");
        this.invalidParameterHandler.validateGUID(discoveryRequestGUID, "discoveryReportGUID", "getDiscoveryReportAnnotations");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getDiscoveryReportAnnotations");
        try {
            AnnotationListResponse restResult = this.restClient.callAnnotationListGetRESTCall("getDiscoveryReportAnnotations", this.serverPlatformRootURL + "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engine/{2}/discovery-analysis-reports/{3}/annotations?startingFrom={4}&maximumResults={5}", new Object[]{this.serverName, userId, this.discoveryEngineGUID, discoveryRequestGUID, Integer.toString(startingFrom), Integer.toString(maximumResults)});
            this.exceptionHandler.detectAndThrowInvalidParameterException("getDiscoveryReportAnnotations", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getDiscoveryReportAnnotations", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException("getDiscoveryReportAnnotations", (FFDCResponseBase)restResult);
            return restResult.getAnnotations();
        }
        catch (PropertyServerException exception) {
            throw new DiscoveryEngineException((OCFCheckedExceptionBase)exception);
        }
    }

    public List<Annotation> getExtendedAnnotations(String userId, String discoveryRequestGUID, String annotationGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        String methodName = "getExtendedAnnotations";
        String annotationGUIDParameterName = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engine/{2}/discovery-analysis-reports/{3}/annotations/{4}/extended-annotations?startingFrom={5}&maximumResults={6}";
        this.invalidParameterHandler.validateUserId(userId, "getExtendedAnnotations");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "getExtendedAnnotations");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getExtendedAnnotations");
        try {
            AnnotationListResponse restResult = this.restClient.callAnnotationListGetRESTCall("getExtendedAnnotations", this.serverPlatformRootURL + "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engine/{2}/discovery-analysis-reports/{3}/annotations/{4}/extended-annotations?startingFrom={5}&maximumResults={6}", new Object[]{this.serverName, userId, this.discoveryEngineGUID, discoveryRequestGUID, annotationGUID, Integer.toString(startingFrom), Integer.toString(maximumResults)});
            this.exceptionHandler.detectAndThrowInvalidParameterException("getExtendedAnnotations", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getExtendedAnnotations", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException("getExtendedAnnotations", (FFDCResponseBase)restResult);
            return restResult.getAnnotations();
        }
        catch (PropertyServerException exception) {
            throw new DiscoveryEngineException((OCFCheckedExceptionBase)exception);
        }
    }

    public Annotation getAnnotation(String userId, String discoveryRequestGUID, String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        String methodName = "getAnnotation";
        String annotationGUIDParameterName = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engine/{2}/discovery-analysis-reports/{3}/annotations/{4}";
        this.invalidParameterHandler.validateUserId(userId, "getAnnotation");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "getAnnotation");
        try {
            AnnotationResponse restResult = this.restClient.callAnnotationGetRESTCall("getAnnotation", this.serverPlatformRootURL + "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engine/{2}/discovery-analysis-reports/{3}/annotations/{4}", new Object[]{this.serverName, userId, this.discoveryEngineGUID, discoveryRequestGUID, annotationGUID});
            this.exceptionHandler.detectAndThrowInvalidParameterException("getAnnotation", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getAnnotation", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException("getAnnotation", (FFDCResponseBase)restResult);
            return restResult.getAnnotation();
        }
        catch (PropertyServerException exception) {
            throw new DiscoveryEngineException((OCFCheckedExceptionBase)exception);
        }
    }
}

