/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.discoveryengineservices.client;

import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.ffdc.DiscoveryEngineException;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.client.DiscoveryEngineServicesRESTClient;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.properties.DiscoveryEngineSummary;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.rest.DiscoveryEngineStatusResponse;

public class DiscoveryServerClient {
    private String serverName;
    private String serverPlatformRootURL;
    private DiscoveryEngineServicesRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public DiscoveryServerClient(String serverPlatformRootURL, String serverName) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.restClient = new DiscoveryEngineServicesRESTClient(serverName, serverPlatformRootURL);
    }

    public DiscoveryServerClient(String serverPlatformRootURL, String serverName, String userId, String password) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.restClient = new DiscoveryEngineServicesRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    List<DiscoveryEngineSummary> getDiscoveryEngineStatuses(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryEngineStatuses";
        String urlTemplate = "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engines/status";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryEngineStatuses");
        DiscoveryEngineStatusResponse restResult = this.restClient.callDiscoveryEngineStatusGetRESTCall("getDiscoveryEngineStatuses", this.serverPlatformRootURL + "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engines/status", this.serverName, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
        return restResult.getDiscoveryEngineSummaries();
    }

    public void refreshConfig(String userId, String discoveryEngineName) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        String methodName = "refreshConfig";
        String discoveryEngineParameterName = "discoveryEngineName";
        String urlTemplate = "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engines/{2}/refresh-config";
        this.invalidParameterHandler.validateUserId(userId, "refreshConfig");
        this.invalidParameterHandler.validateName(discoveryEngineName, "discoveryEngineName", "refreshConfig");
        try {
            VoidResponse restResult = this.restClient.callVoidGetRESTCall("refreshConfig", this.serverPlatformRootURL + "/servers/{0}/open-metadata/discovery-server/users/{1}/discovery-engines/{2}/refresh-config", new Object[]{this.serverName, userId, discoveryEngineName});
            this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
        }
        catch (PropertyServerException exception) {
            throw new DiscoveryEngineException(exception.getReportedErrorMessage(), (OCFCheckedExceptionBase)exception);
        }
    }
}

