/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.discoveryserver.handlers;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryAnnotationStoreClient;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryAssetStoreClient;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryConfigurationClient;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryEngineClient;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.client.ODFRESTClient;
import org.odpi.openmetadata.discoveryserver.auditlog.DiscoveryServerAuditCode;
import org.odpi.openmetadata.discoveryserver.handlers.DiscoveryServiceHandler;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAnnotationStore;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAssetStore;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryContext;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryService;
import org.odpi.openmetadata.frameworks.discovery.ffdc.DiscoveryEngineException;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryEngineProperties;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryServiceProperties;
import org.odpi.openmetadata.frameworks.discovery.properties.RegisteredDiscoveryService;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;

public class DiscoveryEngineHandler {
    private String serverName;
    private String serverUserId;
    private OMRSAuditLog auditLog;
    private DiscoveryEngineClient discoveryEngineClient;
    private String discoveryEngineGUID;
    private DiscoveryEngineProperties discoveryEngineProperties;
    private Map<String, DiscoveryServiceCache> discoveryServiceLookupTable = new HashMap<String, DiscoveryServiceCache>();

    public DiscoveryEngineHandler(String discoveryEngineGUID, String serverPlatformRootURL, String serverName, String serverUserId, DiscoveryConfigurationClient configurationClient, ODFRESTClient restClient, OMRSAuditLog auditLog, int maxPageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.discoveryEngineGUID = discoveryEngineGUID;
        this.discoveryEngineProperties = configurationClient.getDiscoveryEngineByGUID(serverUserId, discoveryEngineGUID);
        int startingFrom = 0;
        boolean moreToReceive = true;
        while (moreToReceive) {
            List registeredDiscoveryServices = configurationClient.getRegisteredDiscoveryServices(serverUserId, discoveryEngineGUID, startingFrom, maxPageSize);
            if (registeredDiscoveryServices != null && !registeredDiscoveryServices.isEmpty()) {
                for (String registeredDiscoveryServiceGUID : registeredDiscoveryServices) {
                    RegisteredDiscoveryService discoveryService;
                    if (registeredDiscoveryServiceGUID == null || (discoveryService = configurationClient.getRegisteredDiscoveryService(serverUserId, discoveryEngineGUID, registeredDiscoveryServiceGUID)) == null || discoveryService.getAssetTypes() == null) continue;
                    for (String assetType : discoveryService.getAssetTypes()) {
                        DiscoveryServiceCache discoveryServiceCache = new DiscoveryServiceCache((DiscoveryServiceProperties)discoveryService);
                        this.discoveryServiceLookupTable.put(assetType, discoveryServiceCache);
                    }
                }
                if (registeredDiscoveryServices.size() < maxPageSize) {
                    moreToReceive = false;
                    continue;
                }
                startingFrom += maxPageSize;
                continue;
            }
            moreToReceive = false;
        }
        this.serverName = serverName;
        this.serverUserId = serverUserId;
        this.auditLog = auditLog;
        this.discoveryEngineClient = new DiscoveryEngineClient(serverName, serverPlatformRootURL, restClient);
    }

    public String discoverAsset(String assetGUID, String assetType, Map<String, String> analysisParameters, List<String> annotationTypes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Date creationTime = new Date();
        DiscoveryServiceCache discoveryServiceCache = this.discoveryServiceLookupTable.get(assetType);
        if (discoveryServiceCache != null) {
            DiscoveryAnalysisReport discoveryReport = this.discoveryEngineClient.createDiscoveryAnalysisReport(this.serverUserId, "DiscoveryAnalysisReport:" + assetType + ":" + assetGUID + ":" + creationTime.toString(), "Discovery Analysis Report for " + assetGUID, "This is the " + assetType + " discovery analysis report for asset " + assetGUID + " generated at " + creationTime.toString() + " by the " + discoveryServiceCache.getDiscoveryServiceName() + " discovery service running on discovery engine " + this.discoveryEngineProperties.getDisplayName() + " (" + this.discoveryEngineGUID + ").", creationTime, analysisParameters, DiscoveryRequestStatus.WAITING, assetGUID, this.discoveryEngineGUID, discoveryServiceCache.getDiscoveryServiceGUID(), null, null);
            DiscoveryAnnotationStoreClient annotationStore = new DiscoveryAnnotationStoreClient(this.serverUserId, assetGUID, discoveryReport.getGUID(), this.discoveryEngineClient);
            DiscoveryAssetStoreClient assetStore = new DiscoveryAssetStoreClient(assetGUID, this.serverUserId, this.discoveryEngineClient);
            DiscoveryContext discoveryContext = new DiscoveryContext(this.serverUserId, assetGUID, discoveryReport.getGUID(), analysisParameters, annotationTypes, (DiscoveryAssetStore)assetStore, (DiscoveryAnnotationStore)annotationStore);
            DiscoveryServiceHandler discoveryServiceHandler = new DiscoveryServiceHandler(this.discoveryEngineProperties, assetType, discoveryServiceCache.getDiscoveryServiceName(), discoveryServiceCache.getNextDiscoveryService(), discoveryContext, this.auditLog, this.discoveryEngineClient, this.serverUserId);
            Thread thread = new Thread((Runnable)discoveryServiceHandler, discoveryServiceCache.getDiscoveryServiceName() + assetGUID + new Date().toString());
            thread.start();
            return discoveryReport.getGUID();
        }
        return null;
    }

    public DiscoveryAnalysisReport getDiscoveryReport(String discoveryRequestGUID) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        try {
            return this.discoveryEngineClient.getDiscoveryAnalysisReport(this.serverUserId, discoveryRequestGUID);
        }
        catch (PropertyServerException error) {
            throw new DiscoveryEngineException((OCFCheckedExceptionBase)error);
        }
    }

    public List<Annotation> getDiscoveryReportAnnotations(String discoveryRequestGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        try {
            return this.discoveryEngineClient.getDiscoveryReportAnnotations(this.serverUserId, discoveryRequestGUID, startingFrom, maximumResults);
        }
        catch (PropertyServerException error) {
            throw new DiscoveryEngineException((OCFCheckedExceptionBase)error);
        }
    }

    public List<Annotation> getExtendedAnnotations(String discoveryRequestGUID, String annotationGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        try {
            return this.discoveryEngineClient.getExtendedAnnotations(this.serverUserId, discoveryRequestGUID, annotationGUID, startingFrom, maximumResults);
        }
        catch (PropertyServerException error) {
            throw new DiscoveryEngineException((OCFCheckedExceptionBase)error);
        }
    }

    public Annotation getAnnotation(String discoveryRequestGUID, String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, DiscoveryEngineException {
        try {
            return this.discoveryEngineClient.getAnnotation(this.serverUserId, discoveryRequestGUID, annotationGUID);
        }
        catch (PropertyServerException error) {
            throw new DiscoveryEngineException((OCFCheckedExceptionBase)error);
        }
    }

    public void terminate() {
        String actionDescription = "terminate";
        DiscoveryServerAuditCode auditCode = DiscoveryServerAuditCode.ENGINE_SHUTDOWN;
        this.auditLog.logRecord("terminate", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.discoveryEngineGUID, this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    private class DiscoveryServiceCache {
        private DiscoveryService nextDiscoveryService;
        private DiscoveryServiceProperties properties;

        DiscoveryServiceCache(DiscoveryServiceProperties properties) throws InvalidParameterException, PropertyServerException {
            this.properties = properties;
            this.getNextDiscoveryService();
        }

        String getDiscoveryServiceName() {
            return this.properties.getQualifiedName();
        }

        String getDiscoveryServiceGUID() {
            return this.properties.getGUID();
        }

        synchronized DiscoveryService getNextDiscoveryService() throws InvalidParameterException, PropertyServerException {
            DiscoveryService returnValue = this.nextDiscoveryService;
            try {
                ConnectorBroker connectorBroker = new ConnectorBroker();
                this.nextDiscoveryService = (DiscoveryService)connectorBroker.getConnector(this.properties.getConnection());
            }
            catch (ConnectionCheckedException error) {
                throw new InvalidParameterException((OCFCheckedExceptionBase)error, this.properties.getQualifiedName() + "DiscoveryService Connection");
            }
            catch (ConnectorCheckedException error) {
                throw new PropertyServerException((OCFCheckedExceptionBase)error);
            }
            return returnValue;
        }
    }
}

