/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.discoveryserver.handlers;

import java.util.Date;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryEngineClient;
import org.odpi.openmetadata.discoveryserver.auditlog.DiscoveryServerAuditCode;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryContext;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryService;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryEngineProperties;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;

public class DiscoveryServiceHandler
implements Runnable {
    private DiscoveryEngineProperties discoveryEngineProperties;
    private String assetType;
    private String discoveryServiceName;
    private DiscoveryService discoveryService;
    private DiscoveryContext discoveryContext;
    private OMRSAuditLog auditLog;
    private DiscoveryEngineClient discoveryEngineClient;
    private String discoveryEngineUserId;

    DiscoveryServiceHandler(DiscoveryEngineProperties discoveryEngineProperties, String assetType, String discoveryServiceName, DiscoveryService discoveryService, DiscoveryContext discoveryContext, OMRSAuditLog auditLog, DiscoveryEngineClient discoveryEngineClient, String discoveryEngineUserId) {
        this.discoveryEngineProperties = discoveryEngineProperties;
        this.assetType = assetType;
        this.discoveryServiceName = discoveryServiceName;
        this.discoveryService = discoveryService;
        this.discoveryContext = discoveryContext;
        this.auditLog = auditLog;
        this.discoveryEngineClient = discoveryEngineClient;
        this.discoveryEngineUserId = discoveryEngineUserId;
    }

    @Override
    public void run() {
        String actionDescription = "discoverAsset";
        DiscoveryServerAuditCode auditCode = DiscoveryServerAuditCode.DISCOVERY_SERVICE_STARTING;
        this.auditLog.logRecord("discoverAsset", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.discoveryServiceName, this.discoveryContext.getAssetGUID(), this.assetType, this.discoveryEngineProperties.getQualifiedName(), this.discoveryEngineProperties.getGUID(), this.discoveryContext.getDiscoveryReportGUID()), null, auditCode.getSystemAction(), auditCode.getUserAction());
        try {
            this.discoveryEngineClient.setDiscoveryStatus(this.discoveryEngineUserId, this.discoveryContext.getDiscoveryReportGUID(), DiscoveryRequestStatus.IN_PROGRESS);
            this.discoveryService.setDiscoveryContext(this.discoveryContext);
            this.discoveryService.setDiscoveryServiceName(this.discoveryServiceName);
            Date startTime = new Date();
            this.discoveryService.start();
            Date endTime = new Date();
            auditCode = DiscoveryServerAuditCode.DISCOVERY_SERVICE_COMPLETE;
            this.auditLog.logRecord("discoverAsset", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.discoveryServiceName, this.discoveryContext.getAssetGUID(), this.assetType, Long.toString(endTime.getTime() - startTime.getTime()), this.discoveryContext.getDiscoveryReportGUID()), null, auditCode.getSystemAction(), auditCode.getUserAction());
            this.discoveryEngineClient.setDiscoveryStatus(this.discoveryEngineUserId, this.discoveryContext.getDiscoveryReportGUID(), DiscoveryRequestStatus.COMPLETED);
            this.discoveryService.disconnect();
        }
        catch (Throwable error) {
            auditCode = DiscoveryServerAuditCode.DISCOVERY_SERVICE_FAILED;
            this.auditLog.logRecord("discoverAsset", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.discoveryServiceName, error.getClass().getName(), this.discoveryContext.getDiscoveryReportGUID(), this.discoveryContext.getAssetGUID(), this.assetType, this.discoveryEngineProperties.getQualifiedName(), this.discoveryEngineProperties.getGUID(), error.getMessage()), error.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
            try {
                this.discoveryEngineClient.setDiscoveryStatus(this.discoveryEngineUserId, this.discoveryContext.getDiscoveryReportGUID(), DiscoveryRequestStatus.FAILED);
            }
            catch (Throwable statusError) {
                auditCode = DiscoveryServerAuditCode.EXC_ON_ERROR_STATUS_UPDATE;
                this.auditLog.logException("discoverAsset", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.discoveryEngineProperties.getDisplayName(), this.discoveryServiceName, statusError.getClass().getName(), statusError.getMessage()), statusError.toString(), auditCode.getSystemAction(), auditCode.getUserAction(), statusError);
            }
        }
    }
}

