/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.discoveryserver.server;

import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.DiscoveryServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.client.ODFRESTClient;
import org.odpi.openmetadata.discoveryserver.auditlog.DiscoveryServerAuditCode;
import org.odpi.openmetadata.discoveryserver.ffdc.DiscoveryServerErrorCode;
import org.odpi.openmetadata.discoveryserver.handlers.DiscoveryEngineHandler;
import org.odpi.openmetadata.discoveryserver.server.DiscoveryServerInstance;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;

public class DiscoveryServerOperationalServices {
    private String localServerName;
    private String localServerUserId;
    private String localServerPassword;
    private int maxPageSize;
    private DiscoveryServerInstance discoveryServerInstance = null;
    private OMRSAuditLog auditLog = null;

    public DiscoveryServerOperationalServices(String localServerName, String localServerUserId, String localServerPassword, int maxPageSize) {
        this.localServerName = localServerName;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
        this.maxPageSize = maxPageSize;
    }

    public void initialize(DiscoveryServerConfig discoveryServerConfig, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        DiscoveryConfigurationClient configurationClient;
        ODFRESTClient ODFRESTClient2;
        String actionDescription = "initialize";
        String methodName = "initialize";
        this.auditLog = auditLog;
        DiscoveryServerAuditCode auditCode = DiscoveryServerAuditCode.SERVER_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        if (discoveryServerConfig == null) {
            DiscoveryServerErrorCode errorCode = DiscoveryServerErrorCode.NO_CONFIG_DOC;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.localServerName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "initialize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (discoveryServerConfig.getAccessServiceRootURL() == null) {
            auditCode = DiscoveryServerAuditCode.NO_OMAS_SERVER_URL;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            DiscoveryServerErrorCode errorCode = DiscoveryServerErrorCode.NO_OMAS_SERVER_URL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.localServerName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "initialize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (discoveryServerConfig.getAccessServiceServerName() == null) {
            auditCode = DiscoveryServerAuditCode.NO_OMAS_SERVER_NAME;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            DiscoveryServerErrorCode errorCode = DiscoveryServerErrorCode.NO_OMAS_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.localServerName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "initialize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        try {
            ODFRESTClient2 = this.localServerName != null && this.localServerPassword != null ? new ODFRESTClient(discoveryServerConfig.getAccessServiceServerName(), discoveryServerConfig.getAccessServiceRootURL(), this.localServerUserId, this.localServerPassword) : new ODFRESTClient(discoveryServerConfig.getAccessServiceServerName(), discoveryServerConfig.getAccessServiceRootURL());
            configurationClient = new DiscoveryConfigurationClient(discoveryServerConfig.getAccessServiceServerName(), discoveryServerConfig.getAccessServiceRootURL(), ODFRESTClient2, this.maxPageSize);
        }
        catch (InvalidParameterException error) {
            throw new OMAGConfigurationErrorException(error.getReportedHTTPCode(), this.getClass().getName(), "initialize", error.getErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction(), (Throwable)error);
        }
        List discoveryEngineGUIDs = discoveryServerConfig.getDiscoveryEngineGUIDs();
        if (discoveryEngineGUIDs == null || discoveryEngineGUIDs.isEmpty()) {
            auditCode = DiscoveryServerAuditCode.NO_DISCOVERY_ENGINES;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            DiscoveryServerErrorCode errorCode = DiscoveryServerErrorCode.NO_DISCOVERY_ENGINES;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.localServerName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "initialize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        HashMap<String, DiscoveryEngineHandler> discoveryEngineHandlers = new HashMap<String, DiscoveryEngineHandler>();
        try {
            for (String discoveryEngineGUID : discoveryEngineGUIDs) {
                if (discoveryEngineGUID == null) continue;
                DiscoveryEngineHandler handler = new DiscoveryEngineHandler(discoveryEngineGUID, discoveryServerConfig.getAccessServiceRootURL(), discoveryServerConfig.getAccessServiceServerName(), this.localServerUserId, configurationClient, ODFRESTClient2, auditLog, this.maxPageSize);
                discoveryEngineHandlers.put(discoveryEngineGUID, handler);
            }
        }
        catch (Throwable error) {
            auditCode = DiscoveryServerAuditCode.SERVICE_INSTANCE_FAILURE;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName, error.getMessage()), error.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
            DiscoveryServerErrorCode errorCode = DiscoveryServerErrorCode.SERVICE_INSTANCE_FAILURE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.localServerName, error.getMessage()});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "initialize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (discoveryEngineHandlers.isEmpty()) {
            auditCode = DiscoveryServerAuditCode.NO_DISCOVERY_ENGINES_STARTED;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            DiscoveryServerErrorCode errorCode = DiscoveryServerErrorCode.NO_DISCOVERY_ENGINES_STARTED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.localServerName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "initialize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.discoveryServerInstance = new DiscoveryServerInstance(this.localServerName, GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName(), auditLog, this.localServerUserId, this.maxPageSize, discoveryServerConfig.getAccessServiceRootURL(), discoveryServerConfig.getAccessServiceServerName(), discoveryEngineHandlers);
    }

    public void terminate() {
        String actionDescription = "terminate";
        DiscoveryServerAuditCode auditCode = DiscoveryServerAuditCode.SERVER_SHUTTING_DOWN;
        this.auditLog.logRecord("terminate", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        this.discoveryServerInstance.shutdown();
        auditCode = DiscoveryServerAuditCode.SERVER_SHUTDOWN;
        this.auditLog.logRecord("terminate", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

