/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.discoveryserver.server;

import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryRequestRequestBody;
import org.odpi.openmetadata.discoveryserver.handlers.DiscoveryEngineHandler;
import org.odpi.openmetadata.discoveryserver.server.DiscoveryServerInstanceHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryServerRESTServices {
    private static DiscoveryServerInstanceHandler instanceHandler = new DiscoveryServerInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(DiscoveryServerRESTServices.class);
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse discoverAsset(String serverName, String discoveryEngineGUID, String userId, String assetGUID, String assetType, DiscoveryRequestRequestBody requestBody) {
        String methodName = "discoverAsset";
        log.debug("Calling method: discoverAsset");
        GUIDResponse response = new GUIDResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryEngineHandler handler = instanceHandler.getDiscoveryEngineHandler(userId, serverName, discoveryEngineGUID, "discoverAsset");
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "discoverAsset", serverName);
            } else {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "discoverAsset");
                response.setGUID(handler.discoverAsset(assetGUID, assetType, requestBody.getAnalysisParameters(), requestBody.getAnnotationTypes()));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "discoverAsset", auditLog);
        }
        log.debug("Returning from method: discoverAsset with response: " + response.toString());
        return response;
    }

    public DiscoveryAnalysisReportResponse getDiscoveryReport(String serverName, String discoveryEngineGUID, String userId, String discoveryRequestGUID) {
        String methodName = "getDiscoveryAnalysisReport";
        log.debug("Calling method: getDiscoveryAnalysisReport");
        DiscoveryAnalysisReportResponse response = new DiscoveryAnalysisReportResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryEngineHandler handler = instanceHandler.getDiscoveryEngineHandler(userId, serverName, discoveryEngineGUID, "getDiscoveryAnalysisReport");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryAnalysisReport");
            response.setAnalysisReport(handler.getDiscoveryReport(discoveryRequestGUID));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryAnalysisReport", auditLog);
        }
        log.debug("Returning from method: getDiscoveryAnalysisReport with response: " + response.toString());
        return response;
    }

    public AnnotationListResponse getDiscoveryReportAnnotations(String serverName, String discoveryEngineGUID, String userId, String discoveryRequestGUID, int startingFrom, int maximumResults) {
        String methodName = "getDiscoveryReportAnnotations";
        log.debug("Calling method: getDiscoveryReportAnnotations");
        AnnotationListResponse response = new AnnotationListResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryEngineHandler handler = instanceHandler.getDiscoveryEngineHandler(userId, serverName, discoveryEngineGUID, "getDiscoveryReportAnnotations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryReportAnnotations");
            response.setAnnotations(handler.getDiscoveryReportAnnotations(discoveryRequestGUID, startingFrom, maximumResults));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryReportAnnotations", auditLog);
        }
        log.debug("Returning from method: getDiscoveryReportAnnotations with response: " + response.toString());
        return response;
    }

    public AnnotationListResponse getExtendedAnnotations(String serverName, String discoveryEngineGUID, String userId, String discoveryRequestGUID, String annotationGUID, int startingFrom, int maximumResults) {
        String methodName = "getExtendedAnnotations";
        log.debug("Calling method: getExtendedAnnotations");
        AnnotationListResponse response = new AnnotationListResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryEngineHandler handler = instanceHandler.getDiscoveryEngineHandler(userId, serverName, discoveryEngineGUID, "getExtendedAnnotations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExtendedAnnotations");
            response.setAnnotations(handler.getExtendedAnnotations(discoveryRequestGUID, annotationGUID, startingFrom, maximumResults));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getExtendedAnnotations", auditLog);
        }
        log.debug("Returning from method: getExtendedAnnotations with response: " + response.toString());
        return response;
    }

    public AnnotationResponse getAnnotation(String serverName, String discoveryEngineGUID, String userId, String discoveryRequestGUID, String annotationGUID) {
        String methodName = "getAnnotation";
        log.debug("Calling method: getAnnotation");
        AnnotationResponse response = new AnnotationResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryEngineHandler handler = instanceHandler.getDiscoveryEngineHandler(userId, serverName, discoveryEngineGUID, "getAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAnnotation");
            response.setAnnotation(handler.getAnnotation(discoveryRequestGUID, annotationGUID));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAnnotation", auditLog);
        }
        log.debug("Returning from method: getAnnotation with response: " + response.toString());
        return response;
    }
}

