/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.discoveryserver.server;

import java.util.Map;
import org.odpi.openmetadata.commonservices.multitenant.GovernanceServerServiceInstance;
import org.odpi.openmetadata.discoveryserver.ffdc.DiscoveryServerErrorCode;
import org.odpi.openmetadata.discoveryserver.handlers.DiscoveryEngineHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;

public class DiscoveryServerInstance
extends GovernanceServerServiceInstance {
    private Map<String, DiscoveryEngineHandler> discoveryEngineInstances;

    public DiscoveryServerInstance(String serverName, String serviceName, OMRSAuditLog auditLog, String localServerUserId, int maxPageSize, String accessServiceRootURL, String accessServiceServerName, Map<String, DiscoveryEngineHandler> discoveryEngineInstances) {
        super(serverName, serviceName, auditLog, localServerUserId, maxPageSize, accessServiceRootURL, accessServiceServerName);
        this.discoveryEngineInstances = discoveryEngineInstances;
    }

    synchronized DiscoveryEngineHandler getDiscoveryEngine(String discoveryEngineGUID) throws InvalidParameterException {
        String methodName = "getDiscoveryEngine";
        String guidParameterName = "discoveryEngineGUID";
        DiscoveryEngineHandler instance = this.discoveryEngineInstances.get(discoveryEngineGUID);
        if (instance == null) {
            DiscoveryServerErrorCode errorCode = DiscoveryServerErrorCode.UNKNOWN_DISCOVERY_ENGINE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.serverName, discoveryEngineGUID});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getDiscoveryEngine", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "discoveryEngineGUID");
        }
        return instance;
    }

    public void shutdown() {
        if (this.discoveryEngineInstances != null) {
            for (DiscoveryEngineHandler handler : this.discoveryEngineInstances.values()) {
                if (handler == null) continue;
                handler.terminate();
            }
        }
        super.shutdown();
    }
}

