/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.discoveryengineservices.server;

import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryRequestRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.ffdc.DiscoveryEngineException;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.handlers.DiscoveryEngineHandler;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.rest.DiscoveryEngineStatusResponse;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.server.DiscoveryServerInstanceHandler;
import org.slf4j.LoggerFactory;

public class DiscoveryServerRESTServices {
    private static DiscoveryServerInstanceHandler instanceHandler = new DiscoveryServerInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DiscoveryServerRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public VoidResponse refreshConfig(String serverName, String discoveryEngineName, String userId) {
        String methodName = "refreshConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "refreshConfig");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryEngineHandler handler = instanceHandler.getDiscoveryEngineHandler(userId, serverName, discoveryEngineName, "refreshConfig");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshConfig");
            handler.refreshConfig();
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "refreshConfig", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DiscoveryEngineStatusResponse getDiscoveryEngineStatuses(String serverName, String userId) {
        String methodName = "getDiscoveryEngineStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryEngineStatuses");
        DiscoveryEngineStatusResponse response = new DiscoveryEngineStatusResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryEngineStatuses");
            response.setDiscoveryEngineSummaries(instanceHandler.getDiscoveryEngineStatuses(userId, serverName, "getDiscoveryEngineStatuses"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryEngineStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse discoverAsset(String serverName, String discoveryEngineName, String userId, String assetGUID, String discoveryRequestType, DiscoveryRequestRequestBody requestBody) {
        String methodName = "discoverAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "discoverAsset");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryEngineHandler handler = instanceHandler.getDiscoveryEngineHandler(userId, serverName, discoveryEngineName, "discoverAsset");
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "discoverAsset", serverName);
            } else {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "discoverAsset");
                response.setGUID(handler.discoverAsset(assetGUID, discoveryRequestType, requestBody.getAnalysisParameters(), requestBody.getAnnotationTypes()));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (DiscoveryEngineException error) {
            this.captureDiscoveryEngineException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "discoverAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse scanAllAssets(String serverName, String discoveryEngineName, String userId, String discoveryRequestType, DiscoveryRequestRequestBody requestBody) {
        String methodName = "scanAllAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "scanAllAssets");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryEngineHandler handler = instanceHandler.getDiscoveryEngineHandler(userId, serverName, discoveryEngineName, "scanAllAssets");
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "scanAllAssets", serverName);
            } else {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "scanAllAssets");
                handler.scanAllAssets(discoveryRequestType, requestBody.getAnalysisParameters(), requestBody.getAnnotationTypes());
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (DiscoveryEngineException error) {
            this.captureDiscoveryEngineException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "scanAllAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DiscoveryAnalysisReportResponse getDiscoveryAnalysisReport(String serverName, String discoveryEngineName, String userId, String discoveryRequestGUID) {
        String methodName = "getDiscoveryAnalysisReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryAnalysisReport");
        DiscoveryAnalysisReportResponse response = new DiscoveryAnalysisReportResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryEngineHandler handler = instanceHandler.getDiscoveryEngineHandler(userId, serverName, discoveryEngineName, "getDiscoveryAnalysisReport");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryAnalysisReport");
            response.setAnalysisReport(handler.getDiscoveryReport(discoveryRequestGUID));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryAnalysisReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationListResponse getDiscoveryReportAnnotations(String serverName, String discoveryEngineName, String userId, String discoveryRequestGUID, int startingFrom, int maximumResults) {
        String methodName = "getDiscoveryReportAnnotations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDiscoveryReportAnnotations");
        AnnotationListResponse response = new AnnotationListResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryEngineHandler handler = instanceHandler.getDiscoveryEngineHandler(userId, serverName, discoveryEngineName, "getDiscoveryReportAnnotations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryReportAnnotations");
            response.setAnnotations(handler.getDiscoveryReportAnnotations(discoveryRequestGUID, startingFrom, maximumResults));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryReportAnnotations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationListResponse getExtendedAnnotations(String serverName, String discoveryEngineName, String userId, String discoveryRequestGUID, String annotationGUID, int startingFrom, int maximumResults) {
        String methodName = "getExtendedAnnotations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExtendedAnnotations");
        AnnotationListResponse response = new AnnotationListResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryEngineHandler handler = instanceHandler.getDiscoveryEngineHandler(userId, serverName, discoveryEngineName, "getExtendedAnnotations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExtendedAnnotations");
            response.setAnnotations(handler.getExtendedAnnotations(discoveryRequestGUID, annotationGUID, startingFrom, maximumResults));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getExtendedAnnotations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AnnotationResponse getAnnotation(String serverName, String discoveryEngineName, String userId, String discoveryRequestGUID, String annotationGUID) {
        String methodName = "getAnnotation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAnnotation");
        AnnotationResponse response = new AnnotationResponse();
        AuditLog auditLog = null;
        try {
            DiscoveryEngineHandler handler = instanceHandler.getDiscoveryEngineHandler(userId, serverName, discoveryEngineName, "getAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAnnotation");
            response.setAnnotation(handler.getAnnotation(discoveryRequestGUID, annotationGUID));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAnnotation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private void captureDiscoveryEngineException(FFDCResponseBase response, DiscoveryEngineException error) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(PropertyServerException.class.getName());
        response.setExceptionErrorMessage(error.getReportedErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }
}

