/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.discoveryengineservices.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.discoveryengine.api.DiscoveryEngineEventListener;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryConfigurationClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.ffdc.DiscoveryEngineServicesAuditCode;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.handlers.DiscoveryEngineHandler;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.listener.DiscoveryConfigurationRefreshListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryConfigurationRefreshHandler
implements Runnable {
    private Map<String, DiscoveryEngineHandler> discoveryEngineHandlers;
    private DiscoveryConfigurationClient configurationClient;
    private AuditLog auditLog;
    private String localServerUserId;
    private String localServerName;
    private String accessServiceServerName;
    private String accessServiceRootURL;
    private static final Logger log = LoggerFactory.getLogger(DiscoveryConfigurationRefreshHandler.class);

    public DiscoveryConfigurationRefreshHandler(Map<String, DiscoveryEngineHandler> discoveryEngineHandlers, DiscoveryConfigurationClient configurationClient, AuditLog auditLog, String localServerUserId, String localServerName, String accessServiceServerName, String accessServiceRootURL) {
        this.discoveryEngineHandlers = new HashMap<String, DiscoveryEngineHandler>(discoveryEngineHandlers);
        this.configurationClient = configurationClient;
        this.auditLog = auditLog;
        this.localServerUserId = localServerUserId;
        this.localServerName = localServerName;
        this.accessServiceServerName = accessServiceServerName;
        this.accessServiceRootURL = accessServiceRootURL;
    }

    @Override
    public void run() {
        String actionDescription = "Register configuration listener";
        boolean listenerRegistered = false;
        ArrayList<Object> configToRetrieve = this.discoveryEngineHandlers != null ? new ArrayList<DiscoveryEngineHandler>(this.discoveryEngineHandlers.values()) : new ArrayList();
        while (!listenerRegistered && configToRetrieve.size() != 0) {
            while (!listenerRegistered) {
                try {
                    this.configurationClient.registerListener(this.localServerUserId, (DiscoveryEngineEventListener)new DiscoveryConfigurationRefreshListener(this.discoveryEngineHandlers, this.auditLog));
                    listenerRegistered = true;
                    this.auditLog.logMessage("Register configuration listener", DiscoveryEngineServicesAuditCode.CONFIGURATION_LISTENER_REGISTERED.getMessageDefinition(new String[]{this.localServerName, this.accessServiceServerName}));
                }
                catch (UserNotAuthorizedException error) {
                    this.auditLog.logException("Register configuration listener", DiscoveryEngineServicesAuditCode.SERVER_NOT_AUTHORIZED.getMessageDefinition(new String[]{this.localServerName, this.accessServiceServerName, this.accessServiceRootURL, this.localServerUserId, error.getReportedErrorMessage()}), (Throwable)error);
                    this.waitToRetry();
                }
                catch (Throwable error) {
                    this.auditLog.logException("Register configuration listener", DiscoveryEngineServicesAuditCode.NO_CONFIGURATION_LISTENER.getMessageDefinition(new String[]{this.localServerName, this.accessServiceServerName, error.getClass().getName(), error.getMessage()}), error);
                    this.waitToRetry();
                }
            }
            while (configToRetrieve.size() != 0) {
                ArrayList<DiscoveryEngineHandler> configFailed = new ArrayList<DiscoveryEngineHandler>();
                for (DiscoveryEngineHandler discoveryEngineHandler : configToRetrieve) {
                    if (discoveryEngineHandler == null) continue;
                    try {
                        discoveryEngineHandler.refreshConfig();
                    }
                    catch (Throwable error) {
                        this.auditLog.logException("Register configuration listener", DiscoveryEngineServicesAuditCode.DISCOVERY_ENGINE_NO_CONFIG.getMessageDefinition(new String[]{discoveryEngineHandler.getDiscoveryEngineName(), error.getClass().getName(), error.getMessage()}), error.toString(), error);
                        configFailed.add(discoveryEngineHandler);
                    }
                }
                configToRetrieve = configFailed;
                this.waitToRetry();
            }
        }
    }

    private void waitToRetry() {
        int sleepTime = 2000000;
        try {
            Thread.sleep(2000000L);
        }
        catch (Exception error) {
            log.error("Ignored exception from sleep - probably ok", (Throwable)error);
        }
    }
}

