/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.discoveryengineservices.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryAnalysisReportClient;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryAnnotationStoreClient;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryAssetCatalogStoreClient;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryAssetStoreClient;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryConfigurationClient;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryEngineClient;
import org.odpi.openmetadata.adapters.connectors.discoveryservices.CSVDiscoveryServiceProvider;
import org.odpi.openmetadata.adapters.connectors.discoveryservices.DuplicateSuspectDiscoveryProvider;
import org.odpi.openmetadata.adapters.connectors.discoveryservices.SequentialDiscoveryPipelineProvider;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAnnotationStore;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAssetCatalogStore;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAssetStore;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryContext;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryService;
import org.odpi.openmetadata.frameworks.discovery.ffdc.DiscoveryEngineException;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryEngineProperties;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryServiceProperties;
import org.odpi.openmetadata.frameworks.discovery.properties.RegisteredDiscoveryService;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.ffdc.DiscoveryEngineServicesAuditCode;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.ffdc.DiscoveryEngineServicesErrorCode;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.handlers.DiscoveryServiceHandler;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.properties.DiscoveryEngineStatus;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.properties.DiscoveryEngineSummary;

public class DiscoveryEngineHandler {
    private String serverName;
    private String serverUserId;
    private AuditLog auditLog;
    private DiscoveryEngineClient discoveryEngineClient;
    private DiscoveryConfigurationClient configurationClient;
    private int maxPageSize;
    private String discoveryEngineName;
    private String discoveryEngineGUID = null;
    private DiscoveryEngineProperties discoveryEngineProperties = null;
    private DiscoveryServiceCacheMap discoveryServiceLookupTable = new DiscoveryServiceCacheMap();
    private CSVDiscoveryServiceProvider csvDiscoveryServiceProvider;
    private DuplicateSuspectDiscoveryProvider duplicateSuspectDiscoveryProvider;
    private SequentialDiscoveryPipelineProvider sequentialDiscoveryPipelineProvider;

    public DiscoveryEngineHandler(String discoveryEngineName, String serverName, String serverUserId, DiscoveryConfigurationClient configurationClient, DiscoveryEngineClient discoveryEngineClient, AuditLog auditLog, int maxPageSize) {
        this.discoveryEngineName = discoveryEngineName;
        this.serverName = serverName;
        this.serverUserId = serverUserId;
        this.configurationClient = configurationClient;
        this.discoveryEngineClient = discoveryEngineClient;
        this.auditLog = auditLog;
        this.maxPageSize = maxPageSize;
    }

    String getDiscoveryEngineName() {
        return this.discoveryEngineName;
    }

    public DiscoveryEngineSummary getSummary() {
        DiscoveryEngineSummary mySummary = new DiscoveryEngineSummary();
        mySummary.setDiscoveryEngineName(this.discoveryEngineName);
        mySummary.setDiscoveryEngineGUID(this.discoveryEngineGUID);
        if (this.discoveryEngineProperties != null) {
            mySummary.setDiscoveryEngineDescription(this.discoveryEngineProperties.getDescription());
        }
        mySummary.setDiscoveryRequestTypes(this.discoveryServiceLookupTable.getDiscoveryRequestTypes());
        mySummary.setDiscoveryEngineStatus(DiscoveryEngineStatus.ASSIGNED);
        if (this.discoveryEngineGUID != null) {
            mySummary.setDiscoveryEngineStatus(DiscoveryEngineStatus.CONFIGURING);
        }
        if (this.discoveryServiceLookupTable.getDiscoveryRequestTypes() != null) {
            mySummary.setDiscoveryEngineStatus(DiscoveryEngineStatus.RUNNING);
        }
        return mySummary;
    }

    public void refreshConfig() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshConfig";
        this.discoveryEngineProperties = this.configurationClient.getDiscoveryEngineByName(this.serverUserId, this.discoveryEngineName);
        if (this.discoveryEngineProperties == null) {
            throw new PropertyServerException(DiscoveryEngineServicesErrorCode.UNKNOWN_DISCOVERY_ENGINE_CONFIG.getMessageDefinition(new String[]{this.discoveryEngineName, this.configurationClient.getConfigurationServerName(), this.serverName}), this.getClass().getName(), "refreshConfig");
        }
        this.discoveryEngineGUID = this.discoveryEngineProperties.getGUID();
        this.refreshAllServiceConfig();
    }

    private void refreshAllServiceConfig() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String actionDescription = "Retrieve all discovery service configuration";
        this.auditLog.logMessage("Retrieve all discovery service configuration", DiscoveryEngineServicesAuditCode.CLEARING_ALL_DISCOVERY_SERVICE_CONFIG.getMessageDefinition(new String[]{this.discoveryEngineName}));
        this.discoveryServiceLookupTable.clear();
        int startingFrom = 0;
        boolean moreToReceive = true;
        while (moreToReceive) {
            List registeredDiscoveryServices = this.configurationClient.getRegisteredDiscoveryServices(this.serverUserId, this.discoveryEngineGUID, startingFrom, this.maxPageSize);
            if (registeredDiscoveryServices != null && !registeredDiscoveryServices.isEmpty()) {
                for (String registeredDiscoveryServiceGUID : registeredDiscoveryServices) {
                    this.refreshServiceConfig(registeredDiscoveryServiceGUID);
                }
                if (registeredDiscoveryServices.size() < this.maxPageSize) {
                    moreToReceive = false;
                    continue;
                }
                startingFrom += this.maxPageSize;
                continue;
            }
            moreToReceive = false;
        }
        this.auditLog.logMessage("Retrieve all discovery service configuration", DiscoveryEngineServicesAuditCode.FINISHED_ALL_DISCOVERY_SERVICE_CONFIG.getMessageDefinition(new String[]{this.discoveryEngineName}));
    }

    public void refreshServiceConfig(String registeredDiscoveryServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        RegisteredDiscoveryService discoveryService;
        if (registeredDiscoveryServiceGUID != null && (discoveryService = this.configurationClient.getRegisteredDiscoveryService(this.serverUserId, this.discoveryEngineGUID, registeredDiscoveryServiceGUID)) != null && discoveryService.getDiscoveryRequestTypes() != null) {
            for (String discoveryRequestType : discoveryService.getDiscoveryRequestTypes()) {
                DiscoveryServiceCache discoveryServiceCache = new DiscoveryServiceCache(this.serverName, this.discoveryEngineName, discoveryService);
                this.discoveryServiceLookupTable.put(discoveryRequestType, discoveryServiceCache);
            }
        }
    }

    public String discoverAsset(String assetGUID, String discoveryRequestType, Map<String, String> analysisParameters, List<String> annotationTypes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, DiscoveryEngineException {
        String methodName = "discoverAsset";
        this.validateDiscoveryEngineInitialized("discoverAsset");
        DiscoveryServiceCache discoveryServiceCache = this.discoveryServiceLookupTable.get(discoveryRequestType);
        if (discoveryServiceCache != null) {
            return this.runDiscoveryService(assetGUID, discoveryRequestType, analysisParameters, annotationTypes, discoveryServiceCache);
        }
        return null;
    }

    public void scanAllAssets(String discoveryRequestType, Map<String, String> analysisParameters, List<String> annotationTypes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, DiscoveryEngineException {
        String methodName = "scanAllAssets";
        this.validateDiscoveryEngineInitialized("scanAllAssets");
        DiscoveryServiceCache discoveryServiceCache = this.discoveryServiceLookupTable.get(discoveryRequestType);
        if (discoveryServiceCache != null) {
            int startingFrom = 0;
            boolean moreToReceive = true;
            while (moreToReceive) {
                List assets = this.discoveryEngineClient.getAssets(this.serverUserId, startingFrom, this.maxPageSize);
                if (assets != null && !assets.isEmpty()) {
                    for (String assetGUID : assets) {
                        if (assetGUID == null) continue;
                        this.runDiscoveryService(assetGUID, discoveryRequestType, analysisParameters, annotationTypes, discoveryServiceCache);
                    }
                    if (assets.size() < this.maxPageSize) {
                        moreToReceive = false;
                        continue;
                    }
                    startingFrom += this.maxPageSize;
                    continue;
                }
                moreToReceive = false;
            }
        }
    }

    private String runDiscoveryService(String assetGUID, String discoveryRequestType, Map<String, String> suppliedAnalysisParameters, List<String> annotationTypes, DiscoveryServiceCache discoveryServiceCache) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Date creationTime = new Date();
        Map<String, String> analysisParameters = suppliedAnalysisParameters;
        if (analysisParameters == null) {
            analysisParameters = discoveryServiceCache.getDefaultAnalysisParameters();
        }
        String reportQualifiedName = "DiscoveryAnalysisReport:" + discoveryRequestType + ":" + assetGUID + ":" + creationTime.toString();
        String reportDisplayName = "Discovery Analysis Report for " + assetGUID;
        String reportDescription = "This is the " + discoveryRequestType + " discovery analysis report for asset " + assetGUID + " generated at " + creationTime.toString() + " by the " + discoveryServiceCache.getDiscoveryServiceName() + " discovery service running on discovery engine " + this.discoveryEngineProperties.getDisplayName() + " (" + this.discoveryEngineName + ").";
        DiscoveryAnalysisReportClient discoveryAnalysisReportClient = new DiscoveryAnalysisReportClient(this.serverUserId, DiscoveryRequestStatus.WAITING, assetGUID, analysisParameters, reportQualifiedName, reportDisplayName, reportDescription, this.discoveryEngineGUID, discoveryServiceCache.getDiscoveryServiceGUID(), this.discoveryEngineClient);
        discoveryAnalysisReportClient.setDiscoveryRequestStatus(DiscoveryRequestStatus.ACTIVATING);
        DiscoveryAnnotationStoreClient annotationStore = new DiscoveryAnnotationStoreClient(this.serverUserId, assetGUID, discoveryAnalysisReportClient, this.discoveryEngineClient);
        DiscoveryAssetStoreClient assetStore = new DiscoveryAssetStoreClient(assetGUID, this.serverUserId, this.discoveryEngineClient);
        DiscoveryAssetCatalogStoreClient assetCatalogStore = new DiscoveryAssetCatalogStoreClient(this.serverUserId, this.discoveryEngineClient, this.maxPageSize);
        DiscoveryContext discoveryContext = new DiscoveryContext(this.serverUserId, assetGUID, analysisParameters, annotationTypes, (DiscoveryAssetStore)assetStore, (DiscoveryAnnotationStore)annotationStore, (DiscoveryAssetCatalogStore)assetCatalogStore);
        DiscoveryServiceHandler discoveryServiceHandler = new DiscoveryServiceHandler(this.discoveryEngineProperties, discoveryRequestType, discoveryServiceCache.getDiscoveryServiceName(), discoveryServiceCache.getNextDiscoveryService(), discoveryContext, this.auditLog);
        Thread thread = new Thread((Runnable)discoveryServiceHandler, discoveryServiceCache.getDiscoveryServiceName() + assetGUID + new Date().toString());
        thread.start();
        return discoveryAnalysisReportClient.getDiscoveryReportGUID();
    }

    public DiscoveryAnalysisReport getDiscoveryReport(String discoveryRequestGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getDiscoveryAnalysisReport(this.serverUserId, discoveryRequestGUID);
    }

    public List<Annotation> getDiscoveryReportAnnotations(String discoveryRequestGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getDiscoveryReportAnnotations(this.serverUserId, discoveryRequestGUID, startingFrom, maximumResults);
    }

    public List<Annotation> getExtendedAnnotations(String discoveryRequestGUID, String annotationGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getExtendedAnnotations(this.serverUserId, discoveryRequestGUID, annotationGUID, startingFrom, maximumResults);
    }

    public Annotation getAnnotation(String discoveryRequestGUID, String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getAnnotation(this.serverUserId, discoveryRequestGUID, annotationGUID);
    }

    public void terminate() {
        String actionDescription = "terminate";
        this.auditLog.logMessage("terminate", DiscoveryEngineServicesAuditCode.ENGINE_SHUTDOWN.getMessageDefinition(new String[]{this.discoveryEngineName, this.serverName}));
        this.discoveryEngineProperties = null;
        this.discoveryServiceLookupTable.clear();
    }

    private void validateDiscoveryEngineInitialized(String methodName) throws DiscoveryEngineException {
        if (this.discoveryEngineProperties == null) {
            throw new DiscoveryEngineException(DiscoveryEngineServicesErrorCode.DISCOVERY_ENGINE_NOT_INITIALIZED.getMessageDefinition(new String[]{this.serverName, this.discoveryEngineName}), this.getClass().getName(), methodName);
        }
    }

    private static class DiscoveryServiceCache {
        private DiscoveryService nextDiscoveryService;
        private DiscoveryServiceProperties properties;
        private Map<String, String> defaultAnalysisParameters;

        DiscoveryServiceCache(String discoveryServerName, String discoveryEngineName, RegisteredDiscoveryService properties) throws InvalidParameterException, PropertyServerException {
            String methodName = "DiscoveryServiceCache constructor";
            if (properties == null) {
                throw new PropertyServerException(DiscoveryEngineServicesErrorCode.NULL_DISCOVERY_SERVICE.getMessageDefinition(new String[]{"DiscoveryServiceCache constructor", discoveryEngineName, discoveryServerName}), this.getClass().getName(), "DiscoveryServiceCache constructor");
            }
            this.properties = properties;
            this.defaultAnalysisParameters = properties.getDefaultAnalysisParameters();
            this.getNextDiscoveryService();
        }

        String getDiscoveryServiceName() {
            return this.properties.getQualifiedName();
        }

        String getDiscoveryServiceGUID() {
            return this.properties.getGUID();
        }

        Map<String, String> getDefaultAnalysisParameters() {
            return this.defaultAnalysisParameters;
        }

        synchronized DiscoveryService getNextDiscoveryService() throws InvalidParameterException, PropertyServerException {
            DiscoveryService returnValue = this.nextDiscoveryService;
            try {
                ConnectorBroker connectorBroker = new ConnectorBroker();
                this.nextDiscoveryService = (DiscoveryService)connectorBroker.getConnector(this.properties.getConnection());
            }
            catch (ConnectionCheckedException error) {
                throw new InvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error, this.properties.getQualifiedName() + "DiscoveryService Connection");
            }
            catch (ConnectorCheckedException error) {
                throw new PropertyServerException((OCFCheckedExceptionBase)error);
            }
            return returnValue;
        }
    }

    private static class DiscoveryServiceCacheMap {
        private volatile Map<String, DiscoveryServiceCache> discoveryServiceLookupTable = new HashMap<String, DiscoveryServiceCache>();

        private DiscoveryServiceCacheMap() {
        }

        synchronized void clear() {
            this.discoveryServiceLookupTable = new HashMap<String, DiscoveryServiceCache>();
        }

        synchronized void put(String discoveryRequestType, DiscoveryServiceCache discoveryServiceCache) {
            this.discoveryServiceLookupTable.put(discoveryRequestType, discoveryServiceCache);
        }

        synchronized DiscoveryServiceCache get(String discoveryRequestType) {
            return this.discoveryServiceLookupTable.get(discoveryRequestType);
        }

        synchronized List<String> getDiscoveryRequestTypes() {
            if (this.discoveryServiceLookupTable.isEmpty()) {
                return null;
            }
            return new ArrayList<String>(this.discoveryServiceLookupTable.keySet());
        }
    }
}

