/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.discoveryengineservices.handlers;

import java.util.Date;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAnalysisReportStore;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryContext;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryService;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryEngineProperties;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.ffdc.DiscoveryEngineServicesAuditCode;

public class DiscoveryServiceHandler
implements Runnable {
    private DiscoveryEngineProperties discoveryEngineProperties;
    private String assetDiscoveryType;
    private String discoveryServiceName;
    private DiscoveryService discoveryService;
    private DiscoveryContext discoveryContext;
    private AuditLog auditLog;

    DiscoveryServiceHandler(DiscoveryEngineProperties discoveryEngineProperties, String assetDiscoveryType, String discoveryServiceName, DiscoveryService discoveryService, DiscoveryContext discoveryContext, AuditLog auditLog) {
        this.discoveryEngineProperties = discoveryEngineProperties;
        this.assetDiscoveryType = assetDiscoveryType;
        this.discoveryServiceName = discoveryServiceName;
        this.discoveryService = discoveryService;
        this.discoveryContext = discoveryContext;
        this.auditLog = auditLog;
    }

    @Override
    public void run() {
        String actionDescription = "Analyse an Asset";
        String discoveryReportGUID = null;
        try {
            DiscoveryAnalysisReportStore discoveryReport = this.discoveryContext.getAnnotationStore().getDiscoveryReport();
            discoveryReportGUID = discoveryReport.getDiscoveryReportGUID();
            this.auditLog.logMessage("Analyse an Asset", DiscoveryEngineServicesAuditCode.DISCOVERY_SERVICE_STARTING.getMessageDefinition(new String[]{this.discoveryServiceName, this.discoveryContext.getAssetGUID(), this.assetDiscoveryType, this.discoveryEngineProperties.getQualifiedName(), this.discoveryEngineProperties.getGUID(), discoveryReport.getDiscoveryReportGUID()}));
            discoveryReport.setDiscoveryRequestStatus(DiscoveryRequestStatus.IN_PROGRESS);
            this.discoveryService.setDiscoveryContext(this.discoveryContext);
            this.discoveryService.setDiscoveryServiceName(this.discoveryServiceName);
            Date startTime = new Date();
            this.discoveryService.start();
            Date endTime = new Date();
            this.auditLog.logMessage("Analyse an Asset", DiscoveryEngineServicesAuditCode.DISCOVERY_SERVICE_COMPLETE.getMessageDefinition(new String[]{this.discoveryServiceName, this.discoveryContext.getAssetGUID(), this.assetDiscoveryType, Long.toString(endTime.getTime() - startTime.getTime()), discoveryReport.getDiscoveryReportGUID()}));
            discoveryReport.setDiscoveryRequestStatus(DiscoveryRequestStatus.COMPLETED);
            this.discoveryService.disconnect();
        }
        catch (Throwable error) {
            this.auditLog.logException("Analyse an Asset", DiscoveryEngineServicesAuditCode.DISCOVERY_SERVICE_FAILED.getMessageDefinition(new String[]{this.discoveryServiceName, error.getClass().getName(), discoveryReportGUID, this.discoveryContext.getAssetGUID(), this.assetDiscoveryType, this.discoveryEngineProperties.getQualifiedName(), this.discoveryEngineProperties.getGUID(), error.getMessage()}), error.toString(), error);
            try {
                DiscoveryAnalysisReportStore discoveryReport = this.discoveryContext.getAnnotationStore().getDiscoveryReport();
                discoveryReport.setDiscoveryRequestStatus(DiscoveryRequestStatus.FAILED);
            }
            catch (Throwable statusError) {
                this.auditLog.logException("Analyse an Asset", DiscoveryEngineServicesAuditCode.EXC_ON_ERROR_STATUS_UPDATE.getMessageDefinition(new String[]{this.discoveryEngineProperties.getDisplayName(), this.discoveryServiceName, statusError.getClass().getName(), statusError.getMessage()}), statusError.toString(), statusError);
            }
        }
    }
}

