/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.discoveryengineservices.listener;

import java.util.Map;
import org.odpi.openmetadata.accessservices.discoveryengine.api.DiscoveryEngineEventListener;
import org.odpi.openmetadata.accessservices.discoveryengine.events.DiscoveryEngineConfigurationEvent;
import org.odpi.openmetadata.accessservices.discoveryengine.events.DiscoveryEngineEvent;
import org.odpi.openmetadata.accessservices.discoveryengine.events.DiscoveryServiceConfigurationEvent;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.ffdc.DiscoveryEngineServicesAuditCode;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.handlers.DiscoveryEngineHandler;

public class DiscoveryConfigurationRefreshListener
extends DiscoveryEngineEventListener {
    private Map<String, DiscoveryEngineHandler> discoveryEngineHandlers;
    private AuditLog auditLog;

    public DiscoveryConfigurationRefreshListener(Map<String, DiscoveryEngineHandler> discoveryEngineHandlers, AuditLog auditLog) {
        this.discoveryEngineHandlers = discoveryEngineHandlers;
        this.auditLog = auditLog;
    }

    public void processEvent(DiscoveryEngineEvent event) {
        String actionDescription = "Process configuration event";
        if (event != null) {
            DiscoveryEngineConfigurationEvent discoveryEngineEvent;
            DiscoveryEngineHandler discoveryEngineHandler;
            if (event instanceof DiscoveryServiceConfigurationEvent) {
                DiscoveryServiceConfigurationEvent discoveryServiceEvent = (DiscoveryServiceConfigurationEvent)event;
                DiscoveryEngineHandler discoveryEngineHandler2 = this.discoveryEngineHandlers.get(discoveryServiceEvent.getDiscoveryEngineName());
                if (discoveryEngineHandler2 != null) {
                    try {
                        discoveryEngineHandler2.refreshServiceConfig(discoveryServiceEvent.getRegisteredDiscoveryServiceGUID());
                    }
                    catch (Exception error) {
                        this.auditLog.logException("Process configuration event", DiscoveryEngineServicesAuditCode.DISCOVERY_SERVICE_NO_CONFIG.getMessageDefinition(new String[]{discoveryServiceEvent.getRegisteredDiscoveryServiceGUID(), discoveryServiceEvent.getDiscoveryRequestTypes().toString(), error.getClass().getName(), error.getMessage()}), discoveryServiceEvent.toString(), (Throwable)error);
                    }
                }
            } else if (event instanceof DiscoveryEngineConfigurationEvent && (discoveryEngineHandler = this.discoveryEngineHandlers.get((discoveryEngineEvent = (DiscoveryEngineConfigurationEvent)event).getDiscoveryEngineName())) != null) {
                try {
                    discoveryEngineHandler.refreshConfig();
                }
                catch (Exception error) {
                    this.auditLog.logException("Process configuration event", DiscoveryEngineServicesAuditCode.DISCOVERY_ENGINE_NO_CONFIG.getMessageDefinition(new String[]{discoveryEngineEvent.getDiscoveryEngineName(), error.getClass().getName(), error.getMessage()}), discoveryEngineEvent.toString(), (Throwable)error);
                }
            }
        }
    }
}

