/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.discoveryengineservices.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.multitenant.GovernanceServerServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.ffdc.DiscoveryEngineServicesErrorCode;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.handlers.DiscoveryEngineHandler;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.properties.DiscoveryEngineSummary;

public class DiscoveryServerInstance
extends GovernanceServerServiceInstance {
    private Map<String, DiscoveryEngineHandler> discoveryEngineInstances;

    DiscoveryServerInstance(String serverName, String serviceName, AuditLog auditLog, String localServerUserId, int maxPageSize, String accessServiceRootURL, String accessServiceServerName, Map<String, DiscoveryEngineHandler> discoveryEngineInstances) {
        super(serverName, serviceName, auditLog, localServerUserId, maxPageSize, accessServiceRootURL, accessServiceServerName);
        this.discoveryEngineInstances = discoveryEngineInstances;
    }

    synchronized List<DiscoveryEngineSummary> getDiscoveryEngineStatuses() {
        ArrayList<DiscoveryEngineSummary> results = new ArrayList<DiscoveryEngineSummary>();
        if (this.discoveryEngineInstances != null) {
            for (DiscoveryEngineHandler discoveryEngineHandler : this.discoveryEngineInstances.values()) {
                if (discoveryEngineHandler == null) continue;
                results.add(discoveryEngineHandler.getSummary());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    synchronized DiscoveryEngineHandler getDiscoveryEngine(String discoveryEngineName) throws InvalidParameterException {
        String methodName = "getDiscoveryEngine";
        String guidParameterName = "discoveryEngineName";
        DiscoveryEngineHandler instance = this.discoveryEngineInstances.get(discoveryEngineName);
        if (instance == null) {
            throw new InvalidParameterException(DiscoveryEngineServicesErrorCode.UNKNOWN_DISCOVERY_ENGINE.getMessageDefinition(new String[]{this.serverName, discoveryEngineName}), ((Object)((Object)this)).getClass().getName(), "getDiscoveryEngine", "discoveryEngineName");
        }
        return instance;
    }

    public void shutdown() {
        if (this.discoveryEngineInstances != null) {
            for (DiscoveryEngineHandler handler : this.discoveryEngineInstances.values()) {
                if (handler == null) continue;
                handler.terminate();
            }
        }
        super.shutdown();
    }
}

