/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.discoveryengineservices.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryConfigurationClient;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryEngineClient;
import org.odpi.openmetadata.accessservices.discoveryengine.client.ODFRESTClient;
import org.odpi.openmetadata.adminservices.configuration.properties.DiscoveryEngineServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.ffdc.DiscoveryEngineServicesAuditCode;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.ffdc.DiscoveryEngineServicesErrorCode;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.handlers.DiscoveryConfigurationRefreshHandler;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.handlers.DiscoveryEngineHandler;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.server.DiscoveryServerInstance;

public class DiscoveryServerOperationalServices {
    private String localServerName;
    private String localServerUserId;
    private String localServerPassword;
    private int maxPageSize;
    private DiscoveryServerInstance discoveryServerInstance = null;
    private AuditLog auditLog = null;

    public DiscoveryServerOperationalServices(String localServerName, String localServerUserId, String localServerPassword, int maxPageSize) {
        this.localServerName = localServerName;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
        this.maxPageSize = maxPageSize;
    }

    public void initialize(DiscoveryEngineServicesConfig discoveryEngineServicesConfig, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        String methodName = "initialize";
        this.auditLog = auditLog;
        auditLog.logMessage("initialize", DiscoveryEngineServicesAuditCode.SERVER_INITIALIZING.getMessageDefinition(new String[]{this.localServerName}));
        try {
            DiscoveryConfigurationClient configurationClient;
            ODFRESTClient restClient;
            if (discoveryEngineServicesConfig == null) {
                throw new OMAGConfigurationErrorException(DiscoveryEngineServicesErrorCode.NO_CONFIG_DOC.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "initialize");
            }
            String accessServiceRootURL = this.getAccessServiceRootURL(discoveryEngineServicesConfig);
            String accessServiceServerName = this.getAccessServiceServerName(discoveryEngineServicesConfig);
            List<String> discoveryEngineNames = this.getDiscoveryEngineNames(discoveryEngineServicesConfig);
            try {
                restClient = this.localServerName != null && this.localServerPassword != null ? new ODFRESTClient(accessServiceServerName, accessServiceRootURL, this.localServerUserId, this.localServerPassword) : new ODFRESTClient(accessServiceServerName, accessServiceRootURL);
                configurationClient = new DiscoveryConfigurationClient(accessServiceServerName, accessServiceRootURL, restClient, this.maxPageSize, auditLog);
            }
            catch (InvalidParameterException error) {
                throw new OMAGConfigurationErrorException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
            }
            Map<String, DiscoveryEngineHandler> discoveryEngineHandlers = this.getDiscoveryEngineHandlers(discoveryEngineNames, accessServiceRootURL, accessServiceServerName, configurationClient, restClient);
            if (discoveryEngineHandlers == null) {
                auditLog.logMessage("initialize", DiscoveryEngineServicesAuditCode.NO_DISCOVERY_ENGINES_STARTED.getMessageDefinition(new String[]{this.localServerName}));
                throw new OMAGConfigurationErrorException(DiscoveryEngineServicesErrorCode.NO_DISCOVERY_ENGINES_STARTED.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "initialize");
            }
            DiscoveryConfigurationRefreshHandler configurationHandler = new DiscoveryConfigurationRefreshHandler(discoveryEngineHandlers, configurationClient, auditLog, this.localServerUserId, this.localServerName, accessServiceServerName, accessServiceRootURL);
            Thread thread = new Thread((Runnable)configurationHandler, configurationHandler.getClass().getName());
            thread.start();
            this.discoveryServerInstance = new DiscoveryServerInstance(this.localServerName, GovernanceServicesDescription.DISCOVERY_ENGINE_SERVICES.getServiceName(), auditLog, this.localServerUserId, this.maxPageSize, discoveryEngineServicesConfig.getOMAGServerPlatformRootURL(), discoveryEngineServicesConfig.getOMAGServerName(), discoveryEngineHandlers);
        }
        catch (Throwable error) {
            auditLog.logException("initialize", DiscoveryEngineServicesAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{this.localServerName, error.getMessage()}), error.toString(), error);
            throw new OMAGConfigurationErrorException(DiscoveryEngineServicesErrorCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{this.localServerName, error.getMessage()}), this.getClass().getName(), "initialize", error);
        }
    }

    private String getAccessServiceRootURL(DiscoveryEngineServicesConfig discoveryEngineServicesConfig) throws OMAGConfigurationErrorException {
        String accessServiceRootURL = discoveryEngineServicesConfig.getOMAGServerPlatformRootURL();
        if (accessServiceRootURL == null) {
            String actionDescription = "Validate discovery engine services configuration.";
            String methodName = "getAccessServiceRootURL";
            this.auditLog.logMessage("Validate discovery engine services configuration.", DiscoveryEngineServicesAuditCode.NO_OMAS_SERVER_URL.getMessageDefinition(new String[]{this.localServerName}));
            throw new OMAGConfigurationErrorException(DiscoveryEngineServicesErrorCode.NO_OMAS_SERVER_URL.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "getAccessServiceRootURL");
        }
        return accessServiceRootURL;
    }

    private String getAccessServiceServerName(DiscoveryEngineServicesConfig discoveryEngineServicesConfig) throws OMAGConfigurationErrorException {
        String accessServiceServerName = discoveryEngineServicesConfig.getOMAGServerName();
        if (accessServiceServerName == null) {
            String actionDescription = "Validate discovery engine services configuration.";
            String methodName = "getAccessServiceServerName";
            this.auditLog.logMessage("Validate discovery engine services configuration.", DiscoveryEngineServicesAuditCode.NO_OMAS_SERVER_NAME.getMessageDefinition(new String[]{this.localServerName}));
            throw new OMAGConfigurationErrorException(DiscoveryEngineServicesErrorCode.NO_OMAS_SERVER_NAME.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "getAccessServiceServerName");
        }
        return accessServiceServerName;
    }

    private List<String> getDiscoveryEngineNames(DiscoveryEngineServicesConfig discoveryEngineServicesConfig) throws OMAGConfigurationErrorException {
        List discoveryEngineNames = discoveryEngineServicesConfig.getDiscoveryEngineNames();
        if (discoveryEngineNames.isEmpty()) {
            String actionDescription = "Validate discovery engine services configuration.";
            String methodName = "getDiscoveryEngineNames";
            this.auditLog.logMessage("Validate discovery engine services configuration.", DiscoveryEngineServicesAuditCode.NO_DISCOVERY_ENGINES.getMessageDefinition());
            throw new OMAGConfigurationErrorException(DiscoveryEngineServicesErrorCode.NO_DISCOVERY_ENGINES.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "getDiscoveryEngineNames");
        }
        return discoveryEngineNames;
    }

    private Map<String, DiscoveryEngineHandler> getDiscoveryEngineHandlers(List<String> discoveryEngineNames, String accessServiceRootURL, String accessServiceServerName, DiscoveryConfigurationClient configurationClient, ODFRESTClient odfRESTClient) throws OMAGConfigurationErrorException {
        String methodName = "getDiscoveryEngineHandlers";
        HashMap<String, DiscoveryEngineHandler> discoveryEngineHandlers = new HashMap<String, DiscoveryEngineHandler>();
        for (String discoveryEngineName : discoveryEngineNames) {
            DiscoveryEngineClient discoveryEngineClient;
            if (discoveryEngineName == null) continue;
            try {
                discoveryEngineClient = new DiscoveryEngineClient(accessServiceServerName, accessServiceRootURL, odfRESTClient, this.auditLog);
            }
            catch (Throwable error) {
                throw new OMAGConfigurationErrorException(DiscoveryEngineServicesErrorCode.NO_DISCOVERY_ENGINE_CLIENT.getMessageDefinition(new String[]{this.localServerName, discoveryEngineName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), "getDiscoveryEngineHandlers");
            }
            DiscoveryEngineHandler handler = new DiscoveryEngineHandler(discoveryEngineName, accessServiceServerName, this.localServerUserId, configurationClient, discoveryEngineClient, this.auditLog, this.maxPageSize);
            discoveryEngineHandlers.put(discoveryEngineName, handler);
        }
        if (discoveryEngineHandlers.isEmpty()) {
            return null;
        }
        return discoveryEngineHandlers;
    }

    public void terminate() {
        String actionDescription = "terminate";
        this.auditLog.logMessage("terminate", DiscoveryEngineServicesAuditCode.SERVER_SHUTTING_DOWN.getMessageDefinition(new String[]{this.localServerName}));
        this.discoveryServerInstance.shutdown();
        this.auditLog.logMessage("terminate", DiscoveryEngineServicesAuditCode.SERVER_SHUTDOWN.getMessageDefinition(new String[]{this.localServerName}));
    }
}

