/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.discoveryserver.server.spring;

import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryRequestRequestBody;
import org.odpi.openmetadata.discoveryserver.server.DiscoveryServerRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/discovery-server/users/{userId}/discovery-engine/{discoveryEngineGUID}"})
public class DiscoveryServerResource {
    private DiscoveryServerRESTServices restAPI = new DiscoveryServerRESTServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/asset-types/{assetType}/assets/{assetGUID}"})
    public GUIDResponse discoverAsset(@PathVariable String serverName, @PathVariable String discoveryEngineGUID, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String assetType, @RequestBody DiscoveryRequestRequestBody requestBody) {
        return this.restAPI.discoverAsset(serverName, discoveryEngineGUID, userId, assetGUID, assetType, requestBody);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/discovery-analysis-reports/{discoveryRequestGUID}"})
    public DiscoveryAnalysisReportResponse getDiscoveryReport(@PathVariable String serverName, @PathVariable String discoveryEngineGUID, @PathVariable String userId, @PathVariable String discoveryRequestGUID) {
        return this.restAPI.getDiscoveryReport(serverName, discoveryEngineGUID, userId, discoveryRequestGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/discovery-analysis-reports/{discoveryRequestGUID}/annotations"})
    public AnnotationListResponse getDiscoveryReportAnnotations(@PathVariable String serverName, @PathVariable String discoveryEngineGUID, @PathVariable String userId, @PathVariable String discoveryRequestGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getDiscoveryReportAnnotations(serverName, discoveryEngineGUID, userId, discoveryRequestGUID, startingFrom, maximumResults);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/discovery-analysis-reports/{discoveryRequestGUID}/annotations/{annotationGUID}/extended-annotations"})
    public AnnotationListResponse getExtendedAnnotations(@PathVariable String serverName, @PathVariable String discoveryEngineGUID, @PathVariable String userId, @PathVariable String discoveryRequestGUID, @PathVariable String annotationGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getExtendedAnnotations(serverName, discoveryEngineGUID, userId, discoveryRequestGUID, annotationGUID, startingFrom, maximumResults);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"discovery-analysis-reports/{discoveryRequestGUID}//annotations/{annotationGUID}"})
    public AnnotationResponse getAnnotation(@PathVariable String serverName, @PathVariable String discoveryEngineGUID, @PathVariable String userId, @PathVariable String discoveryRequestGUID, @PathVariable String annotationGUID) {
        return this.restAPI.getAnnotation(serverName, discoveryEngineGUID, userId, discoveryRequestGUID, annotationGUID);
    }
}

