/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.discoveryserver.server.spring;

import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryRequestRequestBody;
import org.odpi.openmetadata.discoveryserver.server.DiscoveryServerRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/discovery-server/users/{userId}/discovery-engine/{discoveryEngineGUID}"})
public class DiscoveryServerResource {
    private DiscoveryServerRESTServices restAPI = new DiscoveryServerRESTServices();

    @PostMapping(path={"/asset-discovery-types/{assetDiscoveryType}/assets/{assetGUID}"})
    public GUIDResponse discoverAsset(@PathVariable String serverName, @PathVariable String discoveryEngineGUID, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String assetDiscoveryType, @RequestBody DiscoveryRequestRequestBody requestBody) {
        return this.restAPI.discoverAsset(serverName, discoveryEngineGUID, userId, assetGUID, assetDiscoveryType, requestBody);
    }

    @PostMapping(path={"/asset-discovery-types/{assetDiscoveryType}/assets"})
    public VoidResponse scanAllAssets(@PathVariable String serverName, @PathVariable String discoveryEngineGUID, @PathVariable String userId, @PathVariable String assetDiscoveryType, @RequestBody DiscoveryRequestRequestBody requestBody) {
        return this.restAPI.scanAllAssets(serverName, discoveryEngineGUID, userId, assetDiscoveryType, requestBody);
    }

    @GetMapping(path={"/discovery-analysis-reports/{discoveryRequestGUID}"})
    public DiscoveryAnalysisReportResponse getDiscoveryReport(@PathVariable String serverName, @PathVariable String discoveryEngineGUID, @PathVariable String userId, @PathVariable String discoveryRequestGUID) {
        return this.restAPI.getDiscoveryReport(serverName, discoveryEngineGUID, userId, discoveryRequestGUID);
    }

    @GetMapping(path={"/discovery-analysis-reports/{discoveryRequestGUID}/annotations"})
    public AnnotationListResponse getDiscoveryReportAnnotations(@PathVariable String serverName, @PathVariable String discoveryEngineGUID, @PathVariable String userId, @PathVariable String discoveryRequestGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getDiscoveryReportAnnotations(serverName, discoveryEngineGUID, userId, discoveryRequestGUID, startingFrom, maximumResults);
    }

    @GetMapping(path={"/discovery-analysis-reports/{discoveryRequestGUID}/annotations/{annotationGUID}/extended-annotations"})
    public AnnotationListResponse getExtendedAnnotations(@PathVariable String serverName, @PathVariable String discoveryEngineGUID, @PathVariable String userId, @PathVariable String discoveryRequestGUID, @PathVariable String annotationGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getExtendedAnnotations(serverName, discoveryEngineGUID, userId, discoveryRequestGUID, annotationGUID, startingFrom, maximumResults);
    }

    @GetMapping(path={"discovery-analysis-reports/{discoveryRequestGUID}//annotations/{annotationGUID}"})
    public AnnotationResponse getAnnotation(@PathVariable String serverName, @PathVariable String discoveryEngineGUID, @PathVariable String userId, @PathVariable String discoveryRequestGUID, @PathVariable String annotationGUID) {
        return this.restAPI.getAnnotation(serverName, discoveryEngineGUID, userId, discoveryRequestGUID, annotationGUID);
    }
}

