/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.discoveryengineservices.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.rest.DiscoveryEngineStatusResponse;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.server.DiscoveryServerRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/discovery-server/users/{userId}"})
@Tag(name="Discovery Engine Services", description="The discovery engine services provide the core subsystem for a discovery server. A discovery server is an OMAG Server that hosts automated metadata discovery.", externalDocs=@ExternalDocumentation(description="Discovery Engine Services", url="https://egeria.odpi.org/open-metadata-implementation/governance-servers/discovery-engine-services/"))
public class DiscoveryServerResource {
    private DiscoveryServerRESTServices restAPI = new DiscoveryServerRESTServices();

    @GetMapping(path={"/discovery-engines/status"})
    public DiscoveryEngineStatusResponse getDiscoveryEngineStatuses(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getDiscoveryEngineStatuses(serverName, userId);
    }

    @GetMapping(path={"/discovery-engines/{discoveryEngineName}/refresh-config"})
    public VoidResponse refreshConfig(@PathVariable String serverName, @PathVariable String discoveryEngineName, @PathVariable String userId) {
        return this.restAPI.refreshConfig(serverName, discoveryEngineName, userId);
    }
}

