/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.discoveryengineservices.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.AnnotationListResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.AnnotationResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.DiscoveryAnalysisReportResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.DiscoveryRequestRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.governanceservers.discoveryengineservices.server.DiscoveryServerRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/discovery-server/users/{userId}/discovery-engines/{discoveryEngineName}"})
@Tag(name="Discovery Engine Services", description="The discovery engine services provide the core subsystem for a discovery server. A discovery server is an OMAG Server that hosts automated metadata discovery.", externalDocs=@ExternalDocumentation(description="Discovery Engine Services", url="https://egeria.odpi.org/open-metadata-implementation/governance-servers/discovery-engine-services/"))
public class DiscoveryEngineResource {
    private DiscoveryServerRESTServices restAPI = new DiscoveryServerRESTServices();

    @PostMapping(path={"/discovery-request-types/{discoveryRequestType}/assets/{assetGUID}"})
    public GUIDResponse discoverAsset(@PathVariable String serverName, @PathVariable String discoveryEngineName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String discoveryRequestType, @RequestBody DiscoveryRequestRequestBody requestBody) {
        return this.restAPI.discoverAsset(serverName, discoveryEngineName, userId, assetGUID, discoveryRequestType, requestBody);
    }

    @PostMapping(path={"/discovery-request-types/{discoveryRequestType}/assets"})
    public VoidResponse scanAllAssets(@PathVariable String serverName, @PathVariable String discoveryEngineName, @PathVariable String userId, @PathVariable String discoveryRequestType, @RequestBody(required=false) DiscoveryRequestRequestBody requestBody) {
        return this.restAPI.scanAllAssets(serverName, discoveryEngineName, userId, discoveryRequestType, requestBody);
    }

    @GetMapping(path={"/discovery-analysis-reports/{discoveryRequestGUID}"})
    public DiscoveryAnalysisReportResponse getDiscoveryAnalysisReport(@PathVariable String serverName, @PathVariable String discoveryEngineName, @PathVariable String userId, @PathVariable String discoveryRequestGUID) {
        return this.restAPI.getDiscoveryAnalysisReport(serverName, discoveryEngineName, userId, discoveryRequestGUID);
    }

    @GetMapping(path={"/discovery-analysis-reports/{discoveryRequestGUID}/annotations"})
    public AnnotationListResponse getDiscoveryReportAnnotations(@PathVariable String serverName, @PathVariable String discoveryEngineName, @PathVariable String userId, @PathVariable String discoveryRequestGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getDiscoveryReportAnnotations(serverName, discoveryEngineName, userId, discoveryRequestGUID, startingFrom, maximumResults);
    }

    @GetMapping(path={"/discovery-analysis-reports/{discoveryRequestGUID}/annotations/{annotationGUID}/extended-annotations"})
    public AnnotationListResponse getExtendedAnnotations(@PathVariable String serverName, @PathVariable String discoveryEngineName, @PathVariable String userId, @PathVariable String discoveryRequestGUID, @PathVariable String annotationGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getExtendedAnnotations(serverName, discoveryEngineName, userId, discoveryRequestGUID, annotationGUID, startingFrom, maximumResults);
    }

    @GetMapping(path={"discovery-analysis-reports/{discoveryRequestGUID}/annotations/{annotationGUID}"})
    public AnnotationResponse getAnnotation(@PathVariable String serverName, @PathVariable String discoveryEngineName, @PathVariable String userId, @PathVariable String discoveryRequestGUID, @PathVariable String annotationGUID) {
        return this.restAPI.getAnnotation(serverName, discoveryEngineName, userId, discoveryRequestGUID, annotationGUID);
    }
}

