/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.server.spring;

import org.odpi.openmetadata.accessservices.discoveryengine.server.DiscoveryConfigurationServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DeleteRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryEngineListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryEnginePropertiesResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryServiceListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryServicePropertiesResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryServiceRegistrationRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.NewDiscoveryEngineRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.NewDiscoveryServiceRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.RegisteredDiscoveryServiceResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.UpdateDiscoveryEngineRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.UpdateDiscoveryServiceRequestBody;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/discovery-engine/users/{userId}"})
public class DiscoveryConfigurationResource {
    private DiscoveryConfigurationServices restAPI = new DiscoveryConfigurationServices();

    @GetMapping(path={"topics/out-topic-connection"})
    public ConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getOutTopicConnection(serverName, userId);
    }

    @PostMapping(path={"/discovery-engines"})
    public GUIDResponse createDiscoveryEngine(@PathVariable String serverName, @PathVariable String userId, @RequestBody NewDiscoveryEngineRequestBody requestBody) {
        return this.restAPI.createDiscoveryEngine(serverName, userId, requestBody);
    }

    @GetMapping(path={"/discovery-engines/{guid}"})
    public DiscoveryEnginePropertiesResponse getDiscoveryEngineByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getDiscoveryEngineByGUID(serverName, userId, guid);
    }

    @GetMapping(path={"/discovery-engines/by-name/{name}"})
    public DiscoveryEnginePropertiesResponse getDiscoveryEngineByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getDiscoveryEngineByName(serverName, userId, name);
    }

    @GetMapping(path={"/discovery-engines"})
    public DiscoveryEngineListResponse getAllDiscoveryEngines(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getAllDiscoveryEngines(serverName, userId, startingFrom, maximumResults);
    }

    @PostMapping(path={"/discovery-engines/{guid}"})
    public VoidResponse updateDiscoveryEngine(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody UpdateDiscoveryEngineRequestBody requestBody) {
        return this.restAPI.updateDiscoveryEngine(serverName, userId, guid, requestBody);
    }

    @PostMapping(path={"/discovery-engines/{guid}/delete"})
    public VoidResponse deleteDiscoveryEngine(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteDiscoveryEngine(serverName, userId, guid, requestBody);
    }

    @PostMapping(path={"/discovery-services"})
    public GUIDResponse createDiscoveryService(@PathVariable String serverName, @PathVariable String userId, @RequestBody NewDiscoveryServiceRequestBody requestBody) {
        return this.restAPI.createDiscoveryService(serverName, userId, requestBody);
    }

    @GetMapping(path={"/discovery-services/{guid}"})
    public DiscoveryServicePropertiesResponse getDiscoveryServiceByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getDiscoveryServiceByGUID(serverName, userId, guid);
    }

    @GetMapping(path={"/discovery-services/by-name/{name}"})
    public DiscoveryServicePropertiesResponse getDiscoveryServiceByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getDiscoveryServiceByName(serverName, userId, name);
    }

    @GetMapping(path={"/discovery-services"})
    public DiscoveryServiceListResponse getAllDiscoveryServices(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getAllDiscoveryServices(serverName, userId, startingFrom, maximumResults);
    }

    @GetMapping(path={"/discovery-services/{guid}/registrations"})
    public GUIDListResponse getDiscoveryServiceRegistrations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getDiscoveryServiceRegistrations(serverName, userId, guid);
    }

    @PostMapping(path={"/discovery-services/{guid}"})
    public VoidResponse updateDiscoveryService(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody UpdateDiscoveryServiceRequestBody requestBody) {
        return this.restAPI.updateDiscoveryService(serverName, userId, guid, requestBody);
    }

    @PostMapping(path={"/discovery-services/{guid}/delete"})
    public VoidResponse deleteDiscoveryService(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteDiscoveryService(serverName, userId, guid, requestBody);
    }

    @PostMapping(path={"/discovery-engines/{guid}/discovery-services"})
    public VoidResponse registerDiscoveryServiceWithEngine(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody DiscoveryServiceRegistrationRequestBody requestBody) {
        return this.restAPI.registerDiscoveryServiceWithEngine(serverName, userId, guid, requestBody);
    }

    @GetMapping(path={"/discovery-engines/{discoveryEngineGUID}/discovery-services/{discoveryServiceGUID}"})
    public RegisteredDiscoveryServiceResponse getRegisteredDiscoveryService(@PathVariable String serverName, @PathVariable String userId, @PathVariable String discoveryEngineGUID, @PathVariable String discoveryServiceGUID) {
        return this.restAPI.getRegisteredDiscoveryService(serverName, userId, discoveryEngineGUID, discoveryServiceGUID);
    }

    @GetMapping(path={"/discovery-engines/{discoveryEngineGUID}/discovery-services"})
    public GUIDListResponse getRegisteredDiscoveryServices(@PathVariable String serverName, @PathVariable String userId, @PathVariable String discoveryEngineGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getRegisteredDiscoveryServices(serverName, userId, discoveryEngineGUID, startingFrom, maximumResults);
    }

    @PostMapping(path={"/discovery-engines/{discoveryEngineGUID}/discovery-services/{discoveryServiceGUID}/delete"})
    public VoidResponse unregisterDiscoveryServiceFromEngine(@PathVariable String serverName, @PathVariable String userId, @PathVariable String discoveryEngineGUID, @PathVariable String discoveryServiceGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.unregisterDiscoveryServiceFromEngine(serverName, userId, discoveryEngineGUID, discoveryServiceGUID, requestBody);
    }
}

