/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.server.spring;

import org.odpi.openmetadata.accessservices.discoveryengine.server.DiscoveryEngineRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.StatusRequestBody;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/discovery-engine/users/{userId}"})
public class DiscoveryMetadataStoreResource {
    private DiscoveryEngineRESTServices restAPI = new DiscoveryEngineRESTServices();

    @PostMapping(path={"/assets"})
    public GUIDListResponse getAssets(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.getAssets(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/assets/by-qualified-name"})
    public GUIDListResponse getAssetsByQualifiedName(@PathVariable String serverName, @PathVariable String userId, @RequestBody String name, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssetsByQualifiedName(serverName, userId, name, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/by-name"})
    public GUIDListResponse getAssetsByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody String name, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssetsByName(serverName, userId, name, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/by-search-string"})
    public GUIDListResponse findAssets(@PathVariable String serverName, @PathVariable String userId, @RequestBody String searchString, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findAssets(serverName, userId, searchString, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/by-endpoint-address"})
    public GUIDListResponse getAssetsByEndpoint(@PathVariable String serverName, @PathVariable String userId, @RequestBody String networkAddress, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssetsByEndpoint(serverName, userId, networkAddress, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/{assetGUID}/log-records/{discoveryService}"})
    public VoidResponse logAssetAuditMessage(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String discoveryService, @RequestBody String message) {
        return this.restAPI.logAssetAuditMessage(serverName, userId, assetGUID, discoveryService, message);
    }

    @PostMapping(path={"/assets/{assetGUID}/discovery-analysis-reports"})
    public GUIDResponse createDiscoveryAnalysisReport(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody DiscoveryAnalysisReportRequestBody requestBody) {
        return this.restAPI.createDiscoveryAnalysisReport(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/discovery-analysis-reports/{discoveryReportGUID}"})
    public VoidResponse updateDiscoveryAnalysisReport(@PathVariable String serverName, @PathVariable String userId, @PathVariable String discoveryReportGUID, @RequestBody DiscoveryAnalysisReport requestBody) {
        return this.restAPI.updateDiscoveryAnalysisReport(serverName, userId, discoveryReportGUID, requestBody);
    }

    @GetMapping(path={"/discovery-analysis-reports/{discoveryReportGUID}"})
    public DiscoveryAnalysisReportResponse getDiscoveryReport(@PathVariable String serverName, @PathVariable String userId, @PathVariable String discoveryReportGUID) {
        return this.restAPI.getDiscoveryAnalysisReport(serverName, userId, discoveryReportGUID);
    }

    @GetMapping(path={"/annotations/sub-types"})
    public NameListResponse getTypesOfAnnotation(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getTypesOfAnnotation(serverName, userId);
    }

    @GetMapping(path={"/annotations/sub-types/descriptions"})
    public StringMapResponse getTypesOfAnnotationWithDescriptions(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getTypesOfAnnotationWithDescriptions(serverName, userId);
    }

    @GetMapping(path={"/assets/{assetGUID}/annotations"})
    public AnnotationListResponse getAnnotationsForAssetByStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int startingFrom, @RequestParam int maximumResults, @RequestBody StatusRequestBody requestBody) {
        return this.restAPI.getAnnotationsForAssetByStatus(serverName, userId, assetGUID, startingFrom, maximumResults, requestBody);
    }

    @GetMapping(path={"/discovery-analysis-reports/{discoveryReportGUID}/annotations"})
    public AnnotationListResponse getDiscoveryReportAnnotations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String discoveryReportGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getDiscoveryReportAnnotations(serverName, userId, discoveryReportGUID, startingFrom, maximumResults);
    }

    @GetMapping(path={"/annotations/{annotationGUID}/extended-annotations"})
    public AnnotationListResponse getExtendedAnnotations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String annotationGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getExtendedAnnotations(serverName, userId, annotationGUID, startingFrom, maximumResults);
    }

    @GetMapping(path={"/annotations/{annotationGUID}"})
    public AnnotationResponse getAnnotation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String annotationGUID) {
        return this.restAPI.getAnnotation(serverName, userId, annotationGUID);
    }

    @PostMapping(path={"/discovery-analysis-reports/{discoveryReportGUID}/annotations"})
    public GUIDResponse addAnnotationToDiscoveryReport(@PathVariable String serverName, @PathVariable String userId, @PathVariable String discoveryReportGUID, @RequestBody Annotation requestBody) {
        return this.restAPI.addAnnotationToDiscoveryReport(serverName, userId, discoveryReportGUID, requestBody);
    }

    @PostMapping(path={"/annotations/{anchorAnnotationGUID}/extended-annotations"})
    public GUIDResponse addAnnotationToAnnotation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String anchorAnnotationGUID, @RequestBody Annotation requestBody) {
        return this.restAPI.addAnnotationToAnnotation(serverName, userId, anchorAnnotationGUID, requestBody);
    }

    @PostMapping(path={"/annotations/{annotationGUID}"})
    public VoidResponse updateAnnotation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String annotationGUID, @RequestBody Annotation requestBody) {
        return this.restAPI.updateAnnotation(serverName, userId, annotationGUID, requestBody);
    }

    @PostMapping(path={"/annotations/{annotationGUID}/delete"})
    public VoidResponse deleteAnnotation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String annotationGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.deleteAnnotation(serverName, userId, annotationGUID, requestBody);
    }
}

