/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.discoveryservices;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum DiscoveryServiceErrorCode implements ExceptionMessageSet
{
    INVALID_ASSET_TYPE(400, "OMAG-DISCOVERY-SERVICE-400-001 ", "Asset {0} is of type {1} but discovery service {2} only supports the following asset type(s): {3}", "The discovery service terminates without running any automated metadata discovery function.", "The caller has requested a discovery request type that is incompatible with the type of the asset that has been supplied.  Ths problem could be resolved by issuing the discovery request with a discovery request type that is compatible with the asset, or changing the discovery service associated with the discovery request type to one that supports this type of asset."),
    NO_ASSET(500, "OMAG-DISCOVERY-SERVICE-500-001 ", "No information about the asset {0} has been returned from the asset store for discovery service {1}.", "The discovery service terminates without running any automated metadata discovery function.", "This is an unexpected condition because if the metadata server was unavailable, an exception would have been caught."),
    NO_ASSET_TYPE(500, "OMAG-DISCOVERY-SERVICE-500-002 ", "No type name is available for the asset passed to discovery service {0}.  The full asset contents are: {1}.", "The discovery service terminates without running any automated metadata discovery function.", "This is an unexpected condition because if the metadata server was unavailable, an exception would have been caught.");

    private ExceptionMessageDefinition messageDefinition;

    private DiscoveryServiceErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }
}

