/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.discoveryservices;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.discoveryservices.DiscoveryServiceErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetConnections;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryService;

public abstract class AuditableDiscoveryService
extends DiscoveryService {
    protected void logNoAsset(String assetGUID, String methodName) throws ConnectorCheckedException {
        throw new ConnectorCheckedException(DiscoveryServiceErrorCode.NO_ASSET.getMessageDefinition(assetGUID, this.discoveryServiceName), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    protected void logWrongTypeOfAsset(String assetGUID, String assetType, String supportedAssetType, String methodName) throws ConnectorCheckedException {
        throw new ConnectorCheckedException(DiscoveryServiceErrorCode.INVALID_ASSET_TYPE.getMessageDefinition(assetGUID, assetType, this.discoveryServiceName, supportedAssetType), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    protected String getAssetTypeName(AssetUniverse asset, String methodName) throws ConnectorCheckedException {
        AssetElementType elementType = asset.getType();
        if (elementType != null) {
            return elementType.getElementTypeName();
        }
        throw new ConnectorCheckedException(DiscoveryServiceErrorCode.NO_ASSET_TYPE.getMessageDefinition(asset.toString(), this.discoveryServiceName), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    protected List<String> getNetworkAddresses(AssetUniverse asset) {
        AssetConnections assetConnections;
        if (asset != null && (assetConnections = asset.getConnections()) != null) {
            ArrayList<String> networkAddresses = new ArrayList<String>();
            while (assetConnections.hasNext()) {
                EndpointProperties endpointProperties;
                ConnectionProperties connectionProperties = assetConnections.next();
                if (connectionProperties == null || (endpointProperties = connectionProperties.getEndpoint()) == null || endpointProperties.getAddress() == null || networkAddresses.contains(endpointProperties.getAddress())) continue;
                networkAddresses.add(endpointProperties.getAddress());
            }
            if (!networkAddresses.isEmpty()) {
                return networkAddresses;
            }
        }
        return null;
    }
}

