/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.discoveryservices;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.discoveryservices.AuditableDiscoveryService;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAnnotationStore;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAssetCatalogStore;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.SuspectDuplicateAnnotation;

public class DuplicateSuspectDiscoveryService
extends AuditableDiscoveryService {
    private static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";
    private static final String NETWORK_ADDRESS_PROPERTY = "Connection::Endpoint::address";
    private final Map<String, List<String>> suspectDuplicateReport = new HashMap<String, List<String>>();

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            String assetGUID = this.discoveryContext.getAssetGUID();
            AssetUniverse asset = this.discoveryContext.getAssetStore().getAssetProperties();
            if (asset == null) {
                super.logNoAsset(assetGUID, "start");
                return;
            }
            List<String> endpointNetworkAddresses = super.getNetworkAddresses(asset);
            String qualifiedName = asset.getQualifiedName();
            String displayName = asset.getDisplayName();
            DiscoveryAssetCatalogStore assetCatalogStore = this.discoveryContext.getAssetCatalogStore();
            List retrievedAssetGUIDs = assetCatalogStore.getAssetsByQualifiedName(qualifiedName, 0, assetCatalogStore.getMaxPageSize());
            this.captureDuplicateSuspects(retrievedAssetGUIDs, QUALIFIED_NAME_PROPERTY);
            if (displayName != null) {
                retrievedAssetGUIDs = assetCatalogStore.getAssetsByName(displayName, 0, assetCatalogStore.getMaxPageSize());
                this.captureDuplicateSuspects(retrievedAssetGUIDs, DISPLAY_NAME_PROPERTY);
            }
            if (endpointNetworkAddresses != null) {
                for (String networkAddress : endpointNetworkAddresses) {
                    if (networkAddress == null) continue;
                    retrievedAssetGUIDs = assetCatalogStore.getAssetsByName(displayName, 0, assetCatalogStore.getMaxPageSize());
                    this.captureDuplicateSuspects(retrievedAssetGUIDs, NETWORK_ADDRESS_PROPERTY);
                }
            }
            this.recordAnnotations();
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            super.handleUnexpectedException("start", (Throwable)error);
        }
    }

    private void captureDuplicateSuspects(List<String> duplicateSuspectGUIDs, String propertyName) {
        if (duplicateSuspectGUIDs != null) {
            for (String duplicateSuspectGUID : duplicateSuspectGUIDs) {
                if (duplicateSuspectGUID == null) continue;
                List<String> duplicateSuspectRecord = this.suspectDuplicateReport.get(duplicateSuspectGUID);
                if (duplicateSuspectRecord == null) {
                    duplicateSuspectRecord = new ArrayList<String>();
                }
                duplicateSuspectRecord.add(propertyName);
                this.suspectDuplicateReport.put(duplicateSuspectGUID, duplicateSuspectRecord);
            }
        }
    }

    private void recordAnnotations() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "recordAnnotations";
        DiscoveryAnnotationStore annotationStore = this.discoveryContext.getAnnotationStore();
        if (this.suspectDuplicateReport.isEmpty()) {
            SuspectDuplicateAnnotation annotation = new SuspectDuplicateAnnotation();
            annotation.setAnnotationType("Unique Asset");
            annotation.setSummary("No matching assets found based on qualified name, display name and endpoint addresses.");
            annotationStore.addAnnotationToDiscoveryReport((Annotation)annotation);
        } else {
            for (String suspectGUID : this.suspectDuplicateReport.keySet()) {
                if (suspectGUID == null) continue;
                SuspectDuplicateAnnotation annotation = new SuspectDuplicateAnnotation();
                annotation.setAnnotationType("Duplicate Suspect Asset");
                annotation.setSummary("This asset appears to refer to the same physical asset.");
                annotation.setMatchingPropertyNames(this.suspectDuplicateReport.get(suspectGUID));
                annotationStore.addAnnotationToDiscoveryReport((Annotation)annotation);
            }
        }
    }
}

