/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.display.connector;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DisplayApplicationClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataContainerElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFieldElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementStub;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FormElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.QueryElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ReportElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataContainerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataFieldProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FormProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.QueryProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ReportProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class DisplayIntegratorContext {
    private DisplayApplicationClient client;
    private DataManagerEventClient eventClient;
    private String userId;
    private String applicationGUID;
    private String applicationName;
    private boolean applicationIsHome = true;

    public DisplayIntegratorContext(DisplayApplicationClient client, DataManagerEventClient eventClient, String userId, String applicationGUID, String applicationName) {
        this.client = client;
        this.eventClient = eventClient;
        this.userId = userId;
        this.applicationGUID = applicationGUID;
        this.applicationName = applicationName;
    }

    public void setApplicationIsHome(boolean applicationIsHome) {
        this.applicationIsHome = applicationIsHome;
    }

    public void registerListener(DataManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public String createForm(FormProperties formProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createForm(this.userId, this.applicationGUID, this.applicationName, this.applicationIsHome, formProperties);
    }

    public String createFormFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createFormFromTemplate(this.userId, this.applicationGUID, this.applicationName, this.applicationIsHome, templateGUID, templateProperties);
    }

    public void updateForm(String formGUID, boolean isMergeUpdate, FormProperties formProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateForm(this.userId, this.applicationGUID, this.applicationName, formGUID, isMergeUpdate, formProperties);
    }

    public void publishForm(String formGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.publishForm(this.userId, formGUID);
    }

    public void withdrawForm(String formGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.withdrawForm(this.userId, formGUID);
    }

    public void removeForm(String formGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeForm(this.userId, this.applicationGUID, this.applicationName, formGUID, qualifiedName);
    }

    public List<FormElement> findForms(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findForms(this.userId, searchString, startFrom, pageSize);
    }

    public List<FormElement> getFormsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFormsByName(this.userId, name, startFrom, pageSize);
    }

    public List<FormElement> getFormsForApplication(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFormsForApplication(this.userId, this.applicationGUID, this.applicationName, startFrom, pageSize);
    }

    public FormElement getFormByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFormByGUID(this.userId, guid);
    }

    public String createReport(ReportProperties reportProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createReport(this.userId, this.applicationGUID, this.applicationName, this.applicationIsHome, reportProperties);
    }

    public String createReportFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createReportFromTemplate(this.userId, this.applicationGUID, this.applicationName, this.applicationIsHome, templateGUID, templateProperties);
    }

    public void updateReport(String reportGUID, boolean isMergeUpdate, ReportProperties reportProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateReport(this.userId, this.applicationGUID, this.applicationName, reportGUID, isMergeUpdate, reportProperties);
    }

    public void publishReport(String reportGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.publishReport(this.userId, reportGUID);
    }

    public void withdrawReport(String reportGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.withdrawReport(this.userId, reportGUID);
    }

    public void removeReport(String userId, String applicationGUID, String applicationName, String reportGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeReport(userId, applicationGUID, applicationName, reportGUID, qualifiedName);
    }

    public List<ReportElement> findReports(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findReports(this.userId, searchString, startFrom, pageSize);
    }

    public List<ReportElement> getReportsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getReportsByName(this.userId, name, startFrom, pageSize);
    }

    public List<ReportElement> getReportsForApplication(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getReportsForApplication(this.userId, this.applicationGUID, this.applicationName, startFrom, pageSize);
    }

    public ReportElement getReportByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getReportByGUID(this.userId, guid);
    }

    public String createQuery(QueryProperties queryProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createQuery(this.userId, this.applicationGUID, this.applicationName, this.applicationIsHome, queryProperties);
    }

    public String createQueryFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createQueryFromTemplate(this.userId, this.applicationGUID, this.applicationName, this.applicationIsHome, templateGUID, templateProperties);
    }

    public void updateQuery(String queryGUID, boolean isMergeUpdate, QueryProperties queryProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateQuery(this.userId, this.applicationGUID, this.applicationName, queryGUID, isMergeUpdate, queryProperties);
    }

    public void publishQuery(String queryGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.publishQuery(this.userId, queryGUID);
    }

    public void withdrawQuery(String queryGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.withdrawQuery(this.userId, queryGUID);
    }

    public void removeQuery(String userId, String applicationGUID, String applicationName, String queryGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeQuery(userId, applicationGUID, applicationName, queryGUID, qualifiedName);
    }

    public List<QueryElement> findQueries(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findQueries(this.userId, searchString, startFrom, pageSize);
    }

    public List<QueryElement> getQueriesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getQueriesByName(this.userId, name, startFrom, pageSize);
    }

    public List<QueryElement> getQueriesForApplication(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getQueriesForApplication(this.userId, this.applicationGUID, this.applicationName, startFrom, pageSize);
    }

    public QueryElement getQueryByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getQueryByGUID(this.userId, guid);
    }

    public String createDataContainer(String parentElementGUID, DataContainerProperties dataContainerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createDataContainer(this.userId, this.applicationGUID, this.applicationName, this.applicationIsHome, parentElementGUID, dataContainerProperties);
    }

    public String createDataContainerFromTemplate(String parentElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createDataContainerFromTemplate(this.userId, this.applicationGUID, this.applicationName, this.applicationIsHome, parentElementGUID, templateGUID, templateProperties);
    }

    public void updateDataContainer(String dataContainerGUID, boolean isMergeUpdate, DataContainerProperties dataContainerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateDataContainer(this.userId, this.applicationGUID, this.applicationName, dataContainerGUID, isMergeUpdate, dataContainerProperties);
    }

    public void removeDataContainer(String dataContainerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeDataContainer(this.userId, this.applicationGUID, this.applicationName, dataContainerGUID);
    }

    public List<DataContainerElement> findDataContainers(String typeName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findDataContainers(this.userId, typeName, searchString, startFrom, pageSize);
    }

    public List<DataContainerElement> getDataContainersForElement(String userId, String parentElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getDataContainersForElement(userId, parentElementGUID, startFrom, pageSize);
    }

    public List<DataContainerElement> getDataContainerByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getDataContainerByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public DataContainerElement getDataContainerByGUID(String dataContainerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getDataContainerByGUID(this.userId, dataContainerGUID);
    }

    public ElementStub getDataContainerParent(String dataContainerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getDataContainerParent(this.userId, dataContainerGUID);
    }

    public String createDataField(String parentElementGUID, DataFieldProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createDataField(this.userId, this.applicationGUID, this.applicationName, this.applicationIsHome, parentElementGUID, properties);
    }

    public String createDataFieldFromTemplate(String templateGUID, String reportGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createDataFieldFromTemplate(this.userId, this.applicationGUID, this.applicationName, this.applicationIsHome, templateGUID, reportGUID, templateProperties);
    }

    public void setupSchemaType(String relationshipTypeName, String apiParameterGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setupSchemaType(this.userId, this.applicationGUID, this.applicationName, this.applicationIsHome, relationshipTypeName, apiParameterGUID, schemaTypeGUID);
    }

    public void updateDataField(String dataFieldGUID, boolean isMergeUpdate, DataFieldProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateDataField(this.userId, this.applicationGUID, this.applicationName, dataFieldGUID, isMergeUpdate, properties);
    }

    public void removeDataField(String userId, String applicationGUID, String applicationName, String dataFieldGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeDataField(userId, applicationGUID, applicationName, dataFieldGUID);
    }

    public List<DataFieldElement> findDataFields(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findDataFields(this.userId, searchString, startFrom, pageSize);
    }

    public List<DataFieldElement> getChildDataFields(String parentElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getChildDataFields(this.userId, parentElementGUID, startFrom, pageSize);
    }

    public List<DataFieldElement> getDataFieldsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getDataFieldsByName(this.userId, name, startFrom, pageSize);
    }

    public DataFieldElement getDataFieldByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getDataFieldByGUID(userId, guid);
    }
}

