/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.display.connector;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DisplayApplicationClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataContainerElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFieldElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FormElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.QueryElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ReportElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataContainerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataFieldProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FormProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.QueryProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ReportProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;

public class DisplayIntegratorContext
extends IntegrationContext {
    private final DisplayApplicationClient client;
    private final DataManagerEventClient eventClient;

    public DisplayIntegratorContext(String connectorId, String connectorName, String connectorUserId, String serverName, OpenIntegrationClient openIntegrationClient, OpenMetadataClient openMetadataStoreClient, DisplayApplicationClient displayApplicationClient, DataManagerEventClient eventClient, boolean generateIntegrationReport, PermittedSynchronization permittedSynchronization, String integrationConnectorGUID, String externalSourceGUID, String externalSourceName, int maxPageSize) {
        super(connectorId, connectorName, connectorUserId, serverName, openIntegrationClient, openMetadataStoreClient, generateIntegrationReport, permittedSynchronization, externalSourceGUID, externalSourceName, integrationConnectorGUID, maxPageSize);
        this.client = displayApplicationClient;
        this.eventClient = eventClient;
    }

    public void registerListener(DataManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public String createForm(FormProperties formProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String formGUID = this.client.createForm(this.userId, this.externalSourceGUID, this.externalSourceName, this.externalSourceIsHome, formProperties);
        if (formGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(formGUID, formGUID);
            this.integrationReportWriter.reportElementCreation(formGUID);
        }
        return formGUID;
    }

    public String createFormFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String formGUID = this.client.createFormFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, this.externalSourceIsHome, templateGUID, templateProperties);
        if (formGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(formGUID, formGUID);
            this.integrationReportWriter.reportElementCreation(formGUID);
        }
        return formGUID;
    }

    public void updateForm(String formGUID, boolean isMergeUpdate, FormProperties formProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateForm(this.userId, this.externalSourceGUID, this.externalSourceName, formGUID, isMergeUpdate, formProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(formGUID, formGUID);
            this.integrationReportWriter.reportElementUpdate(formGUID);
        }
    }

    public void publishForm(String formGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.publishForm(this.userId, formGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(formGUID, formGUID);
            this.integrationReportWriter.reportElementUpdate(formGUID);
        }
    }

    public void withdrawForm(String formGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.withdrawForm(this.userId, formGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(formGUID, formGUID);
            this.integrationReportWriter.reportElementUpdate(formGUID);
        }
    }

    public void removeForm(String formGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeForm(this.userId, this.externalSourceGUID, this.externalSourceName, formGUID, qualifiedName);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(formGUID, formGUID);
            this.integrationReportWriter.reportElementDelete(formGUID);
        }
    }

    public List<FormElement> findForms(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findForms(this.userId, searchString, startFrom, pageSize);
    }

    public List<FormElement> getFormsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFormsByName(this.userId, name, startFrom, pageSize);
    }

    public List<FormElement> getFormsForApplication(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFormsForApplication(this.userId, this.externalSourceGUID, this.externalSourceName, startFrom, pageSize);
    }

    public FormElement getFormByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getFormByGUID(this.userId, guid);
    }

    public String createReport(ReportProperties reportProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUID = this.client.createReport(this.userId, this.externalSourceGUID, this.externalSourceName, this.externalSourceIsHome, reportProperties);
        if (reportGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(reportGUID, reportGUID);
            this.integrationReportWriter.reportElementCreation(reportGUID);
        }
        return reportGUID;
    }

    public String createReportFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUID = this.client.createReportFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, this.externalSourceIsHome, templateGUID, templateProperties);
        if (reportGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(reportGUID, reportGUID);
            this.integrationReportWriter.reportElementCreation(reportGUID);
        }
        return reportGUID;
    }

    public void updateReport(String reportGUID, boolean isMergeUpdate, ReportProperties reportProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateReport(this.userId, this.externalSourceGUID, this.externalSourceName, reportGUID, isMergeUpdate, reportProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(reportGUID, reportGUID);
            this.integrationReportWriter.reportElementUpdate(reportGUID);
        }
    }

    public void publishReport(String reportGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.publishReport(this.userId, reportGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(reportGUID, reportGUID);
            this.integrationReportWriter.reportElementUpdate(reportGUID);
        }
    }

    public void withdrawReport(String reportGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.withdrawReport(this.userId, reportGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(reportGUID, reportGUID);
            this.integrationReportWriter.reportElementUpdate(reportGUID);
        }
    }

    public void removeReport(String userId, String applicationGUID, String applicationName, String reportGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeReport(userId, applicationGUID, applicationName, reportGUID, qualifiedName);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(reportGUID, reportGUID);
            this.integrationReportWriter.reportElementDelete(reportGUID);
        }
    }

    public List<ReportElement> findReports(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findReports(this.userId, searchString, startFrom, pageSize);
    }

    public List<ReportElement> getReportsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getReportsByName(this.userId, name, startFrom, pageSize);
    }

    public List<ReportElement> getReportsForApplication(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getReportsForApplication(this.userId, this.externalSourceGUID, this.externalSourceName, startFrom, pageSize);
    }

    public ReportElement getReportByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getReportByGUID(this.userId, guid);
    }

    public String createQuery(QueryProperties queryProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String queryGUID = this.client.createQuery(this.userId, this.externalSourceGUID, this.externalSourceName, this.externalSourceIsHome, queryProperties);
        if (queryGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(queryGUID, queryGUID);
            this.integrationReportWriter.reportElementCreation(queryGUID);
        }
        return queryGUID;
    }

    public String createQueryFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String queryGUID = this.client.createQueryFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, this.externalSourceIsHome, templateGUID, templateProperties);
        if (queryGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(queryGUID, queryGUID);
            this.integrationReportWriter.reportElementCreation(queryGUID);
        }
        return queryGUID;
    }

    public void updateQuery(String queryGUID, boolean isMergeUpdate, QueryProperties queryProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateQuery(this.userId, this.externalSourceGUID, this.externalSourceName, queryGUID, isMergeUpdate, queryProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(queryGUID, queryGUID);
            this.integrationReportWriter.reportElementUpdate(queryGUID);
        }
    }

    public void publishQuery(String queryGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.publishQuery(this.userId, queryGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(queryGUID, queryGUID);
            this.integrationReportWriter.reportElementUpdate(queryGUID);
        }
    }

    public void withdrawQuery(String queryGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.withdrawQuery(this.userId, queryGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(queryGUID, queryGUID);
            this.integrationReportWriter.reportElementUpdate(queryGUID);
        }
    }

    public void removeQuery(String userId, String applicationGUID, String applicationName, String queryGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeQuery(userId, applicationGUID, applicationName, queryGUID, qualifiedName);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(queryGUID, queryGUID);
            this.integrationReportWriter.reportElementDelete(queryGUID);
        }
    }

    public List<QueryElement> findQueries(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findQueries(this.userId, searchString, startFrom, pageSize);
    }

    public List<QueryElement> getQueriesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getQueriesByName(this.userId, name, startFrom, pageSize);
    }

    public List<QueryElement> getQueriesForApplication(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getQueriesForApplication(this.userId, this.externalSourceGUID, this.externalSourceName, startFrom, pageSize);
    }

    public QueryElement getQueryByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getQueryByGUID(this.userId, guid);
    }

    public String createDataContainer(String parentElementGUID, DataContainerProperties dataContainerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataContainerGUID = this.client.createDataContainer(this.userId, this.externalSourceGUID, this.externalSourceName, this.externalSourceIsHome, parentElementGUID, dataContainerProperties);
        if (dataContainerGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.setParent(dataContainerGUID, parentElementGUID);
            this.integrationReportWriter.reportElementCreation(dataContainerGUID);
        }
        return dataContainerGUID;
    }

    public String createDataContainerFromTemplate(String parentElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataContainerGUID = this.client.createDataContainerFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, this.externalSourceIsHome, parentElementGUID, templateGUID, templateProperties);
        if (dataContainerGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.setParent(dataContainerGUID, parentElementGUID);
            this.integrationReportWriter.reportElementCreation(dataContainerGUID);
        }
        return dataContainerGUID;
    }

    public void updateDataContainer(String dataContainerGUID, boolean isMergeUpdate, DataContainerProperties dataContainerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateDataContainer(this.userId, this.externalSourceGUID, this.externalSourceName, dataContainerGUID, isMergeUpdate, dataContainerProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(dataContainerGUID);
        }
    }

    public void removeDataContainer(String dataContainerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeDataContainer(this.userId, this.externalSourceGUID, this.externalSourceName, dataContainerGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementDelete(dataContainerGUID);
        }
    }

    public List<DataContainerElement> findDataContainers(String typeName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findDataContainers(this.userId, typeName, searchString, startFrom, pageSize);
    }

    public List<DataContainerElement> getDataContainersForElement(String userId, String parentElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getDataContainersForElement(userId, parentElementGUID, startFrom, pageSize);
    }

    public List<DataContainerElement> getDataContainerByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getDataContainerByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public DataContainerElement getDataContainerByGUID(String dataContainerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getDataContainerByGUID(this.userId, dataContainerGUID);
    }

    public ElementStub getDataContainerParent(String dataContainerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getDataContainerParent(this.userId, dataContainerGUID);
    }

    public String createDataField(String parentElementGUID, DataFieldProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFieldGUID = this.client.createDataField(this.userId, this.externalSourceGUID, this.externalSourceName, this.externalSourceIsHome, parentElementGUID, properties);
        if (dataFieldGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.setParent(dataFieldGUID, parentElementGUID);
            this.integrationReportWriter.reportElementCreation(dataFieldGUID);
        }
        return dataFieldGUID;
    }

    public String createDataFieldFromTemplate(String templateGUID, String parentElementGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String dataFieldGUID = this.client.createDataFieldFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, this.externalSourceIsHome, templateGUID, parentElementGUID, templateProperties);
        if (dataFieldGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.setParent(dataFieldGUID, parentElementGUID);
            this.integrationReportWriter.reportElementCreation(dataFieldGUID);
        }
        return dataFieldGUID;
    }

    public void setupSchemaType(String relationshipTypeName, String dataFieldGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setupSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, this.externalSourceIsHome, relationshipTypeName, dataFieldGUID, schemaTypeGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setParent(schemaTypeGUID, dataFieldGUID);
            this.integrationReportWriter.reportElementUpdate(dataFieldGUID);
        }
    }

    public void updateDataField(String dataFieldGUID, boolean isMergeUpdate, DataFieldProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateDataField(this.userId, this.externalSourceGUID, this.externalSourceName, dataFieldGUID, isMergeUpdate, properties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(dataFieldGUID);
        }
    }

    public void removeDataField(String userId, String applicationGUID, String applicationName, String dataFieldGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeDataField(userId, applicationGUID, applicationName, dataFieldGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementDelete(dataFieldGUID);
        }
    }

    public List<DataFieldElement> findDataFields(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findDataFields(this.userId, searchString, startFrom, pageSize);
    }

    public List<DataFieldElement> getChildDataFields(String parentElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getChildDataFields(this.userId, parentElementGUID, startFrom, pageSize);
    }

    public List<DataFieldElement> getDataFieldsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getDataFieldsByName(this.userId, name, startFrom, pageSize);
    }

    public DataFieldElement getDataFieldByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getDataFieldByGUID(userId, guid);
    }
}

