/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.display.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum DisplayIntegratorErrorCode implements ExceptionMessageSet
{
    INVALID_CONNECTOR(400, "OMIS-DISPLAY-INTEGRATOR-400-001", "Integration connector {0} is not of the correct type to run in the {1} integration service.  It must inherit from {2}", "The integration service fails to start and this in turn causes the integration daemon to fail.", "The connector was configured through the administration calls for the integration service.Either move it to an appropriate integration service or update the connector implementation to inherit from the correct class."),
    NULL_CONTEXT(400, "OMIS-DISPLAY-INTEGRATOR-500-001", "Integration connector {0} has a null context", "The integration connector is running but does not have a context.  This is a timing issue in the integration daemon.", "Gather information about the connector's configuration, the types of metadata it was integrating, the audit log messages from the integration daemon and its partner metadata server.  Then contact the Egeria community to get help.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private DisplayIntegratorErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

