/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.display.rest;

import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.properties.ConnectorReport;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceRegistry;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonInstanceHandler;
import org.odpi.openmetadata.integrationservices.display.connector.DisplayIntegratorConnector;
import org.odpi.openmetadata.integrationservices.display.contextmanager.DisplayIntegratorContextManager;
import org.slf4j.LoggerFactory;

public class DisplayIntegratorRESTServices {
    private static IntegrationDaemonInstanceHandler instanceHandler = new IntegrationDaemonInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DisplayIntegratorRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public DisplayIntegratorRESTServices() {
        IntegrationServiceRegistry.registerIntegrationService((IntegrationServiceDescription)IntegrationServiceDescription.DISPLAY_INTEGRATOR_OMIS, (String)DisplayIntegratorContextManager.class.getName());
    }

    public ConnectorTypeResponse validateConnector(String serverName, String userId, String connectorProviderClassName) {
        String methodName = "validateConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "validateConnector");
        ConnectorTypeResponse response = new ConnectorTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateConnector");
            ConnectorReport connectorReport = instanceHandler.validateConnector(connectorProviderClassName, DisplayIntegratorConnector.class, IntegrationServiceDescription.DISPLAY_INTEGRATOR_OMIS.getIntegrationServiceFullName());
            if (connectorReport != null) {
                response = new ConnectorTypeResponse(connectorReport);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

