/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.display.contextmanager;

import java.util.Map;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DisplayApplicationClient;
import org.odpi.openmetadata.accessservices.datamanager.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.datamanager.client.OpenIntegrationServiceClient;
import org.odpi.openmetadata.accessservices.datamanager.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.properties.ApplicationProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnector;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.integrationservices.display.connector.DisplayIntegratorConnector;
import org.odpi.openmetadata.integrationservices.display.connector.DisplayIntegratorContext;
import org.odpi.openmetadata.integrationservices.display.ffdc.DisplayIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.display.ffdc.DisplayIntegratorErrorCode;

public class DisplayIntegratorContextManager
extends IntegrationContextManager {
    private DisplayApplicationClient displayApplicationClient = null;
    private MetadataSourceClient metadataSourceClient = null;
    private DataManagerRESTClient restClient = null;

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, serviceOptions, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", DisplayIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients() throws InvalidParameterException {
        this.openIntegrationClient = new OpenIntegrationServiceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL);
        this.restClient = this.localServerPassword == null ? new DataManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog) : new DataManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
        this.displayApplicationClient = new DisplayApplicationClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
        this.metadataSourceClient = new MetadataSourceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
    }

    protected String setUpMetadataSource(String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (metadataSourceQualifiedName != null) {
            String metadataSourceGUID = this.metadataSourceClient.getMetadataSourceGUID(this.localServerUserId, metadataSourceQualifiedName);
            if (metadataSourceGUID == null) {
                ApplicationProperties properties = new ApplicationProperties();
                properties.setQualifiedName(metadataSourceQualifiedName);
                metadataSourceGUID = this.metadataSourceClient.createApplication(this.localServerUserId, null, null, properties);
            }
            return metadataSourceGUID;
        }
        return null;
    }

    public IntegrationContext setContext(String connectorId, String connectorName, String connectorUserId, IntegrationConnector integrationConnector, String integrationConnectorGUID, PermittedSynchronization permittedSynchronization, boolean generateIntegrationReport, String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (this.serviceOptions != null) {
            serviceOptionsString = this.serviceOptions.toString();
        }
        if (integrationConnector instanceof DisplayIntegratorConnector) {
            this.auditLog.logMessage("setContext", DisplayIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
            DisplayIntegratorConnector serviceSpecificConnector = (DisplayIntegratorConnector)integrationConnector;
            String externalSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName);
            String externalSourceName = metadataSourceQualifiedName;
            if (externalSourceGUID == null) {
                externalSourceName = null;
            }
            DataManagerEventClient dataManagerEventClient = new DataManagerEventClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, (OCFRESTClient)this.restClient, this.maxPageSize, this.auditLog, connectorId);
            DisplayIntegratorContext integratorContext = new DisplayIntegratorContext(connectorId, connectorName, connectorUserId, this.partnerOMASServerName, this.openIntegrationClient, this.openMetadataStoreClient, this.displayApplicationClient, dataManagerEventClient, generateIntegrationReport, permittedSynchronization, integrationConnectorGUID, externalSourceGUID, externalSourceName, this.maxPageSize);
            serviceSpecificConnector.setContext(integratorContext);
            integrationConnector.setConnectorName(connectorName);
            return integratorContext;
        }
        String parameterName = "integrationConnector";
        throw new InvalidParameterException(DisplayIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.DISPLAY_INTEGRATOR_OMIS.getIntegrationServiceFullName(), DisplayIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
    }
}

