/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.dynamicarchivers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.engineservices.repositorygovernance.connector.RepositoryGovernanceContext;
import org.odpi.openmetadata.engineservices.repositorygovernance.connector.RepositoryGovernanceServiceConnector;
import org.odpi.openmetadata.engineservices.repositorygovernance.ffdc.RepositoryGovernanceErrorCode;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveCache;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveStoreConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationEntityExtension;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;

public abstract class DynamicArchiveService
extends RepositoryGovernanceServiceConnector {
    protected static final String archiveGUID = "9cbd2b33-e80f-4df2-adc6-d859ebff4c34";
    protected static final String archiveName = "CocoGovernanceEngineDefinitions";
    protected static final String archiveLicense = "Apache-2.0";
    protected static final String archiveDescription = "Governance Engines for Coco Pharmaceuticals.";
    protected static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    protected static final String originatorName = "Egeria Project";
    protected static final Date creationDate = new Date(1639984840038L);
    protected static final long versionNumber = 1L;
    protected static final String versionName = "1.0";
    protected List<ArchiveDestination> archiveDestinations = new ArrayList<ArchiveDestination>();

    private List<ArchiveDestination> getEmbeddedArchiveStoresConnectors() {
        ArrayList<ArchiveDestination> archiveDestinations = new ArrayList<ArchiveDestination>();
        if (this.embeddedConnectors != null) {
            for (Connector embeddedConnector : this.embeddedConnectors) {
                if (embeddedConnector == null || !(embeddedConnector instanceof OpenMetadataArchiveStoreConnector)) continue;
                ArchiveDestination archiveDestination = new ArchiveDestination((OpenMetadataArchiveStoreConnector)embeddedConnector);
                archiveDestinations.add(archiveDestination);
            }
        }
        return archiveDestinations;
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        this.validateContext(this.repositoryGovernanceContext);
        this.archiveDestinations = this.getEmbeddedArchiveStoresConnectors();
    }

    protected void handleUnexpectedException(String methodName, Exception error) throws ConnectorCheckedException {
        throw new ConnectorCheckedException(RepositoryGovernanceErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(new String[]{this.repositoryGovernanceServiceName, error.getClass().getName(), methodName, error.getMessage()}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    protected void validateContext(RepositoryGovernanceContext governanceContext) throws ConnectorCheckedException {
        String methodName = "start";
        if (governanceContext == null) {
            throw new ConnectorCheckedException(RepositoryGovernanceErrorCode.NULL_REPOSITORY_GOVERNANCE_CONTEXT.getMessageDefinition(new String[]{this.repositoryGovernanceServiceName}), ((Object)((Object)this)).getClass().getName(), "start");
        }
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                OpenMetadataArchive openMetadataArchive;
                if (archiveDestination == null || (openMetadataArchive = archiveDestination.getOpenMetadataArchive()) == null) continue;
                return openMetadataArchive;
            }
        }
        return null;
    }

    public void setArchiveProperties(String archiveGUID, String archiveName, String archiveDescription, OpenMetadataArchiveType archiveType, String archiveVersion, String originatorName, String originatorLicense, Date creationDate, List<OpenMetadataArchive> dependsOnArchives) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                archiveDestination.setArchiveProperties(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, dependsOnArchives);
            }
        }
    }

    protected OpenMetadataArchiveProperties getArchiveProperties() {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                return archiveDestination.getArchiveProperties();
            }
        }
        return null;
    }

    protected void addPrimitiveDef(PrimitiveDef primitiveDef) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                archiveDestination.addPrimitiveDef(primitiveDef);
            }
        }
    }

    protected PrimitiveDef getPrimitiveDef(String primitiveDefName) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                return archiveDestination.getPrimitiveDef(primitiveDefName);
            }
        }
        return null;
    }

    protected void addCollectionDef(CollectionDef collectionDef) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                archiveDestination.addCollectionDef(collectionDef);
            }
        }
    }

    protected CollectionDef getCollectionDef(String collectionDefName) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                return archiveDestination.getCollectionDef(collectionDefName);
            }
        }
        return null;
    }

    protected void addEnumDef(EnumDef enumDef) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                archiveDestination.addEnumDef(enumDef);
            }
        }
    }

    protected EnumDef getEnumDef(String enumDefName) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                return archiveDestination.getEnumDef(enumDefName);
            }
        }
        return null;
    }

    protected void addClassificationDef(ClassificationDef classificationDef) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                archiveDestination.addClassificationDef(classificationDef);
            }
        }
    }

    protected ClassificationDef getClassificationDef(String classificationDef) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                return archiveDestination.getClassificationDef(classificationDef);
            }
        }
        return null;
    }

    protected void addEntityDef(EntityDef entityDef) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                archiveDestination.addEntityDef(entityDef);
            }
        }
    }

    protected EntityDef getEntityDef(String entityDefName) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                return archiveDestination.getEntityDef(entityDefName);
            }
        }
        return null;
    }

    protected RelationshipDef getRelationshipDef(String relationshipDefName) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                return archiveDestination.getRelationshipDef(relationshipDefName);
            }
        }
        return null;
    }

    protected void addRelationshipDef(RelationshipDef relationshipDef) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                archiveDestination.addRelationshipDef(relationshipDef);
            }
        }
    }

    protected TypeDefPatch getPatchForType(String typeName) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                return archiveDestination.getPatchForType(typeName);
            }
        }
        return null;
    }

    protected void addTypeDefPatch(TypeDefPatch typeDefPatch) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                archiveDestination.addTypeDefPatch(typeDefPatch);
            }
        }
    }

    protected TypeDef getTypeDefByName(String typeName) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                return archiveDestination.getTypeDefByName(typeName);
            }
        }
        return null;
    }

    protected void addEntity(EntityDetail entity) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                archiveDestination.addEntity(entity);
            }
        }
    }

    protected EntityDetail getEntity(String guid) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                return archiveDestination.getEntity(guid);
            }
        }
        return null;
    }

    protected void addRelationship(Relationship relationship) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                archiveDestination.addRelationship(relationship);
            }
        }
    }

    protected Relationship getRelationship(String guid) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                return archiveDestination.getRelationship(guid);
            }
        }
        return null;
    }

    protected void addClassification(ClassificationEntityExtension classification) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                archiveDestination.addClassification(classification);
            }
        }
    }

    protected ClassificationEntityExtension getClassification(String entityGUID, String classificationName) {
        if (this.archiveDestinations != null) {
            for (ArchiveDestination archiveDestination : this.archiveDestinations) {
                if (archiveDestination == null) continue;
                return archiveDestination.getClassification(entityGUID, classificationName);
            }
        }
        return null;
    }

    protected class ArchiveDestination
    implements OpenMetadataArchiveBuilder,
    OpenMetadataArchiveCache {
        OpenMetadataArchiveBuilder builder = null;
        OpenMetadataArchiveStoreConnector store;
        OpenMetadataArchiveCache cache = null;

        protected ArchiveDestination(OpenMetadataArchiveStoreConnector store) {
            this.store = store;
            if (store instanceof OpenMetadataArchiveBuilder) {
                this.builder = (OpenMetadataArchiveBuilder)store;
            }
        }

        public OpenMetadataArchive getOpenMetadataArchive() {
            if (this.cache != null) {
                return this.cache.getOpenMetadataArchive();
            }
            return null;
        }

        public void setArchiveProperties(String archiveGUID, String archiveName, String archiveDescription, OpenMetadataArchiveType archiveType, String archiveVersion, String originatorName, String originatorLicense, Date creationDate, List<OpenMetadataArchive> dependsOnArchives) {
            if (this.builder != null) {
                this.builder.setArchiveProperties(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, dependsOnArchives);
            } else {
                OMRSArchiveBuilder cacheBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, dependsOnArchives);
                this.builder = cacheBuilder;
                this.cache = cacheBuilder;
            }
        }

        public OpenMetadataArchiveProperties getArchiveProperties() {
            return this.builder.getArchiveProperties();
        }

        public void addPrimitiveDef(PrimitiveDef primitiveDef) {
            this.builder.addPrimitiveDef(primitiveDef);
        }

        public PrimitiveDef getPrimitiveDef(String primitiveDefName) {
            return this.builder.getPrimitiveDef(primitiveDefName);
        }

        public void addCollectionDef(CollectionDef collectionDef) {
            this.builder.addCollectionDef(collectionDef);
        }

        public CollectionDef getCollectionDef(String collectionDefName) {
            return this.builder.getCollectionDef(collectionDefName);
        }

        public void addEnumDef(EnumDef enumDef) {
            this.builder.addEnumDef(enumDef);
        }

        public EnumDef getEnumDef(String enumDefName) {
            return this.builder.getEnumDef(enumDefName);
        }

        public void addClassificationDef(ClassificationDef classificationDef) {
            this.builder.addClassificationDef(classificationDef);
        }

        public void addEntityDef(EntityDef entityDef) {
            this.builder.addEntityDef(entityDef);
        }

        public EntityDef getEntityDef(String entityDefName) {
            return this.builder.getEntityDef(entityDefName);
        }

        public RelationshipDef getRelationshipDef(String relationshipDefName) {
            return this.builder.getRelationshipDef(relationshipDefName);
        }

        public ClassificationDef getClassificationDef(String classificationDef) {
            return this.builder.getClassificationDef(classificationDef);
        }

        public void addRelationshipDef(RelationshipDef relationshipDef) {
            this.builder.addRelationshipDef(relationshipDef);
        }

        public TypeDefPatch getPatchForType(String typeName) {
            return this.builder.getPatchForType(typeName);
        }

        public void addTypeDefPatch(TypeDefPatch typeDefPatch) {
            this.builder.addTypeDefPatch(typeDefPatch);
        }

        public TypeDef getTypeDefByName(String typeName) {
            return this.builder.getTypeDefByName(typeName);
        }

        public void addEntity(EntityDetail entity) {
            this.builder.addEntity(entity);
        }

        public EntityDetail getEntity(String guid) {
            return this.builder.getEntity(guid);
        }

        public EntityDetail queryEntity(String guid) {
            return this.builder.queryEntity(guid);
        }

        public void addRelationship(Relationship relationship) {
            this.builder.addRelationship(relationship);
        }

        public Relationship getRelationship(String guid) {
            return this.builder.getRelationship(guid);
        }

        public Relationship queryRelationship(String guid) {
            return this.builder.queryRelationship(guid);
        }

        public void addClassification(ClassificationEntityExtension classification) {
            this.builder.addClassification(classification);
        }

        public ClassificationEntityExtension getClassification(String entityGUID, String classificationName) {
            return this.builder.getClassification(entityGUID, classificationName);
        }

        public ClassificationEntityExtension queryClassification(String entityGUID, String classificationName) {
            return this.builder.queryClassification(entityGUID, classificationName);
        }
    }
}

