/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.dynamicarchivers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestParameterType;

public enum DynamicArchiveRequestParameter {
    ARCHIVE_NAME("archiveName", "Unique descriptive name for the archive.", "string", "myArchive"),
    ARCHIVE_GUID("archiveGUID", "Unique identifier for the archive", "string", "08eb9483-f2f1-4b4b-8f66-8d551bf57a63");

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private DynamicArchiveRequestParameter(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<RequestParameterType> getRequestParameterTypes() {
        ArrayList<RequestParameterType> requestParameterTypes = new ArrayList<RequestParameterType>();
        for (DynamicArchiveRequestParameter requestParameter : DynamicArchiveRequestParameter.values()) {
            requestParameterTypes.add(requestParameter.getRequestParameterType());
        }
        return requestParameterTypes;
    }

    public RequestParameterType getRequestParameterType() {
        RequestParameterType requestParameterType = new RequestParameterType();
        requestParameterType.setName(this.name);
        requestParameterType.setDescription(this.description);
        requestParameterType.setDataType(this.dataType);
        requestParameterType.setExample(this.example);
        return requestParameterType;
    }

    public String toString() {
        return "RequestParameter{ name=" + this.name + "}";
    }
}

