/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.dynamicarchivers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestTypeType;

public enum DynamicArchiveRequestType {
    SNAPSHOT("snapshot", "Add the existing contents of the repository."),
    JOURNALING("journaling", "Add the existing contents of the repository and monitor for, and then capture, further updates.");

    public final String requestType;
    public final String description;

    private DynamicArchiveRequestType(String requestType, String description) {
        this.requestType = requestType;
        this.description = description;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<RequestTypeType> getRequestTypeTypes() {
        ArrayList<RequestTypeType> requestTypeTypes = new ArrayList<RequestTypeType>();
        for (DynamicArchiveRequestType requestTypeValue : DynamicArchiveRequestType.values()) {
            RequestTypeType requestTypeType = new RequestTypeType();
            requestTypeType.setRequestType(requestTypeValue.requestType);
            requestTypeType.setDescription(requestTypeValue.description);
            requestTypeTypes.add(requestTypeType);
        }
        return requestTypeTypes;
    }

    public RequestTypeType getRequestTypeType() {
        RequestTypeType requestTypeType = new RequestTypeType();
        requestTypeType.setRequestType(this.requestType);
        requestTypeType.setDescription(this.description);
        return requestTypeType;
    }

    public String toString() {
        return "RequestType{" + this.requestType + "}";
    }
}

