/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.dynamicarchivers.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum DynamicArchiverConnectorsErrorCode implements ExceptionMessageSet
{
    FILES_LOCATION_NOT_SPECIFIED(400, "DYNAMIC-ARCHIVER-SERVICES-400-001", "The name of the directory (folder) identifying where the files to be catalogued are located is null in the Connection object {0}", "The connector is unable to monitor the directory for files because the name of the directory is not passed in the Connection object.", "The name of the directory should be set up in the address property of the connection's Endpoint object.  Correct this in the configuration for this connector in the Files Integration integration service configuration which is part of the configuration of the Integration Daemon OMAG server where this connector is running."),
    FILES_LOCATION_NOT_DIRECTORY(400, "DYNAMIC-ARCHIVER-SERVICES-400-002", "The location of the files {0} given in Connection object {1} is not a directory", "The connector is unable to work with this location since it is not a directory (folder).", "Ensure a valid directory name is passed in the address property in the Endpoint object of the Connection object.  This connection object is part of he Files Integration integration service configuration which is part of the configuration of the Integration Daemon OMAG server where this connector is running."),
    FILES_LOCATION_NOT_READABLE(400, "DYNAMIC-ARCHIVER-SERVICES-400-003", "The directory {0} given in Connection object {1} is not readable", "The connector is unable to open the file because it does not have sufficient permission.", "Ensure the name of a readable file is passed in the address property in the Endpoint object of the Connection object."),
    UNEXPECTED_EXC_RETRIEVING_FOLDER(400, "DYNAMIC-ARCHIVER-SERVICES-400-004", "An unexpected {0} exception was returned to the {1} integration connector by the Files Integrator OMIS {2} method when trying to retrieve the FileFolder asset for directory {3} (absolute path {4}).  The error message was {5}", "The exception is returned to the integration daemon that is hosting this connector to enable it to perform error handling.", "Use the message in the nested exception to determine the root cause of the error. Once this is resolved, follow the instructions in the messages produced by the integration daemon to restart the connector."),
    UNEXPECTED_EXC_DATA_FILE_UPDATE(400, "DYNAMIC-ARCHIVER-SERVICES-400-005", "An unexpected {0} exception was returned to the {1} integration connector when it tried to update the DataFile in the metadata repositories for file {2}.  The error message was {3}", "The exception is logged and the integration connector continues to synchronize metadata.  This file is not catalogued at this time but may succeed later.", "Use the message in the unexpected exception to determine the root cause of the error and fix it."),
    NO_SOURCE_FILE_NAME(400, "DYNAMIC-ARCHIVER-SERVICES-400-006", "The {0} governance action service has been called without a source file name to work with", "The provisioning governance action service connector is designed to manage files on request.  It is unable to operate without the name of the source file and so it terminates with a FAILED completion status.", "The source file is passed to the governance action service through the request parameters or via the TargetForAction relationship.  Correct the information passed to the governance service and rerun the request"),
    FILES_LOCATION_NOT_FOUND(404, "DYNAMIC-ARCHIVER-SERVICES-404-001", "The directory named {0} in the Connection object {1} does not exist", "The connector is unable to locate the file it has been asked to work with.", "Ensure that the name of the file in the address property of the connection's Endpoint object matches the location of the file that the connector is to access."),
    UNEXPECTED_SECURITY_EXCEPTION(500, "DYNAMIC-ARCHIVER-SERVICES-500-001", "The connector received an unexpected security exception when reading the file named {0}; the error message was: {1}", "The connector is unable to access the file.", "Use details from the error message to determine the cause of the error and retry the request once it is resolved."),
    UNEXPECTED_IO_EXCEPTION(500, "DYNAMIC-ARCHIVER-SERVICES-500-002", "The connector received an unexpected IO exception when reading the file named {0}; the error message was: {1}", "The connector is unable to process the file.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved."),
    UNABLE_TO_REGISTER_LISTENER(500, "DYNAMIC-ARCHIVER-SERVICES-500-003", "The {0} governance action service received a {1} exception when it registered a listener with the governance context.  The exception's message is: {2}", "The governance action throws a GovernanceServiceException in the hope that the .", "This is likely to be a configuration error.  Review the description of the exception's message to understand what is not set up correctly and and follow its instructions."),
    UNEXPECTED_EXCEPTION(500, "DYNAMIC-ARCHIVER-SERVICES-500-004", "The {0} governance action service received an unexpected exception {1} during its processing; the error message was: {2}", "The governance action returns an exception to the Governance Action Engine.", "Use details from the error message to determine the cause of the error and retry the service call once it is resolved.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private DynamicArchiverConnectorsErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

