/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.utilities.serverconfig;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.odpi.openmetadata.adminservices.client.CohortMemberConfigurationClient;
import org.odpi.openmetadata.adminservices.client.IntegrationDaemonConfigurationClient;
import org.odpi.openmetadata.adminservices.client.MetadataAccessStoreConfigurationClient;
import org.odpi.openmetadata.adminservices.client.OMAGServerConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationConnectorConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.http.HttpHelper;
import org.odpi.openmetadata.platformservices.client.PlatformServicesClient;

public class ServerConfig {
    private static final String serverSecurityConnectorProviderClassName = "org.odpi.openmetadata.metadatasecurity.samples.CocoPharmaServerSecurityProvider";
    private static final String defaultAPIIntegrationConnectorProvider = "org.odpi.openmetadata.adapters.connectors.integration.openapis.OpenAPIMonitorIntegrationProvider";
    private static final String defaultInfraIntegrationConnectorProvider = "org.odpi.openmetadata.devprojects.connectors.integration.egeria.EgeriaCataloguerIntegrationProvider";
    private static final String defaultTopicIntegrationConnectorProvider = "org.odpi.openmetadata.adapters.connectors.integration.kafka.KafkaMonitorIntegrationProvider";
    private static final String eventsDisplayConnectorProviderClassName = "org.odpi.openmetadata.devprojects.connectors.auditlog.eventdisplay.EventDisplayAuditLogStoreProvider";
    private static final String defaultAuditLogConnectorProvider = "org.odpi.openmetadata.devprojects.connectors.auditlog.eventdisplay.EventDisplayAuditLogStoreProvider";
    private static final String defaultCohort = "dojoCohort";
    private static final String eventBusURLRoot = "localhost:9092";
    private static final String organizationName = "Coco Pharmaceuticals";
    private static final String systemUserId = "cocoMDS1npa";
    private static final int maxPageSize = 600;
    private final String platformURLRoot;
    private final String clientUserId;

    private ServerConfig(String platformURLRoot, String clientUserId) {
        this.platformURLRoot = platformURLRoot;
        this.clientUserId = clientUserId;
    }

    private String getPlatformOrigin() {
        try {
            PlatformServicesClient platformServicesClient = new PlatformServicesClient("MyPlatform", this.platformURLRoot);
            return platformServicesClient.getPlatformOrigin(this.clientUserId);
        }
        catch (Exception error) {
            System.out.println("\n\nThere was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
            System.out.println("Ensure the platform URl is correct and the platform is running");
            return null;
        }
    }

    private void setEventBus(OMAGServerConfigurationClient client) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        if (eventBusURLRoot != null) {
            HashMap configurationProperties = new HashMap();
            HashMap<String, String> producerProperties = new HashMap<String, String>();
            HashMap<String, String> consumerProperties = new HashMap<String, String>();
            producerProperties.put("bootstrap.servers", eventBusURLRoot);
            consumerProperties.put("bootstrap.servers", eventBusURLRoot);
            consumerProperties.put("auto.commit.interval.ms", "1");
            configurationProperties.put("producer", producerProperties);
            configurationProperties.put("consumer", consumerProperties);
            client.setEventBus(null, null, configurationProperties);
        }
    }

    private void setSecuritySecurityConnector(OMAGServerConfigurationClient client) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        if (serverSecurityConnectorProviderClassName != null) {
            Connection connection = new Connection();
            ConnectorType connectorType = new ConnectorType();
            connectorType.setConnectorProviderClassName(serverSecurityConnectorProviderClassName);
            connection.setConnectorType(connectorType);
            client.setServerSecurityConnection(connection);
        }
    }

    private void createMetadataStore(String serverName) {
        try {
            System.out.println("Configuring metadata store: " + serverName);
            MetadataAccessStoreConfigurationClient client = new MetadataAccessStoreConfigurationClient(this.clientUserId, serverName, this.platformURLRoot);
            client.setServerDescription("Metadata Access Store called " + serverName + " running on platform " + this.platformURLRoot);
            client.setServerUserId(systemUserId);
            client.setServerType(null);
            client.setOrganizationName(organizationName);
            client.setMaxPageSize(600);
            this.setSecuritySecurityConnector((OMAGServerConfigurationClient)client);
            client.setDefaultAuditLog();
            client.setServerURLRoot(this.platformURLRoot);
            this.setEventBus((OMAGServerConfigurationClient)client);
            client.setInMemLocalRepository();
            client.setLocalMetadataCollectionName(serverName + "'s metadata collection");
            ArrayList<String> assetLookupZones = new ArrayList<String>();
            assetLookupZones.add("data-lake");
            assetLookupZones.add("personal-files");
            ArrayList<String> personalFilesZone = new ArrayList<String>();
            personalFilesZone.add("personal-files");
            ArrayList<String> maintenanceZones = new ArrayList<String>();
            maintenanceZones.add("quarantine");
            maintenanceZones.add("trash-can");
            maintenanceZones.add("data-lake");
            ArrayList<String> newDataZone = new ArrayList<String>();
            newDataZone.add("quarantine");
            HashMap<String, Serializable> accessServiceOptions = new HashMap<String, Serializable>();
            if (eventBusURLRoot != null) {
                accessServiceOptions.put("SupportedZones", assetLookupZones);
                accessServiceOptions.put("DefaultZones", personalFilesZone);
                client.configureAccessService("asset-consumer", accessServiceOptions);
                accessServiceOptions.put("KarmaPointPlateau", Integer.valueOf(10));
                client.configureAccessService("community-profile", accessServiceOptions);
                accessServiceOptions = new HashMap();
                accessServiceOptions.put("SupportedZones", maintenanceZones);
                accessServiceOptions.put("DefaultZones", newDataZone);
                accessServiceOptions.put("PublishZones", assetLookupZones);
                client.configureAccessService("asset-owner", accessServiceOptions);
                client.configureAccessService("data-manager", accessServiceOptions);
                client.configureAccessService("asset-manager", accessServiceOptions);
                client.configureAccessService("governance-program", accessServiceOptions);
                client.configureAccessService("digital-architecture", accessServiceOptions);
                client.configureAccessService("it-infrastructure", accessServiceOptions);
            } else {
                accessServiceOptions.put("SupportedZones", assetLookupZones);
                accessServiceOptions.put("DefaultZones", personalFilesZone);
                client.configureAccessServiceNoTopics("asset-consumer", accessServiceOptions);
                accessServiceOptions.put("KarmaPointPlateau", Integer.valueOf(10));
                client.configureAccessServiceNoTopics("community-profile", accessServiceOptions);
                accessServiceOptions = new HashMap();
                accessServiceOptions.put("SupportedZones", maintenanceZones);
                accessServiceOptions.put("DefaultZones", newDataZone);
                accessServiceOptions.put("PublishZones", assetLookupZones);
                client.configureAccessServiceNoTopics("asset-owner", accessServiceOptions);
                client.configureAccessServiceNoTopics("data-manager", accessServiceOptions);
                client.configureAccessServiceNoTopics("asset-manager", accessServiceOptions);
                client.configureAccessServiceNoTopics("governance-program", accessServiceOptions);
                client.configureAccessServiceNoTopics("digital-architecture", accessServiceOptions);
                client.configureAccessServiceNoTopics("it-infrastructure", accessServiceOptions);
            }
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
        }
    }

    private void printAuditLogDestinations(OMAGServerConfigurationClient client) {
        try {
            List auditLogConnections = client.getOMAGServerConfig().getRepositoryServicesConfig().getAuditLogConnections();
            if (auditLogConnections == null) {
                System.out.println("Error: no audit log destinations");
            } else {
                System.out.println("Audit log destination are:");
                for (Connection connection : auditLogConnections) {
                    if (connection == null) continue;
                    System.out.print("| " + connection.getDisplayName() + " | ");
                    if (connection.getConfigurationProperties() != null) {
                        System.out.print("supported severities: " + connection.getConfigurationProperties().get("supportedSeverities"));
                    }
                    System.out.println(" | ");
                }
            }
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when printing audit log connections.  Error message is: " + error.getMessage());
        }
    }

    private void setSupportedAuditLogSeverities(List<String> supportedSeverities, Connection auditLogDestination) {
        if (supportedSeverities != null) {
            HashMap<String, List<String>> configurationProperties = auditLogDestination.getConfigurationProperties();
            if (configurationProperties == null) {
                configurationProperties = new HashMap<String, List<String>>();
            }
            configurationProperties.put("supportedSeverities", supportedSeverities);
            auditLogDestination.setConfigurationProperties(configurationProperties);
        }
    }

    private void logEventContents(String serverName, String connectorProviderClassName) {
        String egeriaConsoleAuditLogImplementation = "org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.console.ConsoleAuditLogStoreProvider";
        List<AuditLogRecordSeverityLevel> supportedSeverityDefinitions = Arrays.asList(AuditLogRecordSeverityLevel.values());
        ArrayList<String> consoleSupportedSeverities = new ArrayList<String>();
        for (AuditLogRecordSeverityLevel severityDefinition : supportedSeverityDefinitions) {
            if (AuditLogRecordSeverityLevel.EVENT.equals((Object)severityDefinition) || AuditLogRecordSeverityLevel.TRACE.equals((Object)severityDefinition) || AuditLogRecordSeverityLevel.PERFMON.equals((Object)severityDefinition)) continue;
            consoleSupportedSeverities.add(severityDefinition.getName());
        }
        try {
            OMAGServerConfigurationClient client = new OMAGServerConfigurationClient(this.clientUserId, serverName, this.platformURLRoot);
            List auditLogConnections = client.getOMAGServerConfig().getRepositoryServicesConfig().getAuditLogConnections();
            if (auditLogConnections != null) {
                for (Connection auditLogConnection : auditLogConnections) {
                    ConnectorType auditLogConnectorType;
                    if (auditLogConnection == null || (auditLogConnectorType = auditLogConnection.getConnectorType()) == null || !auditLogConnectorType.getConnectorProviderClassName().equals("org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.console.ConsoleAuditLogStoreProvider")) continue;
                    this.setSupportedAuditLogSeverities(consoleSupportedSeverities, auditLogConnection);
                    client.updateAuditLogDestination(auditLogConnection.getQualifiedName(), auditLogConnection);
                }
            }
            Connection eventDisplayConnection = new Connection();
            ConnectorType connectorType = new ConnectorType();
            if (connectorProviderClassName == null) {
                connectorType.setConnectorProviderClassName("org.odpi.openmetadata.devprojects.connectors.auditlog.eventdisplay.EventDisplayAuditLogStoreProvider");
            } else {
                connectorType.setConnectorProviderClassName(connectorProviderClassName);
            }
            eventDisplayConnection.setConnectorType(connectorType);
            eventDisplayConnection.setQualifiedName("Egeria:Sample:AuditLog:DisplayEventPayloadsOnConsole");
            eventDisplayConnection.setDisplayName("Display Event Payloads On Console Audit Log Destination");
            ArrayList<String> eventDisplaySupportedSeverities = new ArrayList<String>();
            eventDisplaySupportedSeverities.add(AuditLogRecordSeverityLevel.EVENT.getName());
            this.setSupportedAuditLogSeverities(eventDisplaySupportedSeverities, eventDisplayConnection);
            client.addAuditLogDestination(eventDisplayConnection);
            this.printAuditLogDestinations(client);
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when updating audit log connections.  Error message is: " + error.getMessage());
        }
    }

    private void createIntegrationDaemon(String serverName) {
        try {
            System.out.println("Configuring integration daemon: " + serverName);
            IntegrationDaemonConfigurationClient client = new IntegrationDaemonConfigurationClient(this.clientUserId, serverName, this.platformURLRoot);
            client.setServerDescription("Integration daemon called " + serverName + " running on platform " + this.platformURLRoot);
            client.setServerUserId(systemUserId);
            client.setServerType(null);
            client.setOrganizationName(organizationName);
            client.setMaxPageSize(600);
            this.setSecuritySecurityConnector((OMAGServerConfigurationClient)client);
            client.setDefaultAuditLog();
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
        }
    }

    private void addIntegrationConnector(String serverName, String metadataStoreName, String serviceURLMarker, String connectorProviderClassName, String networkAddress) {
        Connection connection = new Connection();
        ConnectorType connectorType = new ConnectorType();
        Endpoint endpoint = new Endpoint();
        connectorType.setConnectorProviderClassName(connectorProviderClassName);
        connection.setConnectorType(connectorType);
        if (networkAddress != null) {
            endpoint.setAddress(networkAddress);
            connection.setEndpoint(endpoint);
        }
        IntegrationConnectorConfig integrationConnectorConfig = new IntegrationConnectorConfig();
        integrationConnectorConfig.setConnectorId(UUID.randomUUID().toString());
        integrationConnectorConfig.setConnectorName("Integration Connector for " + connectorProviderClassName);
        integrationConnectorConfig.setConnectorUserId(systemUserId);
        integrationConnectorConfig.setConnection(connection);
        integrationConnectorConfig.setRefreshTimeInterval(1L);
        integrationConnectorConfig.setMetadataSourceQualifiedName("Egeria Catalog Thyself Demo");
        integrationConnectorConfig.setPermittedSynchronization(PermittedSynchronization.BOTH_DIRECTIONS);
        try {
            IntegrationDaemonConfigurationClient client = new IntegrationDaemonConfigurationClient(this.clientUserId, serverName, this.platformURLRoot);
            IntegrationServiceConfig serviceConfiguration = client.getIntegrationServiceConfiguration(serviceURLMarker);
            serviceConfiguration.setOMAGServerName(metadataStoreName);
            serviceConfiguration.setOMAGServerPlatformRootURL(this.platformURLRoot);
            serviceConfiguration.setDefaultPermittedSynchronization(PermittedSynchronization.BOTH_DIRECTIONS);
            ArrayList<IntegrationConnectorConfig> connectorList = serviceConfiguration.getIntegrationConnectorConfigs();
            if (connectorList == null) {
                connectorList = new ArrayList<IntegrationConnectorConfig>();
            }
            connectorList.add(integrationConnectorConfig);
            serviceConfiguration.setIntegrationConnectorConfigs(connectorList);
            client.configureIntegrationService(serviceConfiguration);
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
        }
    }

    private void addCohortMember(String serverName, String cohortName) {
        try {
            CohortMemberConfigurationClient client = new CohortMemberConfigurationClient(this.clientUserId, serverName, this.platformURLRoot);
            client.addCohortRegistration(cohortName, null);
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
        }
    }

    private void addStartupArchive(String serverName, String archiveFileName) {
        try {
            MetadataAccessStoreConfigurationClient client = new MetadataAccessStoreConfigurationClient(this.clientUserId, serverName, this.platformURLRoot);
            client.addStartUpOpenMetadataArchiveFile(archiveFileName);
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
        }
    }

    private void updateServerUserId(String serverName, String userId) {
        try {
            OMAGServerConfigurationClient client = new OMAGServerConfigurationClient(this.clientUserId, serverName, this.platformURLRoot);
            client.setServerUserId(userId);
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
        }
    }

    private void deleteServer(String serverName) {
        try {
            OMAGServerConfigurationClient client = new OMAGServerConfigurationClient(this.clientUserId, serverName, this.platformURLRoot);
            client.clearOMAGServerConfig();
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
        }
    }

    private void runCommand(String mode, String[] options) {
        if ("create-metadata-store".equals(mode)) {
            if (options.length > 0) {
                this.createMetadataStore(options[0]);
            } else {
                System.out.println("  Error: include a server name");
            }
        } else if ("create-integration-daemon".equals(mode)) {
            if (options.length > 0) {
                this.createIntegrationDaemon(options[0]);
            } else {
                System.out.println("  Error: include a server name for the integration daemon and the name of the metadata store that it is to connect to.");
            }
        } else if ("log-event-contents".equals(mode)) {
            if (options.length == 1) {
                this.logEventContents(options[0], "org.odpi.openmetadata.devprojects.connectors.auditlog.eventdisplay.EventDisplayAuditLogStoreProvider");
            } else if (options.length > 1) {
                this.logEventContents(options[0], options[1]);
            } else {
                System.out.println("  Error: include a server name");
            }
        } else if ("add-topic-connector".equals(mode)) {
            String serviceURLMarker = "topic-integrator";
            if (options.length == 2) {
                this.addIntegrationConnector(options[0], options[1], "topic-integrator", defaultTopicIntegrationConnectorProvider, eventBusURLRoot);
            } else if (options.length == 3) {
                this.addIntegrationConnector(options[0], options[1], "topic-integrator", options[2], null);
            } else if (options.length > 3) {
                this.addIntegrationConnector(options[0], options[1], "topic-integrator", options[2], options[3]);
            } else {
                System.out.println("  Error: include both integration daemon and metadata server name with 'add-topic-connector' request");
            }
        } else if ("add-api-connector".equals(mode)) {
            String serviceURLMarker = "api-integrator";
            if (options.length == 2) {
                this.addIntegrationConnector(options[0], options[1], "api-integrator", defaultAPIIntegrationConnectorProvider, null);
            } else if (options.length == 3) {
                this.addIntegrationConnector(options[0], options[1], "api-integrator", options[2], null);
            } else if (options.length > 3) {
                this.addIntegrationConnector(options[0], options[1], "api-integrator", options[2], options[3]);
            } else {
                System.out.println("  Error: include both integration daemon and metadata server name with 'add-api-connector' request");
            }
        } else if ("add-infra-connector".equals(mode)) {
            String serviceURLMarker = "infrastructure-integrator";
            if (options.length == 2) {
                this.addIntegrationConnector(options[0], options[1], "infrastructure-integrator", defaultInfraIntegrationConnectorProvider, null);
            } else if (options.length == 3) {
                this.addIntegrationConnector(options[0], options[1], "infrastructure-integrator", options[2], null);
            } else if (options.length > 3) {
                this.addIntegrationConnector(options[0], options[1], "infrastructure-integrator", options[2], options[3]);
            } else {
                System.out.println("  Error: include both integration daemon and metadata server name with 'add-infra-connector' request");
            }
        } else if ("add-cohort-member".equals(mode)) {
            if (options.length == 1) {
                this.addCohortMember(options[0], defaultCohort);
            } else if (options.length > 1) {
                this.addCohortMember(options[0], options[1]);
            } else {
                System.out.println("  Error: include a server name");
            }
        } else if ("add-startup-archive".equals(mode)) {
            if (options.length > 1) {
                this.addStartupArchive(options[0], options[1]);
            } else {
                System.out.println("  Error: include a server name and an archive file name");
            }
        } else if ("update-server-user-id".equals(mode)) {
            if (options.length > 1) {
                this.updateServerUserId(options[0], options[1]);
            } else {
                System.out.println("  Error: include a server name and new user id");
            }
        } else if ("delete-server".equals(mode)) {
            if (options.length > 0) {
                this.deleteServer(options[0]);
            } else {
                System.out.println("  Error: include a server name");
            }
        } else {
            System.out.println("  Error: use a valid command");
        }
    }

    public static void main(String[] args) {
        String interactiveMode = "interactive";
        String endInteractiveMode = "exit";
        String platformURLRoot = "https://localhost:9443";
        String clientUserId = "garygeeke";
        String mode = "interactive";
        if (args.length > 0) {
            platformURLRoot = args[0];
        }
        if (args.length > 1) {
            clientUserId = args[1];
        }
        if (args.length > 2) {
            mode = args[2];
        }
        System.out.println("==================================");
        System.out.println("OMAG Server Configuration Utility:    " + new Date().toString());
        System.out.println("==================================");
        System.out.print("Running against platform: " + platformURLRoot);
        ServerConfig utility = new ServerConfig(platformURLRoot, clientUserId);
        HttpHelper.noStrictSSL();
        String platformOrigin = utility.getPlatformOrigin();
        if (platformOrigin != null) {
            System.out.print(" - " + platformOrigin);
        } else {
            System.out.println();
            System.exit(-1);
        }
        System.out.println("Using userId: " + clientUserId);
        System.out.println();
        try {
            if ("interactive".equals(mode)) {
                while (!"exit".equals(mode)) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    System.out.println("Enter a command along with the server name and any optional parameters. Press enter to execute request.");
                    System.out.println("  - create-metadata-store     <serverName>  ");
                    System.out.println("  - create-integration-daemon <serverName>  ");
                    System.out.println("  - add-api-connector         <serverName> <metadataStoreServerName> <optionalConnectorProviderClassName> <optionalNetworkAddress>");
                    System.out.println("  - add-infra-connector       <serverName> <metadataStoreServerName> <optionalConnectorProviderClassName> <optionalNetworkAddress>");
                    System.out.println("  - add-topic-connector       <serverName> <metadataStoreServerName> <optionalConnectorProviderClassName> <optionalNetworkAddress>");
                    System.out.println("  - log-event-contents        <serverName> <optionalConnectorProviderClassName> ");
                    System.out.println("  - add-cohort-member         <serverName> <optionalCohortName> ");
                    System.out.println("  - add-startup-archive       <serverName> <archiveFileName> ");
                    System.out.println("  - update-server-user-id     <serverName> <newUserId> ");
                    System.out.println("  - delete-server             <serverName>  ");
                    System.out.println("  - exit  \n");
                    String command = br.readLine();
                    String[] commandWords = command.split(" ");
                    if (commandWords.length > 0) {
                        mode = commandWords[0];
                        if (commandWords.length > 1) {
                            utility.runCommand(mode, Arrays.copyOfRange(commandWords, 1, commandWords.length));
                        }
                    }
                    System.out.println();
                }
            } else {
                utility.runCommand(mode, Arrays.copyOfRange(args, 3, args.length));
            }
        }
        catch (Exception error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
        System.exit(0);
    }
}

