/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.auditlog;

import java.text.MessageFormat;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum ApacheAtlasOMRSAuditCode {
    REPOSITORY_SERVICE_STARTING("OMRS-ATLAS-REPOSITORY-0001", OMRSAuditLogRecordSeverity.INFO, "The Apache Atlas proxy is starting a new server instance", "The local server has started up a new instance of the Apache Atlas proxy.", "No action is required.  This is part of the normal operation of the service."),
    CONNECTING_TO_ATLAS("OMRS-ATLAS-REPOSITORY-0002", OMRSAuditLogRecordSeverity.INFO, "The Apache Atlas proxy is attempting to connect to Apache Atlas at {0}", "The local server is attempting to connect to the Apache Atlas server.", "No action is required.  This is part of the normal operation of the service."),
    CONNECTED_TO_ATLAS("OMRS-ATLAS-REPOSITORY-0003", OMRSAuditLogRecordSeverity.INFO, "The Apache Atlas proxy has successfully connected to Apache Atlas at {0}", "The local server has successfully connected to the Apache Atlas server.", "No action is required.  This is part of the normal operation of the service."),
    REPOSITORY_SERVICE_STARTED("OMRS-ATLAS-REPOSITORY-0004", OMRSAuditLogRecordSeverity.INFO, "The Apache Atlas proxy has started a new instance for server {0}", "The local server has completed startup of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    REPOSITORY_SERVICE_SHUTDOWN("OMRS-ATLAS-REPOSITORY-0005", OMRSAuditLogRecordSeverity.INFO, "The Apache Atlas proxy has shutdown its instance for server {0}", "The local server has requested shut down of an Apache Atlas proxy instance.", "No action is required.  This is part of the normal operation of the service."),
    EVENT_MAPPER_INITIALIZING("OMRS-ATLAS-REPOSITORY-0006", OMRSAuditLogRecordSeverity.INFO, "The Apache Atlas event mapper is initializing", "The local server has started up a new instance of the Apache Atlas event mapper.", "No action is required.  This is part of the normal operation of the service."),
    EVENT_MAPPER_INITIALIZED("OMRS-ATLAS-REPOSITORY-0007", OMRSAuditLogRecordSeverity.INFO, "The Apache Atlas event mapper has initialized for server {0}", "The local server has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    EVENT_MAPPER_SHUTDOWN("OMRS-ATLAS-REPOSITORY-0008", OMRSAuditLogRecordSeverity.INFO, "The Apache Atlas event mapper has shutdown its instance for server {0}", "The local server has requested shut down of an Apache Atlas event mapper instance.", "No action is required.  This is part of the normal operation of the service."),
    EVENT_MAPPER_STARTING("OMRS-ATLAS-REPOSITORY-0009", OMRSAuditLogRecordSeverity.INFO, "The Apache Atlas event mapper consumer thread is starting up", "The local server has requested startup of an Apache Atlas event mapper consumer.", "No action is required.  This is part of the normal operation of the service."),
    EVENT_MAPPER_RUNNING("OMRS-ATLAS-REPOSITORY-0010", OMRSAuditLogRecordSeverity.INFO, "The Apache Atlas event mapper is running", "The local server is now running a consumer thread for Apache Atlas.", "No action is required.  This is part of the normal operation of the service."),
    EVENT_MAPPER_CONSUMER_FAILURE("OMRS-ATLAS-REPOSITORY-0011", OMRSAuditLogRecordSeverity.EXCEPTION, "The Apache Atlas event mapper failed to consume an event", "The local server failed to consume an Apache Atlas event.", "Investigate the logs for additional information and raise a GitHub issue with the details.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private ApacheAtlasOMRSAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.logMessage);
        return mf.format(params);
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

