/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.apache.atlas.repositoryconnector;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.odpi.egeria.connectors.apache.atlas.auditlog.ApacheAtlasOMRSErrorCode;
import org.odpi.egeria.connectors.apache.atlas.eventmapper.ApacheAtlasOMRSRepositoryEventMapper;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.ApacheAtlasOMRSRepositoryConnector;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.AttributeMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.ClassificationDefMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.EntityMappingAtlas2OMRS;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.EnumDefMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.RelationshipDefMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.mapping.SequencingUtils;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.AttributeTypeDefStore;
import org.odpi.egeria.connectors.apache.atlas.repositoryconnector.stores.TypeDefStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ExternalStandardMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheAtlasOMRSMetadataCollection
extends OMRSMetadataCollectionBase {
    private static final Logger log = LoggerFactory.getLogger(ApacheAtlasOMRSMetadataCollection.class);
    private static final String GENERATED_TYPE_PREFIX = "__|";
    private static final String GENERATED_TYPE_POSTFIX = "|__";
    private final SimpleDateFormat ATLAS_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private ApacheAtlasOMRSRepositoryConnector atlasRepositoryConnector;
    private TypeDefStore typeDefStore;
    private AttributeTypeDefStore attributeTypeDefStore;
    private Set<InstanceStatus> availableStates;
    private ApacheAtlasOMRSRepositoryEventMapper eventMapper = null;

    public ApacheAtlasOMRSMetadataCollection(ApacheAtlasOMRSRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId) {
        super((OMRSRepositoryConnector)parentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId);
        parentConnector.setRepositoryName(repositoryName);
        this.atlasRepositoryConnector = parentConnector;
        this.typeDefStore = new TypeDefStore();
        this.attributeTypeDefStore = new AttributeTypeDefStore();
        this.availableStates = new HashSet<InstanceStatus>();
        this.availableStates.add(InstanceStatus.ACTIVE);
        this.availableStates.add(InstanceStatus.DELETED);
    }

    public TypeDefGallery getAllTypes(String userId) throws RepositoryErrorException, InvalidParameterException {
        String methodName = "getAllTypes";
        this.validateRepositoryConnector("getAllTypes");
        this.parentConnector.validateRepositoryIsActive("getAllTypes");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getAllTypes");
        TypeDefGallery typeDefGallery = new TypeDefGallery();
        List<TypeDef> typeDefs = this.typeDefStore.getAllTypeDefs();
        if (log.isDebugEnabled()) {
            log.debug("Retrieved {} implemented TypeDefs for this repository.", (Object)typeDefs.size());
        }
        typeDefGallery.setTypeDefs(typeDefs);
        List<AttributeTypeDef> attributeTypeDefs = this.attributeTypeDefStore.getAllAttributeTypeDefs();
        if (log.isDebugEnabled()) {
            log.debug("Retrieved {} implemented AttributeTypeDefs for this repository.", (Object)attributeTypeDefs.size());
        }
        typeDefGallery.setAttributeTypeDefs(attributeTypeDefs);
        return typeDefGallery;
    }

    public List<TypeDef> findTypeDefsByCategory(String userId, TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByCategory";
        String categoryParameterName = "category";
        this.validateRepositoryConnector("findTypeDefsByCategory");
        this.parentConnector.validateRepositoryIsActive("findTypeDefsByCategory");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findTypeDefsByCategory");
        this.repositoryValidator.validateTypeDefCategory(this.repositoryName, "category", category, "findTypeDefsByCategory");
        ArrayList<TypeDef> typeDefs = new ArrayList<TypeDef>();
        for (TypeDef candidate : this.typeDefStore.getAllTypeDefs()) {
            if (!candidate.getCategory().equals((Object)category)) continue;
            typeDefs.add(candidate);
        }
        return typeDefs;
    }

    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findAttributeTypeDefsByCategory";
        String categoryParameterName = "category";
        this.validateRepositoryConnector("findAttributeTypeDefsByCategory");
        this.parentConnector.validateRepositoryIsActive("findAttributeTypeDefsByCategory");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findAttributeTypeDefsByCategory");
        this.repositoryValidator.validateAttributeTypeDefCategory(this.repositoryName, "category", category, "findAttributeTypeDefsByCategory");
        ArrayList<AttributeTypeDef> typeDefs = new ArrayList<AttributeTypeDef>();
        for (AttributeTypeDef candidate : this.attributeTypeDefStore.getAllAttributeTypeDefs()) {
            if (!candidate.getCategory().equals((Object)category)) continue;
            typeDefs.add(candidate);
        }
        return typeDefs;
    }

    public List<TypeDef> findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        this.validateRepositoryConnector("findTypeDefsByProperty");
        this.parentConnector.validateRepositoryIsActive("findTypeDefsByProperty");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findTypeDefsByProperty");
        this.repositoryValidator.validateMatchCriteria(this.repositoryName, "matchCriteria", matchCriteria, "findTypeDefsByProperty");
        List<TypeDef> typeDefs = this.typeDefStore.getAllTypeDefs();
        List<TypeDef> results = new ArrayList<TypeDef>();
        if (matchCriteria != null) {
            Map properties = matchCriteria.getTypeDefProperties();
            for (TypeDef candidate : typeDefs) {
                List candidateProperties = candidate.getPropertiesDefinition();
                for (TypeDefAttribute candidateAttribute : candidateProperties) {
                    String candidateName = candidateAttribute.getAttributeName();
                    if (!properties.containsKey(candidateName)) continue;
                    results.add(candidate);
                }
            }
            results = typeDefs;
        }
        return results;
    }

    public List<TypeDef> findTypesByExternalID(String userId, String standard, String organization, String identifier) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        ArrayList<TypeDef> results;
        String methodName = "findTypesByExternalID";
        this.validateRepositoryConnector("findTypesByExternalID");
        this.parentConnector.validateRepositoryIsActive("findTypesByExternalID");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findTypesByExternalID");
        this.repositoryValidator.validateExternalId(this.repositoryName, standard, organization, identifier, "findTypesByExternalID");
        List<TypeDef> typeDefs = this.typeDefStore.getAllTypeDefs();
        if (standard == null && organization == null && identifier == null) {
            results = typeDefs;
        } else {
            results = new ArrayList();
            for (TypeDef typeDef : typeDefs) {
                List externalStandardMappings = typeDef.getExternalStandardMappings();
                for (ExternalStandardMapping externalStandardMapping : externalStandardMappings) {
                    String candidateStandard = externalStandardMapping.getStandardName();
                    String candidateOrg = externalStandardMapping.getStandardOrganization();
                    String candidateId = externalStandardMapping.getStandardTypeName();
                    if (standard != null && !standard.equals(candidateStandard) || organization != null && !organization.equals(candidateOrg) || identifier != null && !identifier.equals(candidateId)) continue;
                    results.add(typeDef);
                }
            }
        }
        return results;
    }

    public List<TypeDef> searchForTypeDefs(String userId, String searchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "searchForTypeDefs";
        String searchCriteriaParameterName = "searchCriteria";
        this.validateRepositoryConnector("searchForTypeDefs");
        this.parentConnector.validateRepositoryIsActive("searchForTypeDefs");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "searchForTypeDefs");
        this.repositoryValidator.validateSearchCriteria(this.repositoryName, "searchCriteria", searchCriteria, "searchForTypeDefs");
        ArrayList<TypeDef> typeDefs = new ArrayList<TypeDef>();
        for (TypeDef candidate : this.typeDefStore.getAllTypeDefs()) {
            if (!candidate.getName().matches(searchCriteria)) continue;
            typeDefs.add(candidate);
        }
        return typeDefs;
    }

    public TypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByGUID";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("getTypeDefByGUID");
        this.parentConnector.validateRepositoryIsActive("getTypeDefByGUID");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getTypeDefByGUID");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "getTypeDefByGUID");
        TypeDef found = this.typeDefStore.getTypeDefByGUID(guid);
        if (found == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_ID_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, "guid", "getTypeDefByGUID", this.repositoryName});
            throw new TypeDefNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getTypeDefByGUID", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return found;
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByGUID";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("getAttributeTypeDefByGUID");
        this.parentConnector.validateRepositoryIsActive("getAttributeTypeDefByGUID");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getAttributeTypeDefByGUID");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "getAttributeTypeDefByGUID");
        AttributeTypeDef found = this.attributeTypeDefStore.getAttributeTypeDefByGUID(guid);
        if (found == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.ATTRIBUTE_TYPEDEF_ID_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"unknown", guid, "getAttributeTypeDefByGUID", this.repositoryName});
            throw new TypeDefNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getAttributeTypeDefByGUID", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return found;
    }

    public TypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByName";
        String nameParameterName = "name";
        this.validateRepositoryConnector("getTypeDefByName");
        this.parentConnector.validateRepositoryIsActive("getTypeDefByName");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getTypeDefByName");
        this.repositoryValidator.validateTypeName(this.repositoryName, "name", name, "getTypeDefByName");
        TypeDef found = this.typeDefStore.getTypeDefByName(name);
        if (found == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_NAME_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "getTypeDefByName", this.repositoryName});
            throw new TypeDefNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getTypeDefByName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return found;
    }

    public AttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByName";
        String nameParameterName = "name";
        this.validateRepositoryConnector("getAttributeTypeDefByName");
        this.parentConnector.validateRepositoryIsActive("getAttributeTypeDefByName");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getAttributeTypeDefByName");
        this.repositoryValidator.validateTypeName(this.repositoryName, "name", name, "getAttributeTypeDefByName");
        AttributeTypeDef found = this.attributeTypeDefStore.getAttributeTypeDefByName(name);
        if (found == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.ATTRIBUTE_TYPEDEF_NAME_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, "getAttributeTypeDefByName", this.repositoryName});
            throw new TypeDefNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getAttributeTypeDefByName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return found;
    }

    public void addTypeDef(String userId, TypeDef newTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        block6: {
            String omrsTypeDefName;
            block7: {
                block8: {
                    block5: {
                        String methodName = "addTypeDef";
                        String typeDefParameterName = "newTypeDef";
                        this.validateRepositoryConnector("addTypeDef");
                        this.parentConnector.validateRepositoryIsActive("addTypeDef");
                        this.repositoryValidator.validateUserId(this.repositoryName, userId, "addTypeDef");
                        this.repositoryValidator.validateTypeDef(this.repositoryName, "newTypeDef", newTypeDef, "addTypeDef");
                        this.repositoryValidator.validateUnknownTypeDef(this.repositoryName, "newTypeDef", newTypeDef, "addTypeDef");
                        TypeDefCategory typeDefCategory = newTypeDef.getCategory();
                        omrsTypeDefName = newTypeDef.getName();
                        if (log.isDebugEnabled()) {
                            log.debug("Looking for mapping for {} of type {}", (Object)omrsTypeDefName, (Object)typeDefCategory.getName());
                        }
                        if (!this.typeDefStore.isTypeDefMapped(omrsTypeDefName)) break block5;
                        this.typeDefStore.addTypeDef(newTypeDef);
                        break block6;
                    }
                    if (this.typeDefStore.isReserved(omrsTypeDefName)) break block7;
                    if (!this.atlasRepositoryConnector.typeDefExistsByName(omrsTypeDefName)) break block8;
                    this.typeDefStore.addTypeDef(newTypeDef);
                    break block6;
                }
                switch (newTypeDef.getCategory()) {
                    case RELATIONSHIP_DEF: {
                        RelationshipDefMapping.addRelationshipTypeToAtlas((RelationshipDef)newTypeDef, this.typeDefStore, this.attributeTypeDefStore, this.atlasRepositoryConnector);
                        break block6;
                    }
                    case CLASSIFICATION_DEF: {
                        ClassificationDefMapping.addClassificationTypeToAtlas((ClassificationDef)newTypeDef, this.typeDefStore, this.attributeTypeDefStore, this.atlasRepositoryConnector);
                        break block6;
                    }
                    default: {
                        this.typeDefStore.addUnimplementedTypeDef(newTypeDef);
                        throw new TypeDefNotSupportedException(404, ApacheAtlasOMRSMetadataCollection.class.getName(), "addTypeDef", omrsTypeDefName + " is not supported.", "", "Request support through Egeria GitHub issue.");
                    }
                }
            }
            this.typeDefStore.addUnimplementedTypeDef(newTypeDef);
            throw new TypeDefNotSupportedException(404, ApacheAtlasOMRSMetadataCollection.class.getName(), "addTypeDef", omrsTypeDefName + " is not supported.", "", "Request support through Egeria GitHub issue.");
        }
        this.checkEventMapperIsConfigured("addTypeDef");
        this.eventMapper.sendNewTypeDefEvent(newTypeDef);
    }

    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "addAttributeTypeDef";
        String typeDefParameterName = "newAttributeTypeDef";
        this.validateRepositoryConnector("addAttributeTypeDef");
        this.parentConnector.validateRepositoryIsActive("addAttributeTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "addAttributeTypeDef");
        this.repositoryValidator.validateAttributeTypeDef(this.repositoryName, "newAttributeTypeDef", newAttributeTypeDef, "addAttributeTypeDef");
        this.repositoryValidator.validateUnknownAttributeTypeDef(this.repositoryName, "newAttributeTypeDef", newAttributeTypeDef, "addAttributeTypeDef");
        AttributeTypeDefCategory attributeTypeDefCategory = newAttributeTypeDef.getCategory();
        String omrsTypeDefName = newAttributeTypeDef.getName();
        if (log.isDebugEnabled()) {
            log.debug("Looking for mapping for {} of type {}", (Object)omrsTypeDefName, (Object)attributeTypeDefCategory.getName());
        }
        if (this.attributeTypeDefStore.isTypeDefMapped(omrsTypeDefName)) {
            this.attributeTypeDefStore.addTypeDef(newAttributeTypeDef);
        } else if (newAttributeTypeDef.getCategory().equals((Object)AttributeTypeDefCategory.ENUM_DEF)) {
            if (this.atlasRepositoryConnector.typeDefExistsByName(omrsTypeDefName)) {
                this.attributeTypeDefStore.addTypeDef(newAttributeTypeDef);
            } else {
                EnumDefMapping.addEnumToAtlas((EnumDef)newAttributeTypeDef, this.attributeTypeDefStore, this.atlasRepositoryConnector);
            }
        } else {
            this.attributeTypeDefStore.addUnimplementedTypeDef(newAttributeTypeDef);
            throw new TypeDefNotSupportedException(404, ApacheAtlasOMRSMetadataCollection.class.getName(), "addAttributeTypeDef", omrsTypeDefName + " is not supported.", "", "Request support through Egeria GitHub issue.");
        }
        this.checkEventMapperIsConfigured("addAttributeTypeDef");
        this.eventMapper.sendNewAttributeTypeDefEvent(newAttributeTypeDef);
    }

    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyTypeDef";
        String typeDefParameterName = "typeDef";
        this.validateRepositoryConnector("verifyTypeDef");
        this.parentConnector.validateRepositoryIsActive("verifyTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "verifyTypeDef");
        this.repositoryValidator.validateTypeDef(this.repositoryName, "typeDef", typeDef, "verifyTypeDef");
        String guid = typeDef.getGUID();
        if (this.typeDefStore.getUnimplementedTypeDefByGUID(guid) != null) {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeDef.getName(), guid, "typeDef", "verifyTypeDef", this.repositoryName});
            throw new TypeDefNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "verifyTypeDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (this.typeDefStore.getTypeDefByGUID(guid) != null) {
            ArrayList issues = new ArrayList();
            boolean bVerified = true;
            if (!bVerified) {
                if (log.isWarnEnabled()) {
                    log.warn("TypeDef '{}' cannot be supported due to conflicts: {}", (Object)typeDef.getName(), (Object)String.join((CharSequence)", ", issues));
                }
                OMRSErrorCode errorCode = OMRSErrorCode.VERIFY_CONFLICT_DETECTED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, "verifyTypeDef", this.repositoryName});
                throw new TypeDefConflictException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "verifyTypeDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            return true;
        }
        return false;
    }

    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        boolean bImplemented;
        String methodName = "verifyAttributeTypeDef";
        String typeDefParameterName = "attributeTypeDef";
        this.validateRepositoryConnector("verifyAttributeTypeDef");
        this.parentConnector.validateRepositoryIsActive("verifyAttributeTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "verifyAttributeTypeDef");
        this.repositoryValidator.validateAttributeTypeDef(this.repositoryName, "attributeTypeDef", attributeTypeDef, "verifyAttributeTypeDef");
        switch (attributeTypeDef.getCategory()) {
            case PRIMITIVE: 
            case COLLECTION: {
                bImplemented = true;
                break;
            }
            case ENUM_DEF: {
                bImplemented = this.attributeTypeDefStore.isTypeDefMapped(attributeTypeDef.getName());
                break;
            }
            default: {
                bImplemented = false;
            }
        }
        return bImplemented;
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        EntityDetail detail;
        block2: {
            String methodName = "isEntityKnown";
            String guidParameterName = "guid";
            this.validateRepositoryConnector("isEntityKnown");
            this.parentConnector.validateRepositoryIsActive("isEntityKnown");
            this.repositoryValidator.validateUserId(this.repositoryName, userId, "isEntityKnown");
            this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "isEntityKnown");
            detail = null;
            try {
                detail = this.getEntityDetail(userId, guid);
            }
            catch (EntityNotKnownException e) {
                if (!log.isInfoEnabled()) break block2;
                log.info("Entity {} not known to the repository, or only a proxy.", (Object)guid, (Object)e);
            }
        }
        return detail;
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "getEntitySummary";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("getEntitySummary");
        this.parentConnector.validateRepositoryIsActive("getEntitySummary");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getEntitySummary");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "getEntitySummary");
        String prefix = null;
        if (ApacheAtlasOMRSMetadataCollection.isGeneratedGUID(guid)) {
            prefix = ApacheAtlasOMRSMetadataCollection.getPrefixFromGeneratedId(guid);
            guid = ApacheAtlasOMRSMetadataCollection.getGuidFromGeneratedId(guid);
        }
        AtlasEntity.AtlasEntityWithExtInfo entity = null;
        try {
            entity = this.atlasRepositoryConnector.getEntityByGUID(guid, false, true);
        }
        catch (AtlasServiceException e) {
            this.raiseEntityNotKnownException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, "getEntitySummary", e, guid, "getEntitySummary", this.repositoryName);
        }
        if (entity == null) {
            this.raiseEntityNotKnownException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, "getEntitySummary", null, guid, "getEntitySummary", this.repositoryName);
        }
        EntityMappingAtlas2OMRS mapping = new EntityMappingAtlas2OMRS(this.atlasRepositoryConnector, this.typeDefStore, this.attributeTypeDefStore, entity, prefix, userId);
        return mapping.getEntitySummary();
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("getEntityDetail");
        this.parentConnector.validateRepositoryIsActive("getEntityDetail");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getEntityDetail");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "getEntityDetail");
        String prefix = null;
        if (ApacheAtlasOMRSMetadataCollection.isGeneratedGUID(guid)) {
            prefix = ApacheAtlasOMRSMetadataCollection.getPrefixFromGeneratedId(guid);
            guid = ApacheAtlasOMRSMetadataCollection.getGuidFromGeneratedId(guid);
        }
        AtlasEntity.AtlasEntityWithExtInfo entity = null;
        try {
            entity = this.atlasRepositoryConnector.getEntityByGUID(guid, false, true);
        }
        catch (AtlasServiceException e) {
            this.raiseEntityNotKnownException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, "getEntityDetail", e, guid, "getEntityDetail", this.repositoryName);
        }
        if (entity == null) {
            this.raiseEntityNotKnownException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, "getEntityDetail", null, guid, "getEntityDetail", this.repositoryName);
        }
        EntityMappingAtlas2OMRS mapping = new EntityMappingAtlas2OMRS(this.atlasRepositoryConnector, this.typeDefStore, this.attributeTypeDefStore, entity, prefix, userId);
        return mapping.getEntityDetail();
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationshipsForEntity";
        this.getRelationshipsForEntityParameterValidation(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<Relationship> alRelationships = null;
        if (asOfTime != null) {
            ApacheAtlasOMRSErrorCode errorCode = ApacheAtlasOMRSErrorCode.NO_HISTORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.repositoryName);
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getRelationshipsForEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (limitResultsByStatus == null || limitResultsByStatus.size() == 1 && limitResultsByStatus.contains(InstanceStatus.ACTIVE)) {
            String prefix = null;
            if (ApacheAtlasOMRSMetadataCollection.isGeneratedGUID(entityGUID)) {
                prefix = ApacheAtlasOMRSMetadataCollection.getPrefixFromGeneratedId(entityGUID);
                entityGUID = ApacheAtlasOMRSMetadataCollection.getGuidFromGeneratedId(entityGUID);
            }
            AtlasEntity.AtlasEntityWithExtInfo asset = null;
            try {
                asset = this.atlasRepositoryConnector.getEntityByGUID(entityGUID, false, false);
            }
            catch (AtlasServiceException e) {
                this.raiseEntityNotKnownException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, "getRelationshipsForEntity", e, entityGUID, "getRelationshipsForEntity", this.repositoryName);
            }
            if (asset == null) {
                this.raiseEntityNotKnownException(ApacheAtlasOMRSErrorCode.ENTITY_NOT_KNOWN, "getRelationshipsForEntity", null, entityGUID, "getRelationshipsForEntity", this.repositoryName);
            } else {
                EntityMappingAtlas2OMRS entityMap = new EntityMappingAtlas2OMRS(this.atlasRepositoryConnector, this.typeDefStore, this.attributeTypeDefStore, asset, prefix, userId);
                alRelationships = entityMap.getRelationships(relationshipTypeGUID, fromRelationshipElement, sequencingProperty, sequencingOrder, pageSize);
            }
        }
        return alRelationships;
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByProperty";
        this.findEntitiesByPropertyParameterValidation(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (asOfTime != null) {
            ApacheAtlasOMRSErrorCode errorCode = ApacheAtlasOMRSErrorCode.NO_HISTORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.repositoryName);
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findEntitiesByProperty", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        List<AtlasEntityHeader> results = sequencingOrder != null || limitResultsByClassification != null && limitResultsByClassification.size() > 1 ? this.buildAndRunDSLSearch("findEntitiesByProperty", entityTypeGUID, limitResultsByClassification, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, sequencingProperty, sequencingOrder, pageSize) : this.buildAndRunBasicSearch("findEntitiesByProperty", entityTypeGUID, limitResultsByClassification == null ? null : limitResultsByClassification.get(0), matchProperties, matchCriteria, null, fromEntityElement, limitResultsByStatus, pageSize);
        List<EntityDetail> entityDetails = null;
        if (results != null) {
            entityDetails = this.sortAndLimitFinalResults(results, entityTypeGUID, fromEntityElement, sequencingProperty, sequencingOrder, pageSize, userId);
        }
        return entityDetails == null || entityDetails.isEmpty() ? null : entityDetails;
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchClassificationCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        List<AtlasEntityHeader> results;
        String methodName = "findEntitiesByClassification";
        this.findEntitiesByClassificationParameterValidation(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchClassificationCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (asOfTime != null) {
            ApacheAtlasOMRSErrorCode errorCode = ApacheAtlasOMRSErrorCode.NO_HISTORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.repositoryName);
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findEntitiesByClassification", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (sequencingOrder != null) {
            ArrayList<String> limitResultsByClassification = new ArrayList<String>();
            limitResultsByClassification.add(classificationName);
            results = this.buildAndRunDSLSearch("findEntitiesByClassification", entityTypeGUID, limitResultsByClassification, null, matchClassificationCriteria, fromEntityElement, limitResultsByStatus, sequencingProperty, sequencingOrder, matchClassificationProperties == null ? pageSize : pageSize * 2);
        } else {
            results = this.buildAndRunBasicSearch("findEntitiesByClassification", entityTypeGUID, classificationName, null, matchClassificationCriteria, null, fromEntityElement, limitResultsByStatus, matchClassificationProperties == null ? pageSize : pageSize * 2);
        }
        List<Object> atlasEntities = new ArrayList();
        if (results != null && matchClassificationProperties != null) {
            Map propertiesToMatch = matchClassificationProperties.getInstanceProperties();
            if (results != null) {
                for (AtlasEntityHeader candidateEntity : results) {
                    List classificationsForEntity = candidateEntity.getClassifications();
                    for (AtlasClassification candidateClassification : classificationsForEntity) {
                        if (!candidateClassification.getTypeName().equals(classificationName)) continue;
                        boolean bMatchesAny = false;
                        boolean bMatchesAll = true;
                        for (Map.Entry propertyToMatch : propertiesToMatch.entrySet()) {
                            String propertyName = (String)propertyToMatch.getKey();
                            InstancePropertyValue omrsPropertyValueToMatch = (InstancePropertyValue)propertyToMatch.getValue();
                            Object atlasClassificationValue = candidateClassification.getAttribute(propertyName);
                            boolean bMatchesThisOne = AttributeMapping.valuesMatch(omrsPropertyValueToMatch, atlasClassificationValue);
                            bMatchesAll = bMatchesAll && bMatchesThisOne;
                            bMatchesAny = bMatchesAny || bMatchesThisOne;
                        }
                        if (matchClassificationCriteria != null) {
                            switch (matchClassificationCriteria) {
                                case NONE: {
                                    if (bMatchesAny) break;
                                    atlasEntities.add(candidateEntity);
                                    break;
                                }
                                case ALL: {
                                    if (!bMatchesAll) break;
                                    atlasEntities.add(candidateEntity);
                                    break;
                                }
                                case ANY: {
                                    if (!bMatchesAny) break;
                                    atlasEntities.add(candidateEntity);
                                }
                            }
                            continue;
                        }
                        if (bMatchesAll) {
                            atlasEntities.add(candidateEntity);
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Unable to match properties '{}' for entity, dropping from results: {}", (Object)matchClassificationProperties, (Object)candidateEntity);
                    }
                }
            }
            int endOfPageMarker = Math.min(fromEntityElement + pageSize, atlasEntities.size());
            if (fromEntityElement != 0 || endOfPageMarker < atlasEntities.size()) {
                atlasEntities = atlasEntities.subList(fromEntityElement, endOfPageMarker);
            }
        } else if (results != null) {
            atlasEntities = results;
        }
        List<EntityDetail> entityDetails = this.sortAndLimitFinalResults(atlasEntities, entityTypeGUID, fromEntityElement, sequencingProperty, sequencingOrder, pageSize, userId);
        return entityDetails == null || entityDetails.isEmpty() ? null : entityDetails;
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        List<AtlasEntityHeader> results;
        String methodName = "findEntitiesByPropertyValue";
        this.findEntitiesByPropertyValueParameterValidation(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        if (asOfTime != null) {
            ApacheAtlasOMRSErrorCode errorCode = ApacheAtlasOMRSErrorCode.NO_HISTORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.repositoryName);
            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "findEntitiesByPropertyValue", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        InstanceProperties matchProperties = null;
        if (searchCriteria == null || searchCriteria.equals("")) {
            results = sequencingOrder != null || limitResultsByClassification != null && limitResultsByClassification.size() > 1 ? this.buildAndRunDSLSearch("findEntitiesByPropertyValue", entityTypeGUID, limitResultsByClassification, null, null, fromEntityElement, limitResultsByStatus, sequencingProperty, sequencingOrder, pageSize) : this.buildAndRunBasicSearch("findEntitiesByPropertyValue", entityTypeGUID, limitResultsByClassification == null ? null : limitResultsByClassification.get(0), null, null, null, fromEntityElement, limitResultsByStatus, pageSize);
        } else if (this.repositoryHelper.isContainsRegex(searchCriteria) && sequencingOrder == null && (limitResultsByClassification == null || limitResultsByClassification.size() == 1)) {
            results = this.buildAndRunBasicSearch("findEntitiesByPropertyValue", entityTypeGUID, limitResultsByClassification == null ? null : limitResultsByClassification.get(0), null, null, searchCriteria, fromEntityElement, limitResultsByStatus, pageSize);
        } else {
            Map<String, TypeDefAttribute> typeDefAttributeMap;
            matchProperties = new InstanceProperties();
            String omrsTypeName = "Referenceable";
            if (entityTypeGUID != null) {
                TypeDef typeDef = this.typeDefStore.getTypeDefByGUID(entityTypeGUID);
                omrsTypeName = typeDef.getName();
            }
            if ((typeDefAttributeMap = this.typeDefStore.getAllTypeDefAttributesForName(omrsTypeName)) != null) {
                for (Map.Entry<String, TypeDefAttribute> attributeEntry : typeDefAttributeMap.entrySet()) {
                    String attributeName = attributeEntry.getKey();
                    TypeDefAttribute typeDefAttribute = attributeEntry.getValue();
                    AttributeTypeDef attributeTypeDef = typeDefAttribute.getAttributeType();
                    if (attributeTypeDef.getCategory().equals((Object)AttributeTypeDefCategory.PRIMITIVE)) {
                        PrimitiveDefCategory primitiveDefCategory = ((PrimitiveDef)attributeTypeDef).getPrimitiveDefCategory();
                        if (primitiveDefCategory.equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING) || primitiveDefCategory.equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE) || primitiveDefCategory.equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR)) {
                            matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.repositoryName, matchProperties, attributeName, searchCriteria, "findEntitiesByPropertyValue");
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Skipping inclusion of non-string attribute: {}", (Object)attributeName);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Skipping inclusion of non-string attribute: {}", (Object)attributeName);
                }
            }
            results = sequencingOrder != null || limitResultsByClassification != null && limitResultsByClassification.size() > 1 ? this.buildAndRunDSLSearch("findEntitiesByPropertyValue", entityTypeGUID, limitResultsByClassification, matchProperties, MatchCriteria.ANY, fromEntityElement, limitResultsByStatus, sequencingProperty, sequencingOrder, pageSize) : this.buildAndRunBasicSearch("findEntitiesByPropertyValue", entityTypeGUID, limitResultsByClassification == null ? null : limitResultsByClassification.get(0), matchProperties, MatchCriteria.ANY, null, fromEntityElement, limitResultsByStatus, pageSize);
        }
        List<EntityDetail> entityDetails = null;
        if (results != null) {
            entityDetails = this.sortAndLimitFinalResults(results, entityTypeGUID, fromEntityElement, sequencingProperty, sequencingOrder, pageSize, userId);
        }
        return entityDetails == null || entityDetails.isEmpty() ? null : entityDetails;
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        Relationship relationship;
        block2: {
            String methodName = "isRelationshipKnown";
            this.getInstanceParameterValidation(userId, guid, "isRelationshipKnown");
            relationship = null;
            try {
                relationship = this.getRelationship(userId, guid);
            }
            catch (RelationshipNotKnownException e) {
                if (!log.isInfoEnabled()) break block2;
                log.info("Relationship {} not known to the repository.", (Object)guid, (Object)e);
            }
        }
        return relationship;
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        this.getInstanceParameterValidation(userId, guid, "getRelationship");
        AtlasRelationship.AtlasRelationshipWithExtInfo relationship = null;
        try {
            relationship = this.atlasRepositoryConnector.getRelationshipByGUID(guid);
        }
        catch (AtlasServiceException e) {
            this.raiseRelationshipNotKnownException(ApacheAtlasOMRSErrorCode.RELATIONSHIP_NOT_KNOWN, "getRelationship", e, guid, "getRelationship", this.repositoryName);
        }
        if (relationship == null) {
            this.raiseRelationshipNotKnownException(ApacheAtlasOMRSErrorCode.RELATIONSHIP_NOT_KNOWN, "getRelationship", null, guid, "getRelationship", this.repositoryName);
        }
        RelationshipMapping mapping = new RelationshipMapping(this.atlasRepositoryConnector, this.typeDefStore, this.attributeTypeDefStore, relationship, userId);
        return mapping.getRelationship();
    }

    public void refreshEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, HomeEntityException, UserNotAuthorizedException {
        String methodName = "refreshEntityReferenceCopy";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, entityGUID, typeDefGUID, typeDefName, "entityGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "refreshEntityReferenceCopy");
        EntityDetail entity = this.isEntityKnown(userId, entityGUID);
        if (entity != null && this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
            OMRSErrorCode errorCode = OMRSErrorCode.HOME_REFRESH;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"refreshEntityReferenceCopy", entityGUID, this.metadataCollectionId, this.repositoryName});
            throw new HomeEntityException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "refreshEntityReferenceCopy", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.checkEventMapperIsConfigured("refreshEntityReferenceCopy");
        this.eventMapper.sendRefreshEntityRequest(typeDefGUID, typeDefName, entityGUID, homeMetadataCollectionId);
    }

    public void refreshRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, HomeRelationshipException, UserNotAuthorizedException {
        String methodName = "refreshRelationshipReferenceCopy";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, relationshipGUID, typeDefGUID, typeDefName, "relationshipGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "refreshRelationshipReferenceCopy");
        Relationship relationship = this.isRelationshipKnown(userId, relationshipGUID);
        if (relationship != null && this.metadataCollectionId.equals(relationship.getMetadataCollectionId())) {
            OMRSErrorCode errorCode = OMRSErrorCode.HOME_REFRESH;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"refreshRelationshipReferenceCopy", relationshipGUID, this.metadataCollectionId, this.repositoryName});
            throw new HomeRelationshipException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "refreshRelationshipReferenceCopy", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.checkEventMapperIsConfigured("refreshRelationshipReferenceCopy");
        this.eventMapper.sendRefreshRelationshipRequest(typeDefGUID, typeDefName, relationshipGUID, homeMetadataCollectionId);
    }

    public void setEventMapper(ApacheAtlasOMRSRepositoryEventMapper eventMapper) {
        this.eventMapper = eventMapper;
    }

    public TypeDefStore getTypeDefStore() {
        return this.typeDefStore;
    }

    public AttributeTypeDefStore getAttributeTypeDefStore() {
        return this.attributeTypeDefStore;
    }

    public Set<InstanceStatus> getAvailableStates() {
        return this.availableStates;
    }

    private void checkEventMapperIsConfigured(String methodName) throws RepositoryErrorException {
        if (this.eventMapper == null) {
            ApacheAtlasOMRSErrorCode errorCode = ApacheAtlasOMRSErrorCode.EVENT_MAPPER_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.repositoryName);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private List<AtlasEntityHeader> buildAndRunDSLSearch(String methodName, String entityTypeGUID, List<String> limitResultsByClassification, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws FunctionNotSupportedException, RepositoryErrorException {
        StringBuilder sb = new StringBuilder();
        String omrsTypeName = "Referenceable";
        Map<Object, String> atlasTypeNamesByPrefix = new HashMap();
        if (entityTypeGUID != null) {
            TypeDef typeDef = this.typeDefStore.getTypeDefByGUID(entityTypeGUID);
            if (typeDef != null) {
                omrsTypeName = typeDef.getName();
                atlasTypeNamesByPrefix = this.typeDefStore.getAllMappedAtlasTypeDefNames(omrsTypeName);
            } else if (log.isWarnEnabled()) {
                log.warn("Unable to search for type, unknown to repository: {}", (Object)entityTypeGUID);
            }
        } else {
            atlasTypeNamesByPrefix.put(null, omrsTypeName);
        }
        ArrayList<AtlasSearchResult> totalResults = new ArrayList<AtlasSearchResult>();
        for (Map.Entry entry : atlasTypeNamesByPrefix.entrySet()) {
            String prefix = (String)entry.getKey();
            String atlasTypeName = (String)entry.getValue();
            Map<String, String> omrsPropertyMap = this.typeDefStore.getPropertyMappingsForOMRSTypeDef(omrsTypeName, prefix);
            sb.append("from ");
            sb.append(atlasTypeName);
            boolean bWhereClauseAdded = false;
            if (limitResultsByClassification != null) {
                ArrayList<String> classifications = new ArrayList<String>();
                for (String classificationName : limitResultsByClassification) {
                    classifications.add(atlasTypeName + " isa " + classificationName);
                }
                if (!classifications.isEmpty()) {
                    sb.append(" where ");
                    sb.append(String.join((CharSequence)" and ", classifications));
                    bWhereClauseAdded = true;
                }
            }
            if (matchProperties != null) {
                ArrayList propertyCriteria = new ArrayList();
                Map properties = matchProperties.getInstanceProperties();
                Map<String, TypeDefAttribute> omrsAttrTypeDefs = this.typeDefStore.getAllTypeDefAttributesForName(omrsTypeName);
                if (properties != null) {
                    for (Map.Entry property : properties.entrySet()) {
                        String omrsPropertyName = (String)property.getKey();
                        InstancePropertyValue value = (InstancePropertyValue)property.getValue();
                        this.addSearchConditionFromValue(propertyCriteria, omrsPropertyName, value, omrsPropertyMap, omrsAttrTypeDefs, matchCriteria != null && matchCriteria.equals((Object)MatchCriteria.NONE), true);
                    }
                }
                if (!propertyCriteria.isEmpty()) {
                    String propertyMatchDelim = " and ";
                    if (matchCriteria != null && matchCriteria.equals((Object)MatchCriteria.ANY)) {
                        propertyMatchDelim = " or ";
                    }
                    if (!bWhereClauseAdded) {
                        sb.append(" where");
                    }
                    sb.append(" ");
                    sb.append(String.join((CharSequence)propertyMatchDelim, propertyCriteria));
                }
            }
            if (limitResultsByStatus != null) {
                ArrayList<String> states = new ArrayList<String>();
                HashSet<InstanceStatus> limitSet = new HashSet<InstanceStatus>(limitResultsByStatus);
                if (limitSet.equals(this.availableStates)) {
                    states.add("__state = 'DELETED'");
                    states.add("__state = 'ACTIVE'");
                } else if (limitSet.size() == 1 && limitSet.contains(InstanceStatus.DELETED)) {
                    states.add("__state = 'DELETED'");
                } else if (limitSet.size() == 1 && limitSet.contains(InstanceStatus.ACTIVE)) {
                    states.add("__state = 'ACTIVE'");
                } else {
                    OMRSErrorCode errorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, ((Object)((Object)this)).getClass().getName(), this.repositoryName});
                    throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                if (!states.isEmpty()) {
                    if (!bWhereClauseAdded) {
                        sb.append(" where");
                    }
                    sb.append(" ");
                    sb.append(String.join((CharSequence)" or ", states));
                }
            }
            if (sequencingOrder != null) {
                switch (sequencingOrder) {
                    case GUID: {
                        sb.append(" orderby __guid asc");
                        break;
                    }
                    case LAST_UPDATE_OLDEST: {
                        sb.append(" orderby __modificationTimestamp asc");
                        break;
                    }
                    case LAST_UPDATE_RECENT: {
                        sb.append(" orderby __modificationTimestamp desc");
                        break;
                    }
                    case CREATION_DATE_OLDEST: {
                        sb.append(" orderby __timestamp asc");
                        break;
                    }
                    case CREATION_DATE_RECENT: {
                        sb.append(" orderby __timestamp desc");
                        break;
                    }
                    case PROPERTY_ASCENDING: {
                        String atlasPropertyName;
                        if (sequencingProperty != null) {
                            atlasPropertyName = omrsPropertyMap.get(sequencingProperty);
                            if (atlasPropertyName != null) {
                                sb.append(" orderby ");
                                sb.append(atlasPropertyName);
                                sb.append(" asc");
                                break;
                            }
                            if (log.isWarnEnabled()) {
                                log.warn("Unable to find mapped Atlas property for sorting for: {}", (Object)sequencingProperty);
                            }
                            sb.append(" orderby __guid asc");
                            break;
                        }
                        if (log.isWarnEnabled()) {
                            log.warn("No property for sorting provided, defaulting to GUID.");
                        }
                        sb.append(" orderby __guid asc");
                        break;
                    }
                    case PROPERTY_DESCENDING: {
                        String atlasPropertyName;
                        if (sequencingProperty != null) {
                            atlasPropertyName = omrsPropertyMap.get(sequencingProperty);
                            if (atlasPropertyName != null) {
                                sb.append(" orderby ");
                                sb.append(atlasPropertyName);
                                sb.append(" desc");
                                break;
                            }
                            if (log.isWarnEnabled()) {
                                log.warn("Unable to find mapped Atlas property for sorting for: {}", (Object)sequencingProperty);
                            }
                            sb.append(" orderby __guid asc");
                            break;
                        }
                        if (log.isWarnEnabled()) {
                            log.warn("No property for sorting provided, defaulting to GUID.");
                        }
                        sb.append(" orderby __guid desc");
                        break;
                    }
                }
            }
            if (pageSize > 0) {
                sb.append(" limit ");
                sb.append(pageSize);
            }
            if (fromEntityElement > 0) {
                sb.append(" offset ");
                sb.append(fromEntityElement);
            }
            AtlasSearchResult results = null;
            try {
                results = this.atlasRepositoryConnector.searchWithDSL(sb.toString());
            }
            catch (AtlasServiceException e) {
                this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.INVALID_SEARCH, methodName, e, sb.toString());
            }
            if (results == null) continue;
            totalResults.add(results);
        }
        return this.combineMultipleResults(totalResults);
    }

    private List<AtlasEntityHeader> buildAndRunBasicSearch(String methodName, String entityTypeGUID, String limitResultsByClassification, InstanceProperties matchProperties, MatchCriteria matchCriteria, String fullTextQuery, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, int pageSize) throws FunctionNotSupportedException, RepositoryErrorException {
        String omrsTypeName = null;
        Map<Object, Object> atlasTypeNamesByPrefix = new HashMap();
        if (entityTypeGUID != null) {
            TypeDef typeDef = this.typeDefStore.getTypeDefByGUID(entityTypeGUID);
            if (typeDef != null) {
                omrsTypeName = typeDef.getName();
                atlasTypeNamesByPrefix = this.typeDefStore.getAllMappedAtlasTypeDefNames(omrsTypeName);
            } else if (log.isWarnEnabled()) {
                log.warn("Unable to search for type, unknown to repository: {}", (Object)entityTypeGUID);
            }
        } else {
            atlasTypeNamesByPrefix.put(null, null);
        }
        ArrayList<AtlasSearchResult> totalResults = new ArrayList<AtlasSearchResult>();
        for (Map.Entry entry : atlasTypeNamesByPrefix.entrySet()) {
            String omrsPropertyName;
            String prefix = (String)entry.getKey();
            String atlasTypeName = (String)entry.getValue();
            SearchParameters searchParameters = new SearchParameters();
            if (atlasTypeName != null) {
                searchParameters.setTypeName(atlasTypeName);
            }
            searchParameters.setIncludeClassificationAttributes(true);
            searchParameters.setIncludeSubClassifications(true);
            searchParameters.setIncludeSubTypes(true);
            searchParameters.setOffset(fromEntityElement);
            searchParameters.setLimit(pageSize);
            Map<String, String> omrsPropertyMap = this.typeDefStore.getPropertyMappingsForOMRSTypeDef(omrsTypeName, prefix);
            Map<String, TypeDefAttribute> omrsAttrTypeDefs = this.typeDefStore.getAllTypeDefAttributesForName(omrsTypeName);
            ArrayList criteria = new ArrayList();
            if (matchProperties != null) {
                Map properties = matchProperties.getInstanceProperties();
                if (properties != null) {
                    for (Map.Entry entry2 : properties.entrySet()) {
                        omrsPropertyName = (String)entry2.getKey();
                        InstancePropertyValue value = (InstancePropertyValue)entry2.getValue();
                        this.addSearchConditionFromValue(criteria, omrsPropertyName, value, omrsPropertyMap, omrsAttrTypeDefs, matchCriteria != null && matchCriteria.equals((Object)MatchCriteria.NONE), false);
                    }
                }
            } else if (fullTextQuery != null) {
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setPrimitiveValue((Object)fullTextQuery);
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                for (Map.Entry<Object, Object> entry3 : omrsAttrTypeDefs.entrySet()) {
                    PrimitiveDef primitiveDef;
                    omrsPropertyName = (String)entry3.getKey();
                    TypeDefAttribute typeDefAttribute = (TypeDefAttribute)entry3.getValue();
                    log.debug("Considering attribute: {}", (Object)omrsPropertyName);
                    AttributeTypeDef attributeTypeDef = typeDefAttribute.getAttributeType();
                    if (!attributeTypeDef.getCategory().equals((Object)AttributeTypeDefCategory.PRIMITIVE) || !(primitiveDef = (PrimitiveDef)attributeTypeDef).getPrimitiveDefCategory().equals((Object)PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING)) continue;
                    log.debug(" ... attribute is a String, continuing ...");
                    if (!omrsPropertyMap.containsKey(omrsPropertyName)) continue;
                    String atlasPropertyName = omrsPropertyMap.get(omrsPropertyName);
                    log.debug(" ... attribute is mapped, to: {}", (Object)atlasPropertyName);
                    if (atlasPropertyName == null) continue;
                    log.debug(" ... adding criterion for value: {}", (Object)primitivePropertyValue);
                    this.addSearchConditionFromValue(criteria, omrsPropertyName, (InstancePropertyValue)primitivePropertyValue, omrsPropertyMap, omrsAttrTypeDefs, matchCriteria != null && matchCriteria.equals((Object)MatchCriteria.NONE), false);
                }
            }
            SearchParameters.FilterCriteria entityFilters = new SearchParameters.FilterCriteria();
            if (criteria.size() > 1) {
                entityFilters.setCriterion(criteria);
                if (matchCriteria != null) {
                    switch (matchCriteria) {
                        case NONE: 
                        case ALL: {
                            entityFilters.setCondition(SearchParameters.FilterCriteria.Condition.AND);
                            break;
                        }
                        case ANY: {
                            entityFilters.setCondition(SearchParameters.FilterCriteria.Condition.OR);
                        }
                    }
                } else if (fullTextQuery != null) {
                    entityFilters.setCondition(SearchParameters.FilterCriteria.Condition.OR);
                } else {
                    entityFilters.setCondition(SearchParameters.FilterCriteria.Condition.AND);
                }
            } else if (criteria.size() == 1) {
                entityFilters = (SearchParameters.FilterCriteria)criteria.get(0);
            }
            searchParameters.setEntityFilters(entityFilters);
            if (limitResultsByStatus != null) {
                HashSet<InstanceStatus> limitSet = new HashSet<InstanceStatus>(limitResultsByStatus);
                if (limitSet.equals(this.availableStates) || limitSet.size() == 1 && limitSet.contains(InstanceStatus.DELETED)) {
                    searchParameters.setExcludeDeletedEntities(false);
                } else if (limitSet.size() == 1 && limitSet.contains(InstanceStatus.ACTIVE)) {
                    searchParameters.setExcludeDeletedEntities(true);
                } else {
                    OMRSErrorCode oMRSErrorCode = OMRSErrorCode.METHOD_NOT_IMPLEMENTED;
                    String errorMessage = oMRSErrorCode.getErrorMessageId() + oMRSErrorCode.getFormattedErrorMessage(new String[]{methodName, ((Object)((Object)this)).getClass().getName(), this.repositoryName});
                    throw new FunctionNotSupportedException(oMRSErrorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, oMRSErrorCode.getSystemAction(), oMRSErrorCode.getUserAction());
                }
            }
            if (limitResultsByClassification != null) {
                searchParameters.setClassification(limitResultsByClassification);
            }
            AtlasSearchResult results = null;
            try {
                results = this.atlasRepositoryConnector.searchForEntities(searchParameters);
            }
            catch (AtlasServiceException atlasServiceException) {
                this.raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode.INVALID_SEARCH, methodName, atlasServiceException, searchParameters.toString());
            }
            if (results == null) continue;
            totalResults.add(results);
        }
        return this.combineMultipleResults(totalResults);
    }

    private List<AtlasEntityHeader> combineMultipleResults(List<AtlasSearchResult> resultsList) {
        if (resultsList == null || resultsList.isEmpty()) {
            return null;
        }
        if (resultsList.size() == 1) {
            return resultsList.get(0).getEntities();
        }
        ArrayList<AtlasEntityHeader> totalResults = new ArrayList<AtlasEntityHeader>();
        for (AtlasSearchResult result : resultsList) {
            List entityResults;
            if (result == null || (entityResults = result.getEntities()) == null) continue;
            totalResults.addAll(entityResults);
        }
        return totalResults;
    }

    private List<EntityDetail> sortAndLimitFinalResults(List<AtlasEntityHeader> results, String entityTypeGUID, int fromElement, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        List<Object> totalResults = new ArrayList<EntityDetail>();
        totalResults.addAll(this.getEntityDetailsFromAtlasResults(results, entityTypeGUID, userId));
        Comparator<EntityDetail> comparator = SequencingUtils.getEntityDetailComparator(sequencingOrder, sequencingProperty);
        if (comparator != null) {
            totalResults.sort(comparator);
        }
        int endOfPageMarker = Math.min(fromElement + pageSize, totalResults.size());
        if (fromElement != 0 || endOfPageMarker < totalResults.size()) {
            totalResults = totalResults.subList(fromElement, endOfPageMarker);
        }
        return totalResults;
    }

    private List<EntityDetail> getEntityDetailsFromAtlasResults(List<AtlasEntityHeader> atlasEntities, String entityTypeGUID, String userId) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        if (atlasEntities != null) {
            for (AtlasEntityHeader atlasEntityHeader : atlasEntities) {
                try {
                    EntityDetail detail = this.getEntityDetail(userId, atlasEntityHeader.getGuid());
                    if (detail != null) {
                        String typeName = detail.getType().getTypeDefName();
                        try {
                            TypeDef typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entityTypeGUID", entityTypeGUID, "getEntityDetailsFromAtlasResults");
                            if (!this.repositoryHelper.isTypeOf(this.repositoryName, typeName, typeDef.getName())) continue;
                            entityDetails.add(detail);
                        }
                        catch (TypeErrorException e) {
                            log.error("Unable to find any TypeDef for entityTypeGUID: {}", (Object)entityTypeGUID);
                        }
                        continue;
                    }
                    if (!log.isErrorEnabled()) continue;
                    log.error("Entity with GUID {} not known -- excluding from results.", (Object)atlasEntityHeader.getGuid());
                }
                catch (EntityNotKnownException e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error("Entity with GUID {} not known -- excluding from results.", (Object)atlasEntityHeader.getGuid());
                }
            }
        }
        return entityDetails;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> void addSearchConditionFromValue(List<T> criteria, String omrsPropertyName, InstancePropertyValue value, Map<String, String> omrsToAtlasPropertyMap, Map<String, TypeDefAttribute> omrsTypeDefAttrMap, boolean negateCondition, boolean dslQuery) throws FunctionNotSupportedException {
        String methodName = "addSearchConditionFromValue";
        if (omrsPropertyName != null) {
            String atlasPropertyName = omrsToAtlasPropertyMap.get(omrsPropertyName);
            if (atlasPropertyName != null) {
                SearchParameters.FilterCriteria atlasCriterion = new SearchParameters.FilterCriteria();
                StringBuilder sbCriterion = new StringBuilder();
                InstancePropertyCategory category = value.getInstancePropertyCategory();
                switch (category) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue actualValue = (PrimitivePropertyValue)value;
                        PrimitiveDefCategory primitiveType = actualValue.getPrimitiveDefCategory();
                        switch (primitiveType) {
                            case OM_PRIMITIVE_TYPE_BOOLEAN: 
                            case OM_PRIMITIVE_TYPE_SHORT: 
                            case OM_PRIMITIVE_TYPE_INT: 
                            case OM_PRIMITIVE_TYPE_LONG: 
                            case OM_PRIMITIVE_TYPE_FLOAT: 
                            case OM_PRIMITIVE_TYPE_DOUBLE: 
                            case OM_PRIMITIVE_TYPE_BIGINTEGER: 
                            case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                                String nonString = actualValue.getPrimitiveValue().toString();
                                atlasCriterion.setAttributeName(atlasPropertyName);
                                sbCriterion.append(atlasPropertyName);
                                if (negateCondition) {
                                    atlasCriterion.setOperator(SearchParameters.Operator.NEQ);
                                    sbCriterion.append(" != ");
                                } else {
                                    atlasCriterion.setOperator(SearchParameters.Operator.EQ);
                                    sbCriterion.append(" = ");
                                }
                                atlasCriterion.setAttributeValue(nonString);
                                sbCriterion.append(nonString);
                                if (dslQuery) {
                                    criteria.add(sbCriterion.toString());
                                    return;
                                }
                                criteria.add(atlasCriterion);
                                return;
                            }
                            case OM_PRIMITIVE_TYPE_BYTE: 
                            case OM_PRIMITIVE_TYPE_CHAR: {
                                String single = actualValue.getPrimitiveValue().toString();
                                atlasCriterion.setAttributeName(atlasPropertyName);
                                sbCriterion.append(atlasPropertyName);
                                if (negateCondition) {
                                    atlasCriterion.setOperator(SearchParameters.Operator.NEQ);
                                    sbCriterion.append(" != \"");
                                } else {
                                    atlasCriterion.setOperator(SearchParameters.Operator.EQ);
                                    sbCriterion.append(" = \"");
                                }
                                atlasCriterion.setAttributeValue(single);
                                sbCriterion.append(single);
                                sbCriterion.append("\"");
                                if (dslQuery) {
                                    criteria.add(sbCriterion.toString());
                                    return;
                                }
                                criteria.add(atlasCriterion);
                                return;
                            }
                            case OM_PRIMITIVE_TYPE_DATE: {
                                Long epoch = (Long)actualValue.getPrimitiveValue();
                                String formattedDate = this.ATLAS_DATE_FORMAT.format(new Date(epoch));
                                atlasCriterion.setAttributeName(atlasPropertyName);
                                sbCriterion.append(atlasPropertyName);
                                if (negateCondition) {
                                    atlasCriterion.setOperator(SearchParameters.Operator.NEQ);
                                    sbCriterion.append(" != \"");
                                } else {
                                    atlasCriterion.setOperator(SearchParameters.Operator.EQ);
                                    sbCriterion.append(" = \"");
                                }
                                atlasCriterion.setAttributeValue(formattedDate);
                                sbCriterion.append(formattedDate);
                                sbCriterion.append("\"");
                                if (dslQuery) {
                                    criteria.add(sbCriterion.toString());
                                    return;
                                }
                                criteria.add(atlasCriterion);
                                return;
                            }
                        }
                        atlasCriterion.setAttributeName(atlasPropertyName);
                        sbCriterion.append(atlasPropertyName);
                        String candidateValue = actualValue.getPrimitiveValue().toString();
                        String unqualifiedValue = this.repositoryHelper.getUnqualifiedLiteralString(candidateValue);
                        if (this.repositoryHelper.isContainsRegex(candidateValue)) {
                            sbCriterion.append(" LIKE \"*");
                            sbCriterion.append(unqualifiedValue);
                            sbCriterion.append("\"*");
                            atlasCriterion.setOperator(SearchParameters.Operator.CONTAINS);
                        } else if (this.repositoryHelper.isEndsWithRegex(candidateValue)) {
                            sbCriterion.append(" LIKE \"*");
                            sbCriterion.append(unqualifiedValue);
                            sbCriterion.append("\"");
                            atlasCriterion.setOperator(SearchParameters.Operator.ENDS_WITH);
                        } else if (this.repositoryHelper.isStartsWithRegex(candidateValue)) {
                            sbCriterion.append(" LIKE \"");
                            sbCriterion.append(unqualifiedValue);
                            sbCriterion.append("*\"");
                            atlasCriterion.setOperator(SearchParameters.Operator.STARTS_WITH);
                        } else if (this.repositoryHelper.isExactMatchRegex(candidateValue)) {
                            if (negateCondition) {
                                if (unqualifiedValue.equals("")) {
                                    atlasCriterion.setOperator(SearchParameters.Operator.NOT_NULL);
                                } else {
                                    atlasCriterion.setOperator(SearchParameters.Operator.NEQ);
                                }
                                sbCriterion.append(" != \"");
                            } else {
                                if (unqualifiedValue.equals("")) {
                                    atlasCriterion.setOperator(SearchParameters.Operator.IS_NULL);
                                } else {
                                    atlasCriterion.setOperator(SearchParameters.Operator.EQ);
                                }
                                sbCriterion.append(" = \"");
                            }
                            sbCriterion.append(unqualifiedValue);
                            sbCriterion.append("\"");
                        } else {
                            ApacheAtlasOMRSErrorCode errorCode = ApacheAtlasOMRSErrorCode.REGEX_NOT_IMPLEMENTED;
                            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.repositoryName, candidateValue);
                            throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ApacheAtlasOMRSMetadataCollection.class.getName(), "addSearchConditionFromValue", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                        }
                        atlasCriterion.setAttributeValue(unqualifiedValue);
                        if (dslQuery) {
                            criteria.add(sbCriterion.toString());
                            return;
                        }
                        criteria.add(atlasCriterion);
                        return;
                    }
                    case ENUM: {
                        String omrsEnumValue = ((EnumPropertyValue)value).getSymbolicName();
                        TypeDefAttribute typeDefAttribute = omrsTypeDefAttrMap.get(omrsPropertyName);
                        if (typeDefAttribute != null) {
                            Map<String, String> elementMap = this.attributeTypeDefStore.getElementMappingsForOMRSTypeDef(typeDefAttribute.getAttributeName());
                            String atlasEnumValue = elementMap.get(omrsEnumValue);
                            if (atlasEnumValue != null) {
                                atlasCriterion.setAttributeName(atlasPropertyName);
                                sbCriterion.append(atlasPropertyName);
                                if (negateCondition) {
                                    atlasCriterion.setOperator(SearchParameters.Operator.NEQ);
                                    sbCriterion.append(" != \"");
                                } else {
                                    atlasCriterion.setOperator(SearchParameters.Operator.EQ);
                                    sbCriterion.append(" = \"");
                                }
                                atlasCriterion.setAttributeValue(atlasEnumValue);
                                sbCriterion.append(atlasEnumValue);
                                sbCriterion.append("\"");
                                if (dslQuery) {
                                    criteria.add(sbCriterion.toString());
                                    return;
                                }
                                criteria.add(atlasCriterion);
                                return;
                            }
                            if (!log.isWarnEnabled()) return;
                            log.warn("Unable to find mapped enum value for {}: {}", (Object)omrsPropertyName, (Object)omrsEnumValue);
                            return;
                        }
                        if (!log.isWarnEnabled()) return;
                        log.warn("Unable to find enum with name: {}", (Object)omrsPropertyName);
                        return;
                    }
                    case MAP: {
                        Map mapValues = ((MapPropertyValue)value).getMapValues().getInstanceProperties();
                        for (Map.Entry nextEntry : mapValues.entrySet()) {
                            this.addSearchConditionFromValue(criteria, (String)nextEntry.getKey(), (InstancePropertyValue)nextEntry.getValue(), omrsToAtlasPropertyMap, omrsTypeDefAttrMap, negateCondition, dslQuery);
                        }
                        return;
                    }
                    case ARRAY: {
                        Map arrayValues = ((ArrayPropertyValue)value).getArrayValues().getInstanceProperties();
                        for (Map.Entry nextEntry : arrayValues.entrySet()) {
                            this.addSearchConditionFromValue(criteria, atlasPropertyName, (InstancePropertyValue)nextEntry.getValue(), omrsToAtlasPropertyMap, omrsTypeDefAttrMap, negateCondition, dslQuery);
                        }
                        return;
                    }
                    default: {
                        if (!log.isWarnEnabled()) return;
                        log.warn("Unable to handle search criteria for value type: {}", (Object)category);
                    }
                }
                return;
            }
            if (!log.isWarnEnabled()) return;
            log.warn("Unable to add search condition, no mapped Atlas property for '{}': {}", (Object)omrsPropertyName, (Object)value);
            return;
        }
        if (!log.isWarnEnabled()) return;
        log.warn("Unable to add search condition, no OMRS property: {}", (Object)value);
    }

    public static final String getGuidFromGeneratedId(String guid) {
        if (ApacheAtlasOMRSMetadataCollection.isGeneratedGUID(guid)) {
            return guid.substring(guid.indexOf(GENERATED_TYPE_POSTFIX) + GENERATED_TYPE_POSTFIX.length());
        }
        return guid;
    }

    public static final String getPrefixFromGeneratedId(String guid) {
        if (ApacheAtlasOMRSMetadataCollection.isGeneratedGUID(guid)) {
            return guid.substring(GENERATED_TYPE_PREFIX.length(), guid.indexOf(GENERATED_TYPE_POSTFIX));
        }
        return null;
    }

    public static final boolean isGeneratedGUID(String guid) {
        return guid.startsWith(GENERATED_TYPE_PREFIX);
    }

    public static final String generateTypePrefix(String moniker) {
        return GENERATED_TYPE_PREFIX + moniker + GENERATED_TYPE_POSTFIX;
    }

    public static final String generateGuidWithPrefix(String moniker, String guid) {
        return (moniker == null ? "" : ApacheAtlasOMRSMetadataCollection.generateTypePrefix(moniker)) + guid;
    }

    private void raiseEntityNotKnownException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws EntityNotKnownException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), cause);
    }

    private void raiseRelationshipNotKnownException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws RelationshipNotKnownException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new RelationshipNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), cause);
    }

    private void raiseRepositoryErrorException(ApacheAtlasOMRSErrorCode errorCode, String methodName, Throwable cause, String ... params) throws RepositoryErrorException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(params);
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), cause);
    }
}

